/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.www.soap.eutils.efetch_pubmed;

import gov.nih.nlm.ncbi.www.soap.eutils.efetch_pubmed.AuthorType;
import gov.nih.nlm.ncbi.www.soap.eutils.efetch_pubmed.CompleteYN_type0;
import gov.nih.nlm.ncbi.www.soap.eutils.efetch_pubmed.ExtensionMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.llom.OMSourcedElementImpl;
import org.apache.axis2.databinding.ADBBean;
import org.apache.axis2.databinding.ADBDataSource;
import org.apache.axis2.databinding.ADBException;
import org.apache.axis2.databinding.utils.BeanUtil;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.axis2.databinding.utils.reader.ADBXMLStreamReaderImpl;
import org.apache.axis2.databinding.utils.writer.MTOMAwareXMLStreamWriter;

public class AuthorListType
implements ADBBean {
    protected AuthorType[] localAuthor;
    protected CompleteYN_type0 localCompleteYN;

    private static String generatePrefix(String namespace) {
        if (namespace.equals("http://www.ncbi.nlm.nih.gov/soap/eutils/efetch_pubmed")) {
            return "ns1";
        }
        return BeanUtil.getUniquePrefix();
    }

    public AuthorType[] getAuthor() {
        return this.localAuthor;
    }

    protected void validateAuthor(AuthorType[] param) {
        if (param != null && param.length < 1) {
            throw new RuntimeException();
        }
    }

    public void setAuthor(AuthorType[] param) {
        this.validateAuthor(param);
        this.localAuthor = param;
    }

    public void addAuthor(AuthorType param) {
        if (this.localAuthor == null) {
            this.localAuthor = new AuthorType[0];
        }
        List list = ConverterUtil.toList((Object[])this.localAuthor);
        list.add(param);
        this.localAuthor = list.toArray(new AuthorType[list.size()]);
    }

    public CompleteYN_type0 getCompleteYN() {
        return this.localCompleteYN;
    }

    public void setCompleteYN(CompleteYN_type0 param) {
        this.localCompleteYN = param;
    }

    public static boolean isReaderMTOMAware(XMLStreamReader reader) {
        boolean isReaderMTOMAware = false;
        try {
            isReaderMTOMAware = Boolean.TRUE.equals(reader.getProperty("IsDatahandlersAwareParsing"));
        }
        catch (IllegalArgumentException e) {
            isReaderMTOMAware = false;
        }
        return isReaderMTOMAware;
    }

    public OMElement getOMElement(QName parentQName, final OMFactory factory) throws ADBException {
        ADBDataSource dataSource = new ADBDataSource(this, parentQName){

            public void serialize(MTOMAwareXMLStreamWriter xmlWriter) throws XMLStreamException {
                AuthorListType.this.serialize(this.parentQName, factory, xmlWriter);
            }
        };
        return new OMSourcedElementImpl(parentQName, factory, (OMDataSource)dataSource);
    }

    public void serialize(QName parentQName, OMFactory factory, MTOMAwareXMLStreamWriter xmlWriter) throws XMLStreamException, ADBException {
        this.serialize(parentQName, factory, xmlWriter, false);
    }

    public void serialize(QName parentQName, OMFactory factory, MTOMAwareXMLStreamWriter xmlWriter, boolean serializeType) throws XMLStreamException, ADBException {
        String prefix = null;
        String namespace = null;
        prefix = parentQName.getPrefix();
        namespace = parentQName.getNamespaceURI();
        if (namespace != null && namespace.trim().length() > 0) {
            String writerPrefix = xmlWriter.getPrefix(namespace);
            if (writerPrefix != null) {
                xmlWriter.writeStartElement(namespace, parentQName.getLocalPart());
            } else {
                if (prefix == null) {
                    prefix = AuthorListType.generatePrefix(namespace);
                }
                xmlWriter.writeStartElement(prefix, parentQName.getLocalPart(), namespace);
                xmlWriter.writeNamespace(prefix, namespace);
                xmlWriter.setPrefix(prefix, namespace);
            }
        } else {
            xmlWriter.writeStartElement(parentQName.getLocalPart());
        }
        if (serializeType) {
            String namespacePrefix = this.registerPrefix((XMLStreamWriter)xmlWriter, "http://www.ncbi.nlm.nih.gov/soap/eutils/efetch_pubmed");
            if (namespacePrefix != null && namespacePrefix.trim().length() > 0) {
                this.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", namespacePrefix + ":AuthorListType", (XMLStreamWriter)xmlWriter);
            } else {
                this.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", "AuthorListType", (XMLStreamWriter)xmlWriter);
            }
        }
        if (this.localCompleteYN != null) {
            this.writeAttribute("", "CompleteYN", this.localCompleteYN.toString(), (XMLStreamWriter)xmlWriter);
        }
        if (this.localAuthor != null) {
            for (int i = 0; i < this.localAuthor.length; ++i) {
                if (this.localAuthor[i] == null) {
                    throw new ADBException("Author cannot be null!!");
                }
                this.localAuthor[i].serialize(new QName("http://www.ncbi.nlm.nih.gov/soap/eutils/efetch_pubmed", "Author"), factory, xmlWriter);
            }
        } else {
            throw new ADBException("Author cannot be null!!");
        }
        xmlWriter.writeEndElement();
    }

    private void writeAttribute(String prefix, String namespace, String attName, String attValue, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (xmlWriter.getPrefix(namespace) == null) {
            xmlWriter.writeNamespace(prefix, namespace);
            xmlWriter.setPrefix(prefix, namespace);
        }
        xmlWriter.writeAttribute(namespace, attName, attValue);
    }

    private void writeAttribute(String namespace, String attName, String attValue, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (namespace.equals("")) {
            xmlWriter.writeAttribute(attName, attValue);
        } else {
            this.registerPrefix(xmlWriter, namespace);
            xmlWriter.writeAttribute(namespace, attName, attValue);
        }
    }

    private void writeQNameAttribute(String namespace, String attName, QName qname, XMLStreamWriter xmlWriter) throws XMLStreamException {
        String attributeNamespace = qname.getNamespaceURI();
        String attributePrefix = xmlWriter.getPrefix(attributeNamespace);
        if (attributePrefix == null) {
            attributePrefix = this.registerPrefix(xmlWriter, attributeNamespace);
        }
        String attributeValue = attributePrefix.trim().length() > 0 ? attributePrefix + ":" + qname.getLocalPart() : qname.getLocalPart();
        if (namespace.equals("")) {
            xmlWriter.writeAttribute(attName, attributeValue);
        } else {
            this.registerPrefix(xmlWriter, namespace);
            xmlWriter.writeAttribute(namespace, attName, attributeValue);
        }
    }

    private void writeQName(QName qname, XMLStreamWriter xmlWriter) throws XMLStreamException {
        String namespaceURI = qname.getNamespaceURI();
        if (namespaceURI != null) {
            String prefix = xmlWriter.getPrefix(namespaceURI);
            if (prefix == null) {
                prefix = AuthorListType.generatePrefix(namespaceURI);
                xmlWriter.writeNamespace(prefix, namespaceURI);
                xmlWriter.setPrefix(prefix, namespaceURI);
            }
            if (prefix.trim().length() > 0) {
                xmlWriter.writeCharacters(prefix + ":" + ConverterUtil.convertToString((QName)qname));
            } else {
                xmlWriter.writeCharacters(ConverterUtil.convertToString((QName)qname));
            }
        } else {
            xmlWriter.writeCharacters(ConverterUtil.convertToString((QName)qname));
        }
    }

    private void writeQNames(QName[] qnames, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (qnames != null) {
            StringBuffer stringToWrite = new StringBuffer();
            String namespaceURI = null;
            String prefix = null;
            for (int i = 0; i < qnames.length; ++i) {
                if (i > 0) {
                    stringToWrite.append(" ");
                }
                if ((namespaceURI = qnames[i].getNamespaceURI()) != null) {
                    prefix = xmlWriter.getPrefix(namespaceURI);
                    if (prefix == null || prefix.length() == 0) {
                        prefix = AuthorListType.generatePrefix(namespaceURI);
                        xmlWriter.writeNamespace(prefix, namespaceURI);
                        xmlWriter.setPrefix(prefix, namespaceURI);
                    }
                    if (prefix.trim().length() > 0) {
                        stringToWrite.append(prefix).append(":").append(ConverterUtil.convertToString((QName)qnames[i]));
                        continue;
                    }
                    stringToWrite.append(ConverterUtil.convertToString((QName)qnames[i]));
                    continue;
                }
                stringToWrite.append(ConverterUtil.convertToString((QName)qnames[i]));
            }
            xmlWriter.writeCharacters(stringToWrite.toString());
        }
    }

    private String registerPrefix(XMLStreamWriter xmlWriter, String namespace) throws XMLStreamException {
        String prefix = xmlWriter.getPrefix(namespace);
        if (prefix == null) {
            prefix = AuthorListType.generatePrefix(namespace);
            while (xmlWriter.getNamespaceContext().getNamespaceURI(prefix) != null) {
                prefix = BeanUtil.getUniquePrefix();
            }
            xmlWriter.writeNamespace(prefix, namespace);
            xmlWriter.setPrefix(prefix, namespace);
        }
        return prefix;
    }

    public XMLStreamReader getPullParser(QName qName) throws ADBException {
        ArrayList<Object> elementList = new ArrayList<Object>();
        ArrayList<Object> attribList = new ArrayList<Object>();
        if (this.localAuthor != null) {
            for (int i = 0; i < this.localAuthor.length; ++i) {
                if (this.localAuthor[i] == null) {
                    throw new ADBException("Author cannot be null !!");
                }
                elementList.add(new QName("http://www.ncbi.nlm.nih.gov/soap/eutils/efetch_pubmed", "Author"));
                elementList.add(this.localAuthor[i]);
            }
        } else {
            throw new ADBException("Author cannot be null!!");
        }
        attribList.add(new QName("", "CompleteYN"));
        attribList.add(this.localCompleteYN.toString());
        return new ADBXMLStreamReaderImpl(qName, elementList.toArray(), attribList.toArray());
    }

    public static class Factory {
        public static AuthorListType parse(XMLStreamReader reader) throws Exception {
            AuthorListType object = new AuthorListType();
            Object nillableValue = null;
            String prefix = "";
            String namespaceuri = "";
            try {
                String fullTypeName;
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type") != null && (fullTypeName = reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) != null) {
                    String nsPrefix = null;
                    if (fullTypeName.indexOf(":") > -1) {
                        nsPrefix = fullTypeName.substring(0, fullTypeName.indexOf(":"));
                    }
                    nsPrefix = nsPrefix == null ? "" : nsPrefix;
                    String type = fullTypeName.substring(fullTypeName.indexOf(":") + 1);
                    if (!"AuthorListType".equals(type)) {
                        String nsUri = reader.getNamespaceContext().getNamespaceURI(nsPrefix);
                        return (AuthorListType)ExtensionMapper.getTypeObject(nsUri, type, reader);
                    }
                }
                Vector<String> handledAttributes = new Vector<String>();
                String tempAttribCompleteYN = reader.getAttributeValue(null, "CompleteYN");
                if (tempAttribCompleteYN != null) {
                    String content = tempAttribCompleteYN;
                    object.setCompleteYN(CompleteYN_type0.Factory.fromString(reader, tempAttribCompleteYN));
                }
                handledAttributes.add("CompleteYN");
                reader.next();
                ArrayList<AuthorType> list1 = new ArrayList<AuthorType>();
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.isStartElement() && new QName("http://www.ncbi.nlm.nih.gov/soap/eutils/efetch_pubmed", "Author").equals(reader.getName())) {
                    list1.add(AuthorType.Factory.parse(reader));
                    boolean loopDone1 = false;
                    while (!loopDone1) {
                        while (!reader.isEndElement()) {
                            reader.next();
                        }
                        reader.next();
                        while (!reader.isStartElement() && !reader.isEndElement()) {
                            reader.next();
                        }
                        if (reader.isEndElement()) {
                            loopDone1 = true;
                            continue;
                        }
                        if (new QName("http://www.ncbi.nlm.nih.gov/soap/eutils/efetch_pubmed", "Author").equals(reader.getName())) {
                            list1.add(AuthorType.Factory.parse(reader));
                            continue;
                        }
                        loopDone1 = true;
                    }
                    object.setAuthor((AuthorType[])ConverterUtil.convertToArray(AuthorType.class, list1));
                } else {
                    throw new ADBException("Unexpected subelement " + reader.getLocalName());
                }
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.isStartElement()) {
                    throw new ADBException("Unexpected subelement " + reader.getLocalName());
                }
            }
            catch (XMLStreamException e) {
                throw new Exception(e);
            }
            return object;
        }
    }
}

