/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.RBFN;

import java.util.Enumeration;
import java.util.Hashtable;
import keel.Algorithms.Neural_Networks.RBFN.RBFUtils;
import keel.Algorithms.Neural_Networks.RBFN.Rbf;
import org.core.Files;
import org.core.Randomize;

public class Rbfn {
    int nRbfs;
    int nInptuts;
    int nOutputs;
    Hashtable rbfn = new Hashtable();

    public Rbfn() {
        this.nRbfs = 0;
        this.nInptuts = 1;
        this.nOutputs = 1;
        Rbf neurona = new Rbf(1, 1);
        double[] centre = new double[1];
        double[] weights = new double[1];
        centre[0] = 1.0;
        double radius = 0.3;
        weights[0] = 0.0;
        neurona.setParam(centre, radius, weights);
        this.insertRbf((Rbf)neurona.clone());
        centre[0] = 2.0;
        radius = 0.2;
        weights[0] = 0.0;
        neurona.setParam(centre, radius, weights);
        this.insertRbf((Rbf)neurona.clone());
        centre[0] = 2.5;
        radius = 0.1;
        weights[0] = 0.0;
        neurona.setParam(centre, radius, weights);
        this.insertRbf((Rbf)neurona.clone());
        centre[0] = 2.8;
        radius = 0.3;
        weights[0] = 0.0;
        neurona.setParam(centre, radius, weights);
        this.insertRbf((Rbf)neurona.clone());
        centre[0] = 3.0;
        radius = 0.1;
        weights[0] = 0.0;
        neurona.setParam(centre, radius, weights);
        this.insertRbf((Rbf)neurona.clone());
        centre[0] = 3.3;
        radius = 0.2;
        weights[0] = 0.0;
        neurona.setParam(centre, radius, weights);
        this.insertRbf((Rbf)neurona.clone());
    }

    public Rbfn(int numInpt, int numOutp) {
        this.nRbfs = 0;
        this.nInptuts = numInpt;
        this.nOutputs = numOutp;
    }

    protected double euclideanDist(double[] v1, double[] v2) {
        double aux = 0.0;
        for (int i = 0; i < this.nInptuts; ++i) {
            aux += (v1[i] - v2[i]) * (v1[i] - v2[i]);
        }
        return Math.sqrt(aux);
    }

    public Rbfn(double[][] X, int ndata, int nInpt, int nOutp, int nNeuro) {
        double E;
        int j;
        int i;
        this.nRbfs = 0;
        this.nInptuts = nInpt;
        this.nOutputs = nOutp;
        int iterations = 0;
        double minError = 1.0;
        int maxIter = 1000;
        int[] centreOf = new int[ndata];
        int[] elemsCluster = new int[nNeuro];
        double[] weights = new double[this.nOutputs];
        for (i = 0; i < this.nOutputs; ++i) {
            weights[i] = 1.0;
        }
        double[][] centres = new double[nNeuro][this.nInptuts];
        double[][] prevCentres = null;
        for (i = 0; i < nNeuro; ++i) {
            int m;
            int ran = Randomize.Randint(0, ndata - 1);
            centres[i] = X[ran];
            boolean exists = false;
            for (j = 0; j < i && !exists; ++j) {
                exists = true;
                for (m = 0; m < this.nInptuts && exists; ++m) {
                    if (centres[i][m] == centres[j][m]) continue;
                    exists = false;
                }
            }
            if (!exists) continue;
            int inicial = ran;
            do {
                ran = (ran + 1) % ndata;
                centres[i] = X[ran];
                exists = false;
                for (j = 0; j < i && !exists; ++j) {
                    exists = true;
                    for (m = 0; m < this.nInptuts && exists; ++m) {
                        if (centres[i][m] == centres[j][m]) continue;
                        exists = false;
                    }
                }
            } while (exists && ran != inicial);
        }
        double prevE = 0.0;
        do {
            for (j = 0; j < nNeuro; ++j) {
                elemsCluster[j] = 0;
            }
            for (i = 0; i < ndata; ++i) {
                double distmin = Double.MAX_VALUE;
                for (j = 0; j < nNeuro; ++j) {
                    double dist = this.euclideanDist(X[i], centres[j]);
                    if (!(dist < distmin)) continue;
                    distmin = dist;
                    centreOf[i] = j;
                }
                int n = centreOf[i];
                elemsCluster[n] = elemsCluster[n] + 1;
            }
            prevCentres = centres;
            centres = new double[nNeuro][this.nInptuts];
            for (i = 0; i < ndata; ++i) {
                for (j = 0; j < this.nInptuts; ++j) {
                    double[] dArray = centres[centreOf[i]];
                    int n = j;
                    dArray[n] = dArray[n] + X[i][j];
                }
            }
            for (i = 0; i < nNeuro; ++i) {
                for (j = 0; j < this.nInptuts; ++j) {
                    if (elemsCluster[i] == 0) continue;
                    double[] dArray = centres[i];
                    int n = j;
                    dArray[n] = dArray[n] / (double)elemsCluster[i];
                }
            }
            boolean changeCentres = false;
            for (i = 0; i < nNeuro && !changeCentres; ++i) {
                for (j = 0; j < this.nInptuts && !changeCentres; ++j) {
                    if (centres[i][j] == prevCentres[i][j]) continue;
                    changeCentres = true;
                    iterations = maxIter;
                    System.out.println("iterations of RBFs - no change on centers");
                }
            }
            E = 0.0;
            for (i = 0; i < ndata; ++i) {
                E += this.euclideanDist(X[i], centres[centreOf[i]]);
            }
            ++iterations;
            if (Math.abs(prevE - E) == 0.0) {
                iterations = maxIter;
            } else {
                prevE = E;
            }
            System.out.println("iterations of RBFs - " + iterations);
            System.out.println("error of RBFs - " + E);
        } while (E > minError && iterations < maxIter);
        for (i = 0; i < nNeuro; ++i) {
            double radius = RBFUtils.geomDistance(centres[i], i, centres);
            if (radius <= 0.0) {
                radius = RBFUtils.avegDistance(centres) / 2.0;
            }
            Rbf neurona = new Rbf(this.nInptuts, this.nOutputs);
            neurona.setParam(centres[i], radius, weights, elemsCluster[i]);
            this.insertRbf((Rbf)neurona.clone());
        }
    }

    public Rbfn(int nNeuro, double[][] X, int ndata, int nInpt, int nOutpl) {
        int i;
        int[] vaux = new int[ndata];
        this.nRbfs = 0;
        this.nInptuts = nInpt;
        this.nOutputs = nOutpl;
        double[] weights = new double[this.nOutputs];
        for (i = 0; i < this.nOutputs; ++i) {
            weights[i] = 0.0;
        }
        double[][] centres = new double[nNeuro][this.nInptuts];
        for (i = 0; i < nNeuro; ++i) {
            int j;
            int ran;
            boolean flag;
            int cont = 0;
            do {
                ran = Randomize.Randint(0, ndata - 1);
                flag = false;
                j = 0;
                ++cont;
                do {
                    if (vaux[j++] != ran) continue;
                    flag = true;
                } while (j < i && !flag && j < ndata);
            } while (flag && cont < ndata);
            centres[i] = X[ran];
            if (j >= ndata) continue;
            vaux[j] = ran;
        }
        double radius = RBFUtils.avegDistance(centres) / 2.0;
        for (i = 0; i < nNeuro; ++i) {
            Rbf neuron = new Rbf(this.nInptuts, this.nOutputs);
            neuron.setParam(centres[i], radius, weights);
            this.insertRbf((Rbf)neuron.clone());
        }
    }

    public void removeRbf(String idRbf) {
        this.rbfn.remove(idRbf);
        --this.nRbfs;
    }

    public void insertRbf(Rbf rbf) {
        rbf.idRbf = String.valueOf(this.nRbfs);
        this.rbfn.put(rbf.idRbf, rbf);
        ++this.nRbfs;
    }

    public void modifyRbf(Rbf rbf, String idRbf) {
        this.removeRbf(idRbf);
        rbf.idRbf = idRbf;
        this.rbfn.put(rbf.idRbf, rbf);
        ++this.nRbfs;
    }

    public int size() {
        return this.nRbfs;
    }

    public Rbf getRbf(String id) {
        return (Rbf)this.rbfn.get(id);
    }

    public String[] getIndex() {
        String[] vect = new String[this.size()];
        Enumeration aEnum = this.rbfn.keys();
        int i = 0;
        while (aEnum.hasMoreElements()) {
            vect[i] = (String)aEnum.nextElement();
            ++i;
        }
        return vect;
    }

    public double[] evaluationRbfn(double[] _input) {
        double[] aux = new double[this.nOutputs];
        for (int i = 0; i < this.nOutputs; ++i) {
            aux[i] = 0.0;
            Enumeration it = this.rbfn.elements();
            while (it.hasMoreElements()) {
                Rbf rbf = (Rbf)it.nextElement();
                int n = i;
                aux[n] = aux[n] + rbf.evaluationRbf(_input) * rbf.weight[i];
            }
        }
        return aux;
    }

    public double[] errorRbfn(double[] realOutput, double[] netOutput) {
        double[] error = new double[this.nOutputs];
        for (int i = 0; i < this.nOutputs; ++i) {
            error[i] = realOutput[i] - netOutput[i];
        }
        return error;
    }

    public String rbfNearest(double[] v) {
        String key = "nula";
        double distmin = Double.POSITIVE_INFINITY;
        int nrbf = this.size();
        String[] vect = this.getIndex();
        for (int i = 0; i < this.nRbfs; ++i) {
            Rbf rbf = this.getRbf(vect[i]);
            double dist = rbf.euclideaDist(v);
            if (!(dist < distmin)) continue;
            distmin = dist;
            key = vect[i];
        }
        return key;
    }

    public void RAN(double[][] X, double[][] Y, int ndata, double delta, double epsilon, double alfa) {
        try {
            int i;
            double[] centre = new double[this.nInptuts];
            double radius = 1.0;
            double[] weights = new double[this.nOutputs];
            double[] patternInputs = new double[this.nInptuts];
            double[] patternOutputs = new double[this.nOutputs];
            double[] outputNet = new double[this.nOutputs];
            double[] error = new double[this.nOutputs];
            int nInpt = this.nInptuts;
            double maxOutp = 0.0;
            int nOutp = this.nOutputs;
            int M = 60;
            double thres = 1.0E-5;
            int cont = 0;
            int[] aleat = new int[ndata];
            int numVectorSeleccionado = Randomize.Randint(0, ndata - 1);
            patternInputs = X[numVectorSeleccionado];
            patternOutputs = Y[numVectorSeleccionado];
            for (i = 0; i < ndata; ++i) {
                aleat[i] = i;
            }
            double factor = delta * Math.log10(this.nInptuts);
            do {
                int ran = Randomize.Randint(0, ndata - cont - 1);
                numVectorSeleccionado = aleat[ran];
                aleat[ran] = aleat[ndata - cont - 1];
                patternInputs = X[numVectorSeleccionado];
                patternOutputs = Y[numVectorSeleccionado];
                outputNet = this.evaluationRbfn(patternInputs);
                error = this.errorRbfn(patternOutputs, outputNet);
                String key = this.rbfNearest(patternInputs);
                Rbf rbf = this.getRbf(key);
                double dist = rbf.euclideaDist(patternInputs);
                double errori = 0.0;
                for (i = 0; i < this.nOutputs; ++i) {
                    if (!(Math.abs(error[i]) > epsilon)) continue;
                    errori = error[i];
                }
                if (Math.abs(errori) > epsilon && dist > delta) {
                    rbf = new Rbf(this.nInptuts, this.nOutputs);
                    rbf.setParam(patternInputs, 1.0 * dist, error);
                    this.insertRbf((Rbf)rbf.clone());
                    for (i = 0; i < ndata; ++i) {
                        aleat[i] = (i + cont) % ndata;
                    }
                    cont = 0;
                    continue;
                }
                centre = rbf.getCentre();
                weights = rbf.getWeights();
                radius = rbf.getRadius();
                for (i = 0; i < this.nOutputs; ++i) {
                    weights[i] = weights[i] + alfa * errori * rbf.evaluationRbf(patternInputs);
                }
                for (i = 0; i < this.nInptuts; ++i) {
                    centre[i] = centre[i] + 2.0 * (alfa / radius) * (patternInputs[i] - centre[i]) * rbf.evaluationRbf(patternInputs) * (errori * weights[0]);
                }
                rbf.setCentre(centre);
                rbf.setWeight(weights);
                ++cont;
            } while (cont < ndata);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InternalError(e.toString());
        }
    }

    public void decremental(double[][] X, double[][] Y, int ndata, double percent, double alfa) {
        int nrbf;
        int cont = 0;
        int[] aleat = new int[ndata];
        double[] centre = new double[this.nInptuts];
        double[] weights = new double[this.nOutputs];
        double[] medWeights = new double[this.nOutputs];
        double[] patternInputs = new double[this.nInptuts];
        double[] patternOutput = new double[this.nOutputs];
        double[] outputNet = new double[this.nOutputs];
        double[] error = new double[this.nOutputs];
        double[][] vaux = new double[this.nRbfs][this.nOutputs];
        double epsilon = 0.1;
        double delta = 2.0;
        double factor = 0.0;
        int nrbfnini = nrbf = this.size();
        String[] vect = this.getIndex();
        this.trainLMS(X, Y, ndata, 10, alfa);
        try {
            do {
                double radius;
                double weight;
                int j;
                Rbf rbf;
                int i;
                double weightmed = 0.0;
                vaux = new double[nrbf][this.nOutputs];
                for (i = 0; i < nrbf; ++i) {
                    rbf = this.getRbf(vect[i]);
                    for (j = 0; j < this.nOutputs; ++j) {
                        vaux[i][j] = Math.abs(rbf.getWeight(j));
                    }
                }
                medWeights = RBFUtils.medVect(vaux);
                for (j = 0; j < this.nOutputs; ++j) {
                    if (!(medWeights[j] > weightmed)) continue;
                    weightmed = medWeights[j];
                }
                for (i = 0; i < nrbf; ++i) {
                    rbf = this.getRbf(vect[i]);
                    weight = 0.0;
                    for (j = 0; j < this.nOutputs; ++j) {
                        if (!(Math.abs(rbf.getWeight(j)) > weight)) continue;
                        weight = Math.abs(rbf.getWeight(j));
                    }
                    if (!(Math.abs(weight) < percent * weightmed)) continue;
                    this.removeRbf(vect[i]);
                    cont = 0;
                }
                vect = this.getIndex();
                nrbf = this.size();
                for (j = 0; j < nrbf; ++j) {
                    int k;
                    rbf = this.getRbf(vect[j]);
                    weights = rbf.getWeights();
                    weight = 0.0;
                    for (k = 0; k < this.nOutputs; ++k) {
                        if (!(weights[k] > weight)) continue;
                        weight = weights[k];
                    }
                    if (!(weight < weightmed)) continue;
                    centre = rbf.getCentre();
                    radius = rbf.getRadius();
                    k = 0;
                    while (k < this.nInptuts) {
                        radius += Randomize.Randdouble(-radius * 0.05, radius * 0.05);
                        int n = k++;
                        centre[n] = centre[n] + Randomize.Randdouble(-radius * 0.05, radius * 0.05);
                    }
                    rbf.setRadius(radius);
                    rbf.setCentre(centre);
                }
                int inst = 0;
                for (i = 0; i < ndata; ++i) {
                    aleat[i] = i;
                }
                do {
                    int ran = Randomize.Randint(0, ndata - inst - 1);
                    int numVectorSeleccionado = aleat[ran];
                    aleat[ran] = aleat[ndata - inst - 1];
                    patternInputs = X[numVectorSeleccionado];
                    patternOutput = Y[numVectorSeleccionado];
                    outputNet = this.evaluationRbfn(patternInputs);
                    error = this.errorRbfn(patternOutput, outputNet);
                    String key = this.rbfNearest(patternInputs);
                    rbf = this.getRbf(key);
                    double dist = rbf.euclideaDist(patternInputs);
                    double errori = 0.0;
                    for (i = 0; i < this.nOutputs; ++i) {
                        if (!(Math.abs(error[i]) > epsilon)) continue;
                        errori = error[i];
                    }
                    centre = rbf.getCentre();
                    weights = rbf.getWeights();
                    radius = rbf.getRadius();
                    for (i = 0; i < this.nOutputs; ++i) {
                        weights[i] = weights[i] + alfa * errori * rbf.evaluationRbf(patternInputs);
                    }
                    for (i = 0; i < this.nInptuts; ++i) {
                        centre[i] = centre[i] + 2.0 * (alfa / radius) * (patternInputs[i] - centre[i]) * rbf.evaluationRbf(patternInputs) * (errori * weights[0]);
                    }
                    rbf.setCentre(centre);
                    rbf.setWeight(weights);
                } while (++inst < ndata);
            } while (++cont < 15 && nrbf > 0);
            System.out.println("Final num. RBFs obtained - " + this.nRbfs);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InternalError(e.toString());
        }
    }

    public void trainLMS(double[][] X, double[][] Y, int ndata, int iter, double alfa) {
        try {
            double[] error = new double[this.nOutputs];
            double[] centre = new double[this.nInptuts];
            int[] aleat = new int[ndata];
            int nInpt = this.nInptuts;
            int nOutpl = this.nOutputs;
            double nu_sigma = 5.0E-4;
            double nu_c = 5.0E-4;
            double sum = 0.0;
            double weight = 0.0;
            int ndataini = ndata;
            int nrbf = this.size();
            String[] vect = this.getIndex();
            double[] evaluation = new double[nrbf];
            RBFUtils.verboseln("Training RBFNN using LMS");
            for (int z = 0; z < iter; ++z) {
                int i;
                ndata = ndataini;
                RBFUtils.verboseln(" - LMS iteration num. " + (z + 1));
                RBFUtils.verboseln(" - Num. Muestras: " + ndata);
                for (i = 0; i < ndata; ++i) {
                    aleat[i] = i;
                }
                while (ndata > 0) {
                    Rbf rbf;
                    int j;
                    int ran = Randomize.Randint(0, ndata - 1);
                    int numVectorSeleccionado = aleat[ran];
                    aleat[ran] = aleat[--ndata];
                    double[] inputRed = X[numVectorSeleccionado];
                    double[] outputReal = Y[numVectorSeleccionado];
                    double[] outputNet = this.evaluationRbfn(inputRed);
                    error = new double[this.nOutputs];
                    for (i = 0; i < this.nOutputs; ++i) {
                        error[i] = outputReal[i] - outputNet[i];
                    }
                    for (i = 0; i < this.nOutputs; ++i) {
                        double modulo = 0.0;
                        for (j = 0; j < nrbf; ++j) {
                            rbf = this.getRbf(vect[j]);
                            evaluation[j] = rbf.evaluationRbf(inputRed);
                            modulo += evaluation[j] * evaluation[j];
                        }
                        if ((modulo = Math.sqrt(modulo)) == 0.0) {
                            modulo = Double.longBitsToDouble(0x10000000000000L);
                        }
                        for (j = 0; j < nrbf; ++j) {
                            rbf = this.getRbf(vect[j]);
                            weight = rbf.getWeight(i);
                            rbf.setWeight(i, weight += alfa * (error[i] * evaluation[j] / modulo));
                        }
                    }
                    for (i = 0; i < nrbf; ++i) {
                        rbf = this.getRbf(vect[i]);
                        centre = rbf.getCentre();
                        double radius = rbf.getRadius();
                        sum = 0.0;
                        double dif = 0.0;
                        for (int k = 0; k < this.nOutputs; ++k) {
                            weight = rbf.getWeight(k);
                            sum += (outputReal[k] - outputNet[k]) * weight;
                        }
                        for (j = 0; j < this.nInptuts; ++j) {
                            dif += (inputRed[j] - centre[j]) * (inputRed[j] - centre[j]);
                            centre[j] = centre[j] + nu_c * sum * evaluation[i] * (inputRed[j] - centre[j]) / (radius * radius);
                        }
                        radius += nu_sigma * sum * evaluation[i] * dif / (radius * radius * radius);
                        rbf.setRadius(radius);
                        rbf.setCentre(centre);
                    }
                }
                RBFUtils.verboseln("Error conseguido: " + error[0]);
            }
        }
        catch (Exception e) {
            throw new InternalError(e.toString());
        }
    }

    public void testModeling(double[][] X, int ndata, double[] obtained) {
        for (int i = 0; i < ndata; ++i) {
            obtained[i] = this.evaluationRbfn(X[i])[0];
        }
    }

    public void testClasification(double[][] X, int ndata, int[] obtained, int max, int min) {
        for (int i = 0; i < ndata; ++i) {
            obtained[i] = (int)Math.round(this.evaluationRbfn(X[i])[0]);
            if (obtained[i] > max) {
                obtained[i] = max;
            }
            if (obtained[i] >= min) continue;
            obtained[i] = min;
        }
    }

    public void printRbfn() {
        this.printRbfn("");
    }

    public void printRbfn(String _fileName) {
        String[] indices = new String[6];
        indices = this.getIndex();
        for (int i = 0; i < indices.length; ++i) {
            String ind = indices[i];
            if (_fileName != "") {
                Files.addToFile(_fileName, "Neuron: " + ind + "\n");
            } else {
                System.out.println("Neuron: " + ind);
            }
            Rbf neurona = this.getRbf(ind);
            neurona.printRbf(_fileName);
        }
    }
}

