/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Rule_Learning.Slipper;

import java.io.IOException;
import keel.Algorithms.Rule_Learning.Slipper.Mask;
import keel.Algorithms.Rule_Learning.Slipper.MyDataset;
import keel.Algorithms.Rule_Learning.Slipper.Pair;
import keel.Algorithms.Rule_Learning.Slipper.Rule;
import keel.Algorithms.Rule_Learning.Slipper.Ruleset;
import keel.Algorithms.Rule_Learning.Slipper.Score;
import keel.Algorithms.Rule_Learning.Slipper.SimpleRule;
import keel.Algorithms.Rule_Learning.Slipper.Utilities;
import keel.Algorithms.Rule_Learning.Slipper.parseParameters;
import keel.Dataset.Attributes;
import org.core.Fichero;
import org.core.Randomize;

public class Slipper {
    public static int W = 1;
    public static int A = 2;
    MyDataset train = new MyDataset();
    MyDataset val = new MyDataset();
    MyDataset test = new MyDataset();
    String outputTr;
    String outputTst;
    String outputRules;
    Randomize rand;
    double pct;
    int T;
    private boolean somethingWrong = false;

    public Slipper(parseParameters parameters) {
        try {
            System.out.println("\nReading the training set: " + parameters.getTrainingInputFile());
            this.train.readClassificationSet(parameters.getTrainingInputFile(), true);
            System.out.println("\nReading the validation set: " + parameters.getValidationInputFile());
            this.val.readClassificationSet(parameters.getValidationInputFile(), false);
            System.out.println("\nReading the test set: " + parameters.getTestInputFile());
            this.test.readClassificationSet(parameters.getTestInputFile(), false);
        }
        catch (IOException e) {
            System.err.println("There was a problem while reading the input data-sets: " + e);
            this.somethingWrong = true;
        }
        this.outputTr = parameters.getTrainingOutputFile();
        this.outputTst = parameters.getTestOutputFile();
        this.outputRules = parameters.getOutputFile(0);
        long seed = Long.parseLong(parameters.getParameter(0));
        this.pct = Double.parseDouble(parameters.getParameter(1));
        this.T = Integer.parseInt(parameters.getParameter(2));
        this.rand = new Randomize();
        Randomize.setSeed(seed);
        System.out.println("T: " + this.T + " pct: " + this.pct + " seed:" + seed);
    }

    public void execute() {
        if (this.somethingWrong) {
            System.err.println("An error was found, the data-set have numerical values.");
            System.err.println("Aborting the program");
        } else {
            Ruleset[] rulesets = this.slipperMulticlass(this.train);
            String[] classification_train = this.train.classify(rulesets, rulesets.length);
            String[] classification_val = this.val.classify(rulesets, rulesets.length);
            String[] classification_test = this.test.classify(rulesets, rulesets.length);
            this.doOutput(this.val, this.outputTr, classification_val);
            this.doOutput(this.test, this.outputTst, classification_test);
            this.doRulesOutput2(this.outputRules, rulesets);
            System.out.println("Algorithm Finished");
        }
    }

    private void doOutput(MyDataset dataset, String filename, String[] classification) {
        String output = new String("");
        output = dataset.copyHeader();
        for (int i = 0; i < dataset.getnData(); ++i) {
            output = output + dataset.getOutputAsString(i) + " " + classification[i] + "\n";
        }
        Fichero.escribeFichero(filename, output);
    }

    private void doRulesOutput(String filename, Ruleset[] rulesets) {
        String output = new String("");
        for (int i = 0; i < rulesets.length - 1; ++i) {
            output = output + "if(";
            for (int j = 0; j < rulesets[i].size(); ++j) {
                Rule current = rulesets[i].getRule(j);
                output = output + "(";
                for (int k = 0; k < current.size(); ++k) {
                    output = output + current.getSimpleRule(k);
                    if (k == current.size() - 1) continue;
                    output = output + " && ";
                }
                output = output + ")";
                if (j == rulesets[i].size() - 1) continue;
                output = output + " || ";
            }
            output = output + ")\n\t";
            output = output + "output=" + rulesets[i].getType() + "\nelse ";
        }
        output = output + "\n\toutput=" + rulesets[rulesets.length - 1].getType();
        Fichero.escribeFichero(filename, output);
    }

    private void doRulesOutput2(String filename, Ruleset[] rulesets) {
        String output = new String("");
        for (int i = 0; i < rulesets.length - 1; ++i) {
            if (rulesets[i].size() <= 0) continue;
            output = output + "Ruleset " + i + ":=" + rulesets[i].getType() + "\n";
            for (int j = 0; j < rulesets[i].size(); ++j) {
                Rule current = rulesets[i].getRule(j);
                output = output + "\t(";
                for (int k = 0; k < current.size(); ++k) {
                    output = output + current.getSimpleRule(k);
                    if (k == current.size() - 1) continue;
                    output = output + " && ";
                }
                output = output + ") w: " + current.getCr() + "\n";
            }
            output = output + "Default Rule Weight=" + -rulesets[i].getDefaultCr() + "\n";
        }
        output = output + "\nDefault Class=" + rulesets[rulesets.length - 1].getType();
        Fichero.escribeFichero(filename, output);
    }

    public static Rule grow(MyDataset data, Mask grow_positives, Mask grow_negatives, double[] distribution) {
        Rule rule = new Rule();
        Mask positives = grow_positives.copy();
        Mask negatives = grow_negatives.copy();
        int[] attributes = new int[data.getnInputs()];
        int nattributes = attributes.length;
        for (int i = 0; i < attributes.length; ++i) {
            attributes[i] = i;
        }
        while (negatives.getnActive() > 0 && nattributes > 0 && positives.getnActive() > 0) {
            int A = -1;
            int P = -1;
            double V = 0.0;
            double best_global = -1.7976931348623157E308;
            int Op = -1;
            for (int i = 0; i < nattributes; ++i) {
                int pos;
                double[] exemple;
                int ai = attributes[i];
                Score score = new Score();
                double total_pos = 0.0;
                double total_neg = 0.0;
                positives.resetIndex();
                while (positives.next()) {
                    if (data.isMissing(positives, ai)) continue;
                    exemple = data.getExample(positives);
                    total_pos += distribution[positives.getIndex()];
                    pos = score.findKey(exemple[ai]);
                    if (pos != -1) {
                        score.addPositive(pos, distribution[positives.getIndex()]);
                        continue;
                    }
                    score.addKey(exemple[ai], distribution[positives.getIndex()], Score.POSITIVE);
                }
                negatives.resetIndex();
                while (negatives.next()) {
                    if (data.isMissing(negatives, ai)) continue;
                    exemple = data.getExample(negatives);
                    total_neg += distribution[negatives.getIndex()];
                    pos = score.findKey(exemple[ai]);
                    if (pos != -1) {
                        score.addNegative(pos, distribution[negatives.getIndex()]);
                        continue;
                    }
                    score.addKey(exemple[ai], distribution[negatives.getIndex()], Score.NEGATIVE);
                }
                double best_v = 0.0;
                double best_h = -1.7976931348623157E308;
                int best_operator = -1;
                if (Attributes.getInputAttribute(ai).getType() == 0) {
                    for (int j = 0; j < score.size(); ++j) {
                        double W_plus = score.getPositive(j);
                        double W_minus = score.getNegative(j);
                        double h = Math.sqrt(W_plus) - Math.sqrt(W_minus);
                        if (!Utilities.gr(h, best_h)) continue;
                        best_h = h;
                        best_v = score.getKey(j);
                        best_operator = Rule.EQUAL;
                    }
                } else {
                    double W_minus;
                    double W_plus;
                    score.sort();
                    double count_pos = 0.0;
                    double count_neg = 0.0;
                    if (score.size() == 1 && score.getPositive(0) != 0.0) {
                        W_plus = score.getPositive(0);
                        W_minus = score.getNegative(0);
                        best_h = Math.sqrt(W_plus) - Math.sqrt(W_minus) + 1.0;
                        best_v = score.getKey(0);
                        best_operator = Rule.EQUAL;
                    } else if (score.size() == 1) {
                        best_h = -1.7976931348623157E308;
                        best_v = score.getKey(0);
                        best_operator = Rule.EQUAL;
                    } else {
                        best_h = -1.7976931348623157E308;
                    }
                    for (int j = 0; j < score.size() - 1; ++j) {
                        W_plus = count_pos += score.getPositive(j);
                        W_minus = count_neg += score.getNegative(j);
                        double h_lower = Math.sqrt(W_plus) - Math.sqrt(W_minus) + 1.0;
                        W_plus = total_pos - count_pos;
                        W_minus = total_neg - count_neg;
                        double h_greater = Math.sqrt(W_plus) - Math.sqrt(W_minus) + 1.0;
                        if (Utilities.gr(h_lower, h_greater) && Utilities.gr(h_lower, best_h)) {
                            best_h = h_lower;
                            best_v = score.getKey(j);
                            best_operator = Rule.LOWER;
                            continue;
                        }
                        if (!Utilities.gr(h_greater, best_h)) continue;
                        best_h = h_greater;
                        best_v = score.getKey(j);
                        best_operator = Rule.GREATER;
                    }
                }
                if (!Utilities.gr(best_h, best_global)) continue;
                P = i;
                A = ai;
                V = best_v;
                Op = best_operator;
                best_global = best_h;
            }
            if (A != -1) {
                rule.grow(A, V, Op);
                data.filter(positives, A, V, Op);
                data.filter(negatives, A, V, Op);
                attributes[P] = attributes[nattributes - 1];
            }
            --nattributes;
        }
        return rule;
    }

    public static Rule prune(Rule rule, MyDataset data, Mask prune_positives, Mask prune_negatives, Mask grow_positives, Mask grow_negatives, double[] distribution) {
        double h = Double.MAX_VALUE;
        double next_h = 0.0;
        SimpleRule last = null;
        double V_plus = rule.getW(data, prune_positives, distribution);
        double V_minus = rule.getW(data, prune_negatives, distribution);
        rule.setCr(data, grow_positives, grow_negatives, distribution);
        double Cr = rule.getCr();
        next_h = 1.0 - V_plus - V_minus + V_plus * Math.exp(-Cr) + V_minus * Math.exp(Cr);
        while (Utilities.smOrEq(next_h, h) && rule.size() > 1) {
            h = next_h;
            last = rule.getSimpleRule(rule.size() - 1);
            rule.prune(rule.size() - 1);
            V_plus = rule.getW(data, prune_positives, distribution);
            V_minus = rule.getW(data, prune_negatives, distribution);
            rule.setCr(data, grow_positives, grow_negatives, distribution);
            Cr = rule.getCr();
            next_h = 1.0 - V_plus - V_minus + V_plus * Math.exp(-Cr) + V_minus * Math.exp(Cr);
        }
        if (Utilities.gr(next_h, h)) {
            rule.grow(last);
        }
        return rule;
    }

    public Ruleset[] slipperMulticlass(MyDataset data) {
        Ruleset[] rules = new Ruleset[data.getnClasses()];
        Pair[] ordered_classes = new Pair[data.getnClasses()];
        for (int i = 0; i < data.getnClasses(); ++i) {
            ordered_classes[i] = new Pair();
            ordered_classes[i].key = i;
            ordered_classes[i].value = data.numberInstances(i);
        }
        Utilities.mergeSort(ordered_classes, data.getnClasses());
        Mask base = new Mask(data.size());
        for (int i = 0; i < data.getnClasses() - 1; ++i) {
            String target_class = Attributes.getOutputAttribute(0).getNominalValue(ordered_classes[i].key);
            Mask positives = base.copy();
            data.filterByClass(positives, target_class);
            Mask negatives = base.and(positives.complement());
            rules[i] = this.slipper(data, positives, negatives, this.T);
            rules[i].setType(target_class);
            base = negatives.copy();
        }
        rules[rules.length - 1] = new Ruleset();
        rules[rules.length - 1].addRule(new Rule());
        rules[rules.length - 1].setType(Attributes.getOutputAttribute(0).getNominalValue(ordered_classes[data.getnClasses() - 1].key));
        return rules;
    }

    public void update(MyDataset data, Rule new_rule, Mask positives, Mask negatives, double[] distribution, double Cr) {
        int i;
        int i2;
        Mask covered_pos = positives.copy();
        Mask covered_neg = negatives.copy();
        if (new_rule.size() != 0) {
            data.filter(covered_pos, new_rule);
            data.filter(covered_neg, new_rule);
        }
        double expCr = Math.exp(Cr);
        covered_pos.resetIndex();
        while (covered_pos.next()) {
            i2 = covered_pos.getIndex();
            distribution[i2] = distribution[i2] / expCr;
        }
        expCr = Math.exp(-Cr);
        covered_neg.resetIndex();
        while (covered_neg.next()) {
            i2 = covered_neg.getIndex();
            distribution[i2] = distribution[i2] / expCr;
        }
        double Z = 0.0;
        for (i = 0; i < data.size(); ++i) {
            if (!negatives.isActive(i) && !positives.isActive(i)) continue;
            Z += distribution[i];
        }
        for (i = 0; i < data.size(); ++i) {
            if (!negatives.isActive(i) && !positives.isActive(i)) continue;
            distribution[i] = distribution[i] / Z;
        }
    }

    public Ruleset slipper(MyDataset data, Mask positives, Mask negatives, int T) {
        Ruleset rules = new Ruleset();
        double m = positives.getnActive() + negatives.getnActive();
        double[] distribution = new double[data.size()];
        int i = 0;
        while ((double)i < m) {
            distribution[i] = 1.0 / m;
            ++i;
        }
        for (i = 0; i < T; ++i) {
            Mask[] gp_pos = positives.split(this.pct, this.rand);
            Mask[] gp_neg = negatives.split(this.pct, this.rand);
            Mask grow_pos = gp_pos[0];
            Mask prune_pos = gp_pos[1];
            Mask grow_neg = gp_neg[0];
            Mask prune_neg = gp_neg[1];
            Rule new_rule = Slipper.grow(data, grow_pos, grow_neg, distribution);
            Slipper.prune(new_rule, data, prune_pos, prune_neg, grow_pos, grow_neg, distribution);
            double W_plus = new_rule.getW(data, positives, distribution);
            double W_minus = new_rule.getW(data, negatives, distribution);
            double Cr = 0.5 * Math.log((W_plus + 1.0 / (2.0 * m)) / (W_minus + 1.0 / (2.0 * m)));
            double Zaux = Math.sqrt(W_plus) - Math.sqrt(W_minus) + 1.0;
            double defaultW_plus = Rule.getDefaultW(data, positives, distribution);
            double defaultW_minus = Rule.getDefaultW(data, negatives, distribution);
            double defaultCr = 0.5 * Math.log((defaultW_plus + 1.0 / (2.0 * m)) / (defaultW_minus + 1.0 / (2.0 * m)));
            double defaultZaux1 = Math.sqrt(defaultW_plus) - Math.sqrt(defaultW_minus) + 1.0;
            double defaultZaux2 = Math.sqrt(defaultW_minus) - Math.sqrt(defaultW_plus) + 1.0;
            double defaultZaux = defaultZaux1 > defaultZaux2 ? defaultZaux1 : defaultZaux2;
            double bestCr = 0.0;
            Rule best_rule = null;
            if (Utilities.gr(Zaux, defaultZaux)) {
                bestCr = Cr;
                best_rule = new_rule;
                new_rule.setCr(Cr);
                rules.addRule(new_rule);
            } else {
                bestCr = defaultCr;
                best_rule = new Rule();
                rules.addToDefaultCr(defaultCr);
            }
            this.update(data, best_rule, positives, negatives, distribution, bestCr);
        }
        return rules;
    }
}

