/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.exprtree;

import net.sf.jclec.ISpecies;
import net.sf.jclec.base.AbstractCreator;
import net.sf.jclec.exprtree.ExprTree;
import net.sf.jclec.exprtree.ExprTreeIndividual;
import net.sf.jclec.exprtree.IExprTreeSpecies;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExprTreeCreator<I extends ExprTreeIndividual>
extends AbstractCreator<I> {
    private static final long serialVersionUID = 4365866784680115536L;
    protected transient IExprTreeSpecies<I> species;
    protected transient IExprTreeSpecies.IExprTreeSchema[] schema;

    public boolean equals(Object other) {
        return other instanceof ExprTreeCreator;
    }

    @Override
    protected void prepareCreation() {
        ISpecies spc = this.context.getSpecies();
        if (!(spc instanceof IExprTreeSpecies)) {
            throw new IllegalStateException("Illegal species in context");
        }
        this.species = (IExprTreeSpecies)spc;
        this.schema = ((IExprTreeSpecies)spc).getGenotypeSchema();
    }

    @Override
    protected void createNext() {
        int numberOfExpressionTrees = this.schema.length;
        ExprTree[] genotype = new ExprTree[numberOfExpressionTrees];
        int i = 0;
        while (i < numberOfExpressionTrees) {
            int minSize = this.schema[i].getMinTreeSize();
            int maxSize = this.schema[i].getMaxTreeSize();
            int actSize = this.randgen.choose(minSize, maxSize);
            genotype[i] = this.schema[i].createExprTree(actSize, this.randgen);
            ++i;
        }
        this.createdBuffer.add(this.species.createIndividual(genotype));
    }
}

