/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.client.custom;

import it.bancaditalia.oss.sdmx.api.Codelist;
import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.api.SDMXReference;
import it.bancaditalia.oss.sdmx.client.Provider;
import it.bancaditalia.oss.sdmx.client.RestSdmxClient;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxInvalidParameterException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxXmlContentException;
import it.bancaditalia.oss.sdmx.parser.v20.DataStructureParser;
import it.bancaditalia.oss.sdmx.parser.v20.DataflowParser;
import it.bancaditalia.oss.sdmx.parser.v21.CompactDataParser;
import it.bancaditalia.oss.sdmx.parser.v21.DataParsingResult;
import it.bancaditalia.oss.sdmx.parser.v21.Sdmx21Queries;
import it.bancaditalia.oss.sdmx.util.QueryRunner;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class RestSdmx20Client
extends RestSdmxClient {
    private String acceptHdr = null;
    protected String format = "compact_v2";

    public RestSdmx20Client(Provider provider, String string, String string2) {
        super(provider);
        this.acceptHdr = string;
        this.format = string2;
    }

    @Override
    public Map<String, Dataflow> getDataflows() throws SdmxException {
        URL uRL = this.buildFlowQuery("ALL", null, null);
        List<Dataflow> list = QueryRunner.runQuery(new DataflowParser(), uRL, null);
        if (list.size() > 0) {
            HashMap<String, Dataflow> hashMap = new HashMap<String, Dataflow>();
            for (Dataflow dataflow : list) {
                hashMap.put(dataflow.getId(), dataflow);
            }
            return hashMap;
        }
        throw new SdmxXmlContentException("The query returned zero dataflows");
    }

    @Override
    public Dataflow getDataflow(String string, String string2, String string3) throws SdmxException {
        URL uRL = this.buildFlowQuery(string, string2, string3);
        List<Dataflow> list = QueryRunner.runQuery(new DataflowParser(), uRL, null);
        if (list.size() >= 1) {
            for (Dataflow dataflow : list) {
                if (!dataflow.getId().equalsIgnoreCase(string)) continue;
                return dataflow;
            }
        }
        throw new SdmxXmlContentException("The query returned zero dataflows");
    }

    @Override
    public DataFlowStructure getDataFlowStructure(SDMXReference sDMXReference, boolean bl) throws SdmxException {
        if (sDMXReference != null) {
            URL uRL = this.buildDSDQuery(sDMXReference.getId(), sDMXReference.getAgency(), sDMXReference.getVersion(), bl);
            return QueryRunner.runQuery(new DataStructureParser(), uRL, null).get(0);
        }
        throw new SdmxInvalidParameterException("Null dsd in input");
    }

    @Override
    public Codelist getCodes(String string, String string2, String string3) throws SdmxException {
        throw new SdmxInvalidParameterException("This method can only be called on SDMX V2.1+ providers.");
    }

    @Override
    protected DataParsingResult getData(Dataflow dataflow, DataFlowStructure dataFlowStructure, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        URL uRL = this.buildDataQuery(dataflow, string, string2, string3, bl, string4, bl2);
        return QueryRunner.runQuery(new CompactDataParser(dataFlowStructure, dataflow, !bl), uRL, this.handleHttpHeaders(this.acceptHdr));
    }

    @Override
    protected URL buildDataQuery(Dataflow dataflow, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        if (this.provider.getEndpoint() != null && dataflow != null && string != null && !string.isEmpty()) {
            return Sdmx21Queries.createDataQuery(this.provider.getEndpoint(), dataflow.getFullIdentifier(), string, string2, string3, bl, string4, bl2, this.format).buildSdmx21Query();
        }
        throw new SdmxInvalidParameterException("Invalid query parameters: dataflow=" + dataflow + " resource=" + string + " endpoint=" + this.provider.getEndpoint());
    }
}

