/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.stat.matrix;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import umontreal.iro.lecuyer.stat.Tally;
import umontreal.iro.lecuyer.stat.TallyStore;
import umontreal.iro.lecuyer.stat.matrix.MatrixOfStatProbes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatrixOfTallies<E extends Tally>
extends MatrixOfStatProbes<E> {
    public MatrixOfTallies(int n, int n2) {
        super(n, n2);
    }

    public MatrixOfTallies(String string, int n, int n2) {
        super(string, n, n2);
    }

    public static MatrixOfTallies<Tally> createWithTally(int n, int n2) {
        MatrixOfTallies<Tally> matrixOfTallies = new MatrixOfTallies<Tally>(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                matrixOfTallies.set(i, j, new Tally());
            }
        }
        return matrixOfTallies;
    }

    public static MatrixOfTallies<TallyStore> createWithTallyStore(int n, int n2) {
        MatrixOfTallies<TallyStore> matrixOfTallies = new MatrixOfTallies<TallyStore>(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                matrixOfTallies.set(i, j, new TallyStore());
            }
        }
        return matrixOfTallies;
    }

    public void add(DoubleMatrix2D doubleMatrix2D) {
        int n = this.rows();
        int n2 = this.columns();
        if (doubleMatrix2D.rows() != n || doubleMatrix2D.columns() != n2) {
            throw new IllegalArgumentException("Incompatible matrix dimensions: given " + doubleMatrix2D.rows() + "x" + doubleMatrix2D.columns() + ", required " + this.rows() + "x" + this.columns());
        }
        if (this.collect) {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    double d = doubleMatrix2D.getQuick(i, j);
                    Tally tally = (Tally)this.get(i, j);
                    if (Double.isNaN(d) || tally == null) continue;
                    tally.add(d);
                }
            }
        }
        this.notifyListeners(doubleMatrix2D);
    }

    public void add(double[][] dArray) {
        int n = this.rows();
        int n2 = this.columns();
        if (dArray.length != n) {
            throw new IllegalArgumentException("Incompatible number of rows: given " + dArray.length + ", required " + n);
        }
        if (this.collect) {
            for (int i = 0; i < n; ++i) {
                if (dArray[i].length != n2) {
                    throw new IllegalArgumentException("Incompatible number of columns in row " + i + ": given " + dArray[i].length + ", but required " + n2);
                }
                for (int j = 0; j < n2; ++j) {
                    double d = dArray[i][j];
                    Tally tally = (Tally)this.get(i, j);
                    if (Double.isNaN(d) || tally == null) continue;
                    tally.add(d);
                }
            }
        }
        this.notifyListeners((DoubleMatrix2D)new DenseDoubleMatrix2D(dArray));
    }

    public int numberObs() {
        if (this.rows() == 0 || this.columns() == 0) {
            return 0;
        }
        Tally tally = (Tally)this.get(0, 0);
        return tally == null ? 0 : tally.numberObs();
    }

    public boolean areAllNumberObsEqual() {
        int n = this.rows();
        int n2 = this.columns();
        int n3 = this.numberObs();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                Tally tally = (Tally)this.get(i, j);
                if (tally.numberObs() == n3) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void average(DoubleMatrix2D doubleMatrix2D) {
        for (int i = 0; i < doubleMatrix2D.rows(); ++i) {
            for (int j = 0; j < doubleMatrix2D.columns(); ++j) {
                Tally tally = (Tally)this.get(i, j);
                double d = tally == null || tally.numberObs() == 0 ? Double.NaN : tally.average();
                doubleMatrix2D.setQuick(i, j, d);
            }
        }
    }

    public void variance(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D.rows() != this.rows()) {
            throw new IllegalArgumentException("Invalid number of rows in the given matrix: required " + this.rows() + " but found " + doubleMatrix2D.rows());
        }
        if (doubleMatrix2D.columns() != this.columns()) {
            throw new IllegalArgumentException("Invalid number of columns in the given matrix: required " + this.columns() + " but found " + doubleMatrix2D.columns());
        }
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.columns(); ++j) {
                Tally tally = (Tally)this.get(i, j);
                doubleMatrix2D.setQuick(i, j, tally != null && tally.numberObs() >= 2 ? tally.variance() : Double.NaN);
            }
        }
    }

    public void standardDeviation(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D.rows() != this.rows()) {
            throw new IllegalArgumentException("Invalid number of rows in the given matrix: required " + this.rows() + " but found " + doubleMatrix2D.rows());
        }
        if (doubleMatrix2D.columns() != this.columns()) {
            throw new IllegalArgumentException("Invalid number of columns in the given matrix: required " + this.columns() + " but found " + doubleMatrix2D.columns());
        }
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.columns(); ++j) {
                Tally tally = (Tally)this.get(i, j);
                doubleMatrix2D.setQuick(i, j, tally != null && tally.numberObs() >= 2 ? tally.standardDeviation() : Double.NaN);
            }
        }
    }

    @Override
    public MatrixOfTallies<E> clone() {
        return (MatrixOfTallies)super.clone();
    }
}

