/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui.cytoscape;

import cytoscape.util.CyFileFilter;
import cytoscape.util.FileUtil;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractAction;
import uk.ac.rhul.cs.cl1.NodeSet;
import uk.ac.rhul.cs.cl1.io.ClusteringWriter;
import uk.ac.rhul.cs.cl1.io.ClusteringWriterFactory;
import uk.ac.rhul.cs.cl1.ui.cytoscape.CytoscapePlugin;
import uk.ac.rhul.cs.cl1.ui.cytoscape.CytoscapeResultViewerPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveClusterAction
extends AbstractAction {
    protected CytoscapeResultViewerPanel resultViewer;

    public SaveClusterAction(CytoscapeResultViewerPanel panel) {
        super("Save selected cluster(s)...");
        this.resultViewer = panel;
        this.putValue("MnemonicKey", 83);
    }

    protected List<NodeSet> getNodeListsToBeSaved() {
        return this.resultViewer.getSelectedNodeSets();
    }

    protected String getFileDialogTitle() {
        return "Select the file to save the selected clusters to";
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        ClusteringWriterFactory.Format[] formats = ClusteringWriterFactory.Format.values();
        CyFileFilter[] filters = new CyFileFilter[formats.length];
        for (int i = 0; i < formats.length; ++i) {
            filters[formats.length - i - 1] = new CyFileFilter(formats[i].getExtension(), formats[i].getName());
        }
        File file = FileUtil.getFile((String)this.getFileDialogTitle(), (int)FileUtil.SAVE, (CyFileFilter[])filters);
        if (file == null) {
            return;
        }
        ClusteringWriterFactory.Format format = ClusteringWriterFactory.Format.forFile(file);
        if (format == null) {
            CytoscapePlugin.showErrorMessage("The extension of the given filename does not correspond to\nany of the known formats. Please use one of the default\nextensions (.tab for GenePro files, .txt for cluster lists, .csv for CSV cluster lists).");
            return;
        }
        ClusteringWriter wr = ClusteringWriterFactory.fromFormat(format);
        try {
            wr.writeClustering(this.getNodeListsToBeSaved(), file);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            CytoscapePlugin.showErrorMessage("I/O error while trying to save the selected clusters to\n" + file.getAbsolutePath());
        }
    }
}

