/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.filters;

import uk.ac.rhul.cs.cl1.MutableNodeSet;
import uk.ac.rhul.cs.cl1.filters.NodeSetFilter;
import uk.ac.rhul.cs.graph.BreadthFirstSearch;
import uk.ac.rhul.cs.graph.BreadthFirstSearchIterator;

public class DiameterFilter
implements NodeSetFilter {
    protected int minDiameter;
    protected int maxDiameter;

    public DiameterFilter() {
        this(0, Integer.MAX_VALUE);
    }

    public DiameterFilter(int maxDiameter) {
        this(0, maxDiameter);
    }

    public DiameterFilter(int minDiameter, int maxDiameter) {
        this.minDiameter = minDiameter;
        this.maxDiameter = maxDiameter;
    }

    public boolean filter(MutableNodeSet nodeSet) {
        Integer[] members = nodeSet.getMembers().toArray(new Integer[0]);
        BreadthFirstSearch bfs = new BreadthFirstSearch(nodeSet.getGraph(), 0);
        int diameter = 0;
        bfs.restrictToSubgraph(members);
        for (int node : nodeSet) {
            bfs.setSeedNode(node);
            BreadthFirstSearchIterator iter = bfs.iterator();
            while (iter.hasNext()) {
                iter.next();
            }
            if ((diameter = Math.max(diameter, iter.getDistance())) <= this.maxDiameter) continue;
            return false;
        }
        return diameter >= this.minDiameter;
    }
}

