/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.check.checkers;

import java.util.Objects;
import org.ohdsi.circe.check.WarningSeverity;
import org.ohdsi.circe.check.checkers.BaseCheck;
import org.ohdsi.circe.check.checkers.WarningReporter;
import org.ohdsi.circe.cohortdefinition.CohortExpression;
import org.ohdsi.circe.cohortdefinition.ResultLimit;

public class EventsProgressionCheck
extends BaseCheck {
    private static final String WARNING = "%s limit may not have intended effect since it breaks all/latest/earliest progression";

    @Override
    protected WarningSeverity defineSeverity() {
        return WarningSeverity.WARNING;
    }

    @Override
    protected void check(CohortExpression expression, WarningReporter reporter) {
        int qualifyingWeight;
        int initialWeight = this.getWeight(expression.primaryCriteria.primaryLimit);
        int cohortInitialWeight = this.getWeight(expression.qualifiedLimit);
        int n = qualifyingWeight = expression.additionalCriteria != null ? this.getWeight(expression.expressionLimit) : LimitType.NONE.getWeigt();
        if (initialWeight - cohortInitialWeight < 0) {
            reporter.add(WARNING, "Cohort of initial events");
        }
        if (cohortInitialWeight - qualifyingWeight < 0 || initialWeight - qualifyingWeight < 0) {
            reporter.add(WARNING, "Qualifying cohort");
        }
    }

    private int getWeight(ResultLimit limit) {
        return Objects.nonNull(limit) && Objects.nonNull(limit.type) ? LimitType.fromName(limit.type).getWeigt() : LimitType.NONE.getWeigt();
    }

    static enum LimitType {
        NONE(0, "null"),
        EARLIEST(0, "First"),
        LATEST(1, "Last"),
        ALL(2, "All");

        int weigt;
        String name;

        private LimitType(int weigt, String name) {
            this.weigt = weigt;
            this.name = name;
        }

        public int getWeigt() {
            return this.weigt;
        }

        public String getName() {
            return this.name;
        }

        static LimitType fromName(String name) {
            for (LimitType type : LimitType.values()) {
                if (!Objects.equals(type.name, name)) continue;
                return type;
            }
            return NONE;
        }
    }
}

