/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.mcmc;

public class MCMCOptions {
    private final long chainLength;
    private final long fullEvaluationCount;
    private final int minOperatorCountForFullEvaluation;
    private final double evaluationTestThreshold;
    private final boolean useAdaptation;
    private final boolean smoothAcceptanceProbability;
    private final long adaptationDelay;
    private final double adaptationTarget;
    private final double temperature;

    public MCMCOptions(long l) {
        this(l, 2000L, 1, 0.1, true, 0L, 0.234, false, 1.0);
    }

    public MCMCOptions(long l, long l2, int n, double d, boolean bl, long l3, double d2, boolean bl2, double d3) {
        this.chainLength = l;
        this.fullEvaluationCount = l2;
        this.minOperatorCountForFullEvaluation = n;
        this.evaluationTestThreshold = d;
        this.useAdaptation = bl;
        this.adaptationDelay = l3;
        this.adaptationTarget = d2;
        this.smoothAcceptanceProbability = bl2;
        this.temperature = d3;
    }

    public final long getChainLength() {
        return this.chainLength;
    }

    public final long getFullEvaluationCount() {
        return this.fullEvaluationCount;
    }

    public double getEvaluationTestThreshold() {
        return this.evaluationTestThreshold;
    }

    public final boolean useAdaptation() {
        return this.useAdaptation;
    }

    public final long getAdaptationDelay() {
        return this.adaptationDelay;
    }

    public final double getAdaptationTarget() {
        return this.adaptationTarget;
    }

    public boolean useSmoothedAcceptanceProbability() {
        return this.smoothAcceptanceProbability;
    }

    public final double getTemperature() {
        return this.temperature;
    }

    public int minOperatorCountForFullEvaluation() {
        return this.minOperatorCountForFullEvaluation;
    }
}

