/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel.aminoacid;

import dr.evolution.datatype.AminoAcids;
import dr.evomodel.substmodel.EmpiricalRateMatrix;
import dr.util.Author;
import dr.util.Citation;
import java.util.Collections;
import java.util.List;

public class FLU
extends EmpiricalRateMatrix.AbstractAminoAcid {
    public static final FLU INSTANCE = new FLU();
    public static Citation CITATION = new Citation(new Author[]{new Author("CC", "Dang"), new Author("QS", "Le"), new Author("O", "Gascuel"), new Author("VS", "Le")}, "FLU, an amino acid substitution model for influenza proteins", 2010, "BMC Evolutionary Biology", 10, 99, -1);

    private FLU() {
        super("FLU");
        int n = AminoAcids.INSTANCE.getStateCount();
        double[][] dArray = new double[n][n];
        dArray[0][1] = 0.138659;
        dArray[0][2] = 0.053367;
        dArray[0][3] = 0.584852;
        dArray[0][4] = 0.026447;
        dArray[0][5] = 0.353754;
        dArray[0][6] = 1.484235;
        dArray[0][7] = 1.132313;
        dArray[0][8] = 0.214758;
        dArray[0][9] = 0.149927;
        dArray[0][10] = 0.023117;
        dArray[0][11] = 0.474334;
        dArray[0][12] = 0.058745;
        dArray[0][13] = 0.080491;
        dArray[0][14] = 0.659311;
        dArray[0][15] = 3.011345;
        dArray[0][16] = 5.418298;
        dArray[0][17] = 0.195966;
        dArray[0][18] = 0.018289;
        dArray[0][19] = 3.532005;
        dArray[1][2] = 0.161001;
        dArray[1][3] = 0.006772;
        dArray[1][4] = 0.167207;
        dArray[1][5] = 3.292717;
        dArray[1][6] = 0.124898;
        dArray[1][7] = 1.190624;
        dArray[1][8] = 1.87957;
        dArray[1][9] = 0.246117;
        dArray[1][10] = 0.296046;
        dArray[1][11] = 15.300097;
        dArray[1][12] = 0.890162;
        dArray[1][13] = 0.016055;
        dArray[1][14] = 0.154027;
        dArray[1][15] = 0.950138;
        dArray[1][16] = 0.183077;
        dArray[1][17] = 1.369429;
        dArray[1][18] = 0.099855;
        dArray[1][19] = 0.103964;
        dArray[2][3] = 7.737393;
        dArray[2][4] = 1.3E-5;
        dArray[2][5] = 0.530643;
        dArray[2][6] = 0.061652;
        dArray[2][7] = 0.322525;
        dArray[2][8] = 1.387096;
        dArray[2][9] = 0.218572;
        dArray[2][10] = 8.36E-4;
        dArray[2][11] = 2.646848;
        dArray[2][12] = 0.005252;
        dArray[2][13] = 8.36E-4;
        dArray[2][14] = 0.036442;
        dArray[2][15] = 3.881311;
        dArray[2][16] = 2.140332;
        dArray[2][17] = 5.36E-4;
        dArray[2][18] = 0.373102;
        dArray[2][19] = 0.010258;
        dArray[3][4] = 0.014132;
        dArray[3][5] = 0.145469;
        dArray[3][6] = 5.370511;
        dArray[3][7] = 1.934833;
        dArray[3][8] = 0.887571;
        dArray[3][9] = 0.014086;
        dArray[3][10] = 0.005731;
        dArray[3][11] = 0.290043;
        dArray[3][12] = 0.041763;
        dArray[3][13] = 1.0E-6;
        dArray[3][14] = 0.188539;
        dArray[3][15] = 0.338372;
        dArray[3][16] = 0.135481;
        dArray[3][17] = 1.5E-5;
        dArray[3][18] = 0.525399;
        dArray[3][19] = 0.297124;
        dArray[4][5] = 0.002547;
        dArray[4][6] = 0.0;
        dArray[4][7] = 0.116941;
        dArray[4][8] = 0.021845;
        dArray[4][9] = 0.001112;
        dArray[4][10] = 0.005614;
        dArray[4][11] = 4.0E-6;
        dArray[4][12] = 0.111457;
        dArray[4][13] = 0.104054;
        dArray[4][14] = 0.0;
        dArray[4][15] = 0.336263;
        dArray[4][16] = 0.011975;
        dArray[4][17] = 0.094107;
        dArray[4][18] = 0.601692;
        dArray[4][19] = 0.054905;
        dArray[5][6] = 1.195629;
        dArray[5][7] = 0.108051;
        dArray[5][8] = 5.330313;
        dArray[5][9] = 0.02884;
        dArray[5][10] = 1.020367;
        dArray[5][11] = 2.559587;
        dArray[5][12] = 0.190259;
        dArray[5][13] = 0.032681;
        dArray[5][14] = 0.71277;
        dArray[5][15] = 0.487822;
        dArray[5][16] = 0.602341;
        dArray[5][17] = 0.044021;
        dArray[5][18] = 0.072206;
        dArray[5][19] = 0.406698;
        dArray[6][7] = 1.593099;
        dArray[6][8] = 0.256492;
        dArray[6][9] = 0.014211;
        dArray[6][10] = 0.0165;
        dArray[6][11] = 3.881489;
        dArray[6][12] = 0.313974;
        dArray[6][13] = 0.001004;
        dArray[6][14] = 0.319559;
        dArray[6][15] = 0.30714;
        dArray[6][16] = 0.280125;
        dArray[6][17] = 0.155245;
        dArray[6][18] = 0.104093;
        dArray[6][19] = 0.285048;
        dArray[7][8] = 0.058775;
        dArray[7][9] = 1.6E-5;
        dArray[7][10] = 0.006516;
        dArray[7][11] = 0.264149;
        dArray[7][12] = 0.0015;
        dArray[7][13] = 0.001237;
        dArray[7][14] = 0.038632;
        dArray[7][15] = 1.585647;
        dArray[7][16] = 0.018808;
        dArray[7][17] = 0.196486;
        dArray[7][18] = 0.074815;
        dArray[7][19] = 0.33723;
        dArray[8][9] = 0.24319;
        dArray[8][10] = 0.321612;
        dArray[8][11] = 0.347303;
        dArray[8][12] = 0.001274;
        dArray[8][13] = 0.119029;
        dArray[8][14] = 0.924467;
        dArray[8][15] = 0.580704;
        dArray[8][16] = 0.368714;
        dArray[8][17] = 0.022373;
        dArray[8][18] = 6.448954;
        dArray[8][19] = 0.098631;
        dArray[9][10] = 3.512072;
        dArray[9][11] = 0.227708;
        dArray[9][12] = 9.017954;
        dArray[9][13] = 1.463357;
        dArray[9][14] = 0.080543;
        dArray[9][15] = 0.290381;
        dArray[9][16] = 2.904052;
        dArray[9][17] = 0.032132;
        dArray[9][18] = 0.273934;
        dArray[9][19] = 14.394052;
        dArray[10][11] = 0.129224;
        dArray[10][12] = 6.746936;
        dArray[10][13] = 2.9868;
        dArray[10][14] = 0.634309;
        dArray[10][15] = 0.570767;
        dArray[10][16] = 0.044926;
        dArray[10][17] = 0.431278;
        dArray[10][18] = 0.340058;
        dArray[10][19] = 0.890599;
        dArray[11][12] = 1.331292;
        dArray[11][13] = 0.319896;
        dArray[11][14] = 0.195751;
        dArray[11][15] = 0.283808;
        dArray[11][16] = 1.526964;
        dArray[11][17] = 5.0E-5;
        dArray[11][18] = 0.012416;
        dArray[11][19] = 0.073128;
        dArray[12][13] = 0.279911;
        dArray[12][14] = 0.056869;
        dArray[12][15] = 0.007027;
        dArray[12][16] = 2.031511;
        dArray[12][17] = 0.07046;
        dArray[12][18] = 0.874272;
        dArray[12][19] = 4.904842;
        dArray[13][14] = 0.007132;
        dArray[13][15] = 0.996686;
        dArray[13][16] = 1.35E-4;
        dArray[13][17] = 0.814753;
        dArray[13][18] = 5.393924;
        dArray[13][19] = 0.592588;
        dArray[14][15] = 2.087385;
        dArray[14][16] = 0.542251;
        dArray[14][17] = 4.31E-4;
        dArray[14][18] = 1.82E-4;
        dArray[14][19] = 0.058972;
        dArray[15][16] = 2.20686;
        dArray[15][17] = 0.099836;
        dArray[15][18] = 0.392552;
        dArray[15][19] = 0.088256;
        dArray[16][17] = 0.207066;
        dArray[16][18] = 0.124898;
        dArray[16][19] = 0.654109;
        dArray[17][18] = 0.427755;
        dArray[17][19] = 0.2569;
        dArray[18][19] = 0.167582;
        this.setEmpiricalRates(dArray, "ARNDCQEGHILKMFPSTWYV");
        double[] dArray2 = new double[n];
        dArray2[0] = 0.0470718;
        dArray2[1] = 0.0509102;
        dArray2[2] = 0.0742143;
        dArray2[3] = 0.0478596;
        dArray2[4] = 0.0250216;
        dArray2[5] = 0.0333036;
        dArray2[6] = 0.0545874;
        dArray2[7] = 0.0763734;
        dArray2[8] = 0.0199642;
        dArray2[9] = 0.0671336;
        dArray2[10] = 0.0714981;
        dArray2[11] = 0.0567845;
        dArray2[12] = 0.0181507;
        dArray2[13] = 0.0304961;
        dArray2[14] = 0.0506561;
        dArray2[15] = 0.0884091;
        dArray2[16] = 0.0743386;
        dArray2[17] = 0.0185237;
        dArray2[18] = 0.0314741;
        dArray2[19] = 0.0632292;
        this.setEmpiricalFrequencies(dArray2, "ARNDCQEGHILKMFPSTWYV");
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.SUBSTITUTION_MODELS;
    }

    @Override
    public String getDescription() {
        return "FLU amino acid substitution model";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CITATION);
    }
}

