/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic.phyloclustering.misc.obsolete;

import dr.evolution.tree.NodeRef;
import dr.evomodel.antigenic.phyloclustering.misc.obsolete.OrderDouble;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.CompoundParameter;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;

public class ClusterViruses
extends AbstractModelLikelihood {
    private double mostRecentTransformedValue = 0.0;
    private boolean treeChanged = false;
    public static final String CLUSTER_VIRUSES = "ClusterViruses";
    double lambda = 10.0;
    double sigmaSq = 9.0;
    Parameter K;
    Parameter excisionPoints;
    Parameter clusterLabels;
    MatrixParameter mu;
    double[] muLabels;
    MatrixParameter virusLocations = null;
    Set<NodeRef> allTips;
    CompoundParameter traitParameter;
    Parameter alpha;
    Parameter clusterPrec;
    Parameter priorPrec;
    Parameter priorMean;
    Parameter assignments;
    Parameter links;
    Parameter means2;
    Parameter means1;
    Parameter locationDrift;
    Parameter offsets;
    boolean hasDrift;
    TreeModel treeModel;
    String traitName;
    double[][] data;
    double[][] depMatrix;
    double[][] logDepMatrix;
    double[][] cur_untransformedMatrix;
    double[] logLikelihoodsVector;
    int numdata;
    Parameter transformFactor;
    double k0;
    double v0;
    double[][] T0Inv;
    double[] m;
    double logDetT0;
    LinkedList<Integer>[] assignmentsLL;
    int seqLength;
    char[][] seqData;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String TREEMODEL = "treeModel";
        public static final String K = "k";
        public static final String EXCISIONPOINTS = "excisionPoints";
        public static final String CLUSTERLABELS = "clusterLabels";
        public static final String MU = "mu";
        public static final String OFFSETS = "offsets";
        public static final String VIRUS_LOCATIONS = "virusLocations";
        boolean integrate = false;
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("k", Parameter.class), new ElementRule("excisionPoints", Parameter.class), new ElementRule("clusterLabels", Parameter.class), new ElementRule("mu", MatrixParameter.class), new ElementRule("offsets", Parameter.class), new ElementRule("virusLocations", MatrixParameter.class)};

        @Override
        public String getParserName() {
            return ClusterViruses.CLUSTER_VIRUSES;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            XMLObject xMLObject2 = xMLObject.getChild(K);
            Parameter parameter = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild(EXCISIONPOINTS);
            Parameter parameter2 = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild(CLUSTERLABELS);
            Parameter parameter3 = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild(MU);
            MatrixParameter matrixParameter = (MatrixParameter)xMLObject2.getChild(MatrixParameter.class);
            xMLObject2 = xMLObject.getChild(OFFSETS);
            Parameter parameter4 = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild(VIRUS_LOCATIONS);
            MatrixParameter matrixParameter2 = (MatrixParameter)xMLObject2.getChild(MatrixParameter.class);
            boolean bl = false;
            if (parameter4.getDimension() > 1) {
                bl = true;
            }
            return new ClusterViruses(treeModel, parameter, parameter2, parameter3, matrixParameter, bl, parameter4, matrixParameter2);
        }

        @Override
        public String getParserDescription() {
            return "clustering viruses";
        }

        @Override
        public Class getReturnType() {
            return ClusterViruses.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    String Atribute = null;

    public ClusterViruses(TreeModel treeModel, Parameter parameter, Parameter parameter2, Parameter parameter3, MatrixParameter matrixParameter, Boolean bl, Parameter parameter4, MatrixParameter matrixParameter2) {
        super(CLUSTER_VIRUSES);
        int n;
        this.treeModel = treeModel;
        this.K = parameter;
        this.excisionPoints = parameter2;
        this.clusterLabels = parameter3;
        this.mu = matrixParameter;
        this.hasDrift = bl;
        this.offsets = parameter4;
        this.virusLocations = matrixParameter2;
        this.numdata = this.offsets.getSize();
        System.out.println("numdata = " + this.numdata);
        this.clusterLabels.setDimension(this.numdata);
        for (n = 0; n < this.numdata; ++n) {
            this.clusterLabels.setParameterValue(n, 0.0);
        }
        this.addVariable(this.clusterLabels);
        this.mu.setColumnDimension(2);
        n = (int)this.K.getParameterValue(0);
        this.mu.setRowDimension(n);
        for (int i = 0; i < n; ++i) {
            double d = 0.0;
            this.mu.getParameter(i).setValue(0, d);
            this.mu.getParameter(i).setValue(1, d);
        }
        this.preClustering();
        this.addVariable(this.virusLocations);
        this.addModel(this.treeModel);
        this.addVariable(this.offsets);
        this.addVariable(this.K);
        this.addVariable(this.excisionPoints);
        this.addVariable(this.mu);
        System.out.println("Finished loading the constructor for ClusterViruses");
    }

    private void preClustering() {
        int n;
        int n2;
        int n3;
        int n4 = this.offsets.getSize();
        System.out.println("# offsets = " + this.offsets.getSize());
        ArrayList<OrderDouble> arrayList = new ArrayList<OrderDouble>();
        for (n3 = 0; n3 < n4; ++n3) {
            arrayList.add(new OrderDouble(n3, this.offsets.getParameterValue(n3)));
        }
        Collections.sort(arrayList, new OrderDouble());
        n3 = n4 / (int)(this.K.getParameterValue(0) - 1.0);
        System.out.println("initial bin size = " + n3);
        System.out.println("Initial cluster assignment:");
        for (n2 = 0; n2 < n4; ++n2) {
            n = n2 / n3;
            this.clusterLabels.setParameterValue(((OrderDouble)arrayList.get(n2)).getIndex(), n);
        }
        n2 = 0;
        for (n = 0; n < this.numdata; ++n) {
            if (n2 >= (int)this.clusterLabels.getParameterValue(n)) continue;
            n2 = (int)this.clusterLabels.getParameterValue(n);
        }
        for (n = 0; n <= n2; ++n) {
            this.mu.getParameter(n).setParameterValue(0, 0.0);
            this.mu.getParameter(n).setParameterValue(1, 0.0);
        }
    }

    @Override
    public double getLogLikelihood() {
        int n;
        int n2;
        double d = 0.0;
        int n3 = 0;
        for (n2 = 0; n2 < this.numdata; ++n2) {
            if (n3 >= (int)this.clusterLabels.getParameterValue(n2)) continue;
            n3 = (int)this.clusterLabels.getParameterValue(n2);
        }
        n2 = (int)this.K.getParameterValue(0);
        d += -this.lambda + this.K.getParameterValue(0) * Math.log(this.lambda) - Math.log(this.factorial(n2));
        d -= (double)this.numdata * Math.log(this.K.getParameterValue(0));
        d -= this.K.getParameterValue(0) * (Math.log(2.0) + Math.log(Math.PI) + 0.5 * Math.log(this.sigmaSq) + 0.5 * Math.log(this.sigmaSq));
        double[] dArray = new double[n2];
        for (n = 0; n < this.numdata; ++n) {
            int n4 = (int)this.clusterLabels.getParameterValue(n);
            dArray[n4] = dArray[n4] + 1.0;
        }
        for (n = 0; n <= n3; ++n) {
            double d2 = this.mu.getParameter(n).getParameterValue(0);
            double d3 = this.mu.getParameter(n).getParameterValue(1);
            if (!(dArray[n] > 0.0)) continue;
            d -= 0.5 * (d2 * d2 + d3 * d3) / this.sigmaSq;
        }
        return d;
    }

    public int factorial(int n) {
        int n2 = 1;
        for (int i = 1; i <= n; ++i) {
            n2 *= i;
        }
        return n2;
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public void makeDirty() {
    }

    @Override
    public void acceptState() {
    }

    @Override
    public void restoreState() {
    }

    @Override
    public void storeState() {
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.treeModel) {
            this.treeChanged = true;
        }
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    public int getSeqLength() {
        return this.seqLength;
    }
}

