/*
 * Decompiled with CFR 0.152.
 */
package moa.tasks;

import com.github.javacliparser.FileOption;
import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Instance;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import moa.capabilities.CapabilitiesHandler;
import moa.capabilities.Capability;
import moa.capabilities.ImmutableCapabilities;
import moa.classifiers.Classifier;
import moa.classifiers.MultiClassClassifier;
import moa.core.Measurement;
import moa.core.ObjectRepository;
import moa.core.Utils;
import moa.evaluation.LearningEvaluation;
import moa.evaluation.LearningPerformanceEvaluator;
import moa.evaluation.preview.LearningCurve;
import moa.learners.Learner;
import moa.options.ClassOption;
import moa.streams.ExampleStream;
import moa.streams.InstanceStream;
import moa.tasks.ClassificationMainTask;
import moa.tasks.TaskMonitor;

public class EvaluateModel
extends ClassificationMainTask
implements CapabilitiesHandler {
    private static final long serialVersionUID = 1L;
    public ClassOption modelOption = new ClassOption("model", 'm', "Learner to evaluate.", MultiClassClassifier.class, "LearnModel");
    public ClassOption streamOption = new ClassOption("stream", 's', "Stream to evaluate on.", ExampleStream.class, "generators.RandomTreeGenerator");
    public ClassOption evaluatorOption = new ClassOption("evaluator", 'e', "Classification performance evaluation method.", LearningPerformanceEvaluator.class, "BasicClassificationPerformanceEvaluator");
    public IntOption maxInstancesOption = new IntOption("maxInstances", 'i', "Maximum number of instances to test.", 100000000, 0, Integer.MAX_VALUE);
    public IntOption sampleFrequencyOption = new IntOption("sampleFrequency", 'f', "How many instances between samples of the learning performance.", 100000, 0, Integer.MAX_VALUE);
    public FileOption outputPredictionFileOption = new FileOption("outputPredictionFile", 'o', "File to append output predictions to.", null, "pred", true);

    @Override
    public String getPurposeString() {
        return "Evaluates a static model on a stream.";
    }

    public EvaluateModel() {
    }

    public EvaluateModel(Classifier model, InstanceStream stream, LearningPerformanceEvaluator evaluator, int maxInstances) {
        this.modelOption.setCurrentObject(model);
        this.streamOption.setCurrentObject(stream);
        this.evaluatorOption.setCurrentObject(evaluator);
        this.maxInstancesOption.setValue(maxInstances);
    }

    @Override
    public Class<?> getTaskResultType() {
        return LearningEvaluation.class;
    }

    @Override
    public Object doMainTask(TaskMonitor monitor, ObjectRepository repository) {
        Learner model = (Learner)this.getPreparedClassOption(this.modelOption);
        ExampleStream stream = (ExampleStream)this.getPreparedClassOption(this.streamOption);
        LearningPerformanceEvaluator evaluator = (LearningPerformanceEvaluator)this.getPreparedClassOption(this.evaluatorOption);
        LearningCurve learningCurve = new LearningCurve("learning evaluation instances");
        int maxInstances = this.maxInstancesOption.getValue();
        long instancesProcessed = 0L;
        monitor.setCurrentActivity("Evaluating model...", -1.0);
        File outputPredictionFile = this.outputPredictionFileOption.getFile();
        PrintStream outputPredictionResultStream = null;
        if (outputPredictionFile != null) {
            try {
                outputPredictionResultStream = outputPredictionFile.exists() ? new PrintStream(new FileOutputStream(outputPredictionFile, true), true) : new PrintStream(new FileOutputStream(outputPredictionFile), true);
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to open prediction result file: " + outputPredictionFile, ex);
            }
        }
        while (stream.hasMoreInstances() && (maxInstances < 0 || instancesProcessed < (long)maxInstances)) {
            Object testInst = stream.nextInstance();
            int trueClass = (int)((Instance)testInst.getData()).classValue();
            double[] prediction = model.getVotesForInstance(testInst);
            if (outputPredictionFile != null) {
                outputPredictionResultStream.println(Utils.maxIndex(prediction) + "," + (((Instance)testInst.getData()).classIsMissing() ? " ? " : Integer.valueOf(trueClass)));
            }
            evaluator.addResult(testInst, prediction);
            if (++instancesProcessed % (long)this.sampleFrequencyOption.getValue() == 0L || !stream.hasMoreInstances()) {
                learningCurve.insertEntry(new LearningEvaluation(new Measurement[]{new Measurement("learning evaluation instances", instancesProcessed)}, evaluator, model));
            }
            if (instancesProcessed % 10L != 0L) continue;
            if (monitor.taskShouldAbort()) {
                return null;
            }
            long estimatedRemainingInstances = stream.estimatedRemainingInstances();
            if (maxInstances > 0) {
                long maxRemaining = (long)maxInstances - instancesProcessed;
                if (estimatedRemainingInstances < 0L || maxRemaining < estimatedRemainingInstances) {
                    estimatedRemainingInstances = maxRemaining;
                }
            }
            monitor.setCurrentActivityFractionComplete(estimatedRemainingInstances < 0L ? -1.0 : (double)instancesProcessed / (double)(instancesProcessed + estimatedRemainingInstances));
            if (!monitor.resultPreviewRequested()) continue;
            monitor.setLatestResultPreview(learningCurve.copy());
        }
        if (outputPredictionResultStream != null) {
            outputPredictionResultStream.close();
        }
        return learningCurve;
    }

    @Override
    public ImmutableCapabilities defineImmutableCapabilities() {
        if (this.getClass() == EvaluateModel.class) {
            return new ImmutableCapabilities(Capability.VIEW_STANDARD, Capability.VIEW_LITE);
        }
        return new ImmutableCapabilities(Capability.VIEW_STANDARD);
    }
}

