/*
 * Decompiled with CFR 0.152.
 */
package org.guha.rcdk.view;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import org.openscience.cdk.depict.Abbreviations;
import org.openscience.cdk.depict.Depiction;
import org.openscience.cdk.depict.DepictionGenerator;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.renderer.color.CDK2DAtomColors;
import org.openscience.cdk.renderer.color.IAtomColorer;
import org.openscience.cdk.renderer.color.UniColor;
import org.openscience.cdk.sgroup.Sgroup;
import org.openscience.cdk.sgroup.SgroupKey;
import org.openscience.cdk.sgroup.SgroupType;
import org.openscience.cdk.silent.SilentChemObjectBuilder;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.smiles.smarts.SmartsPattern;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class RcdkDepictor {
    int width = 300;
    int height = 300;
    double zoom = 1.3;
    String style = "cow";
    String annotate = "off";
    String abbr = "on";
    boolean suppressh = true;
    boolean showTitle = false;
    int smaLimit = 100;
    String sma = "";
    private final IChemObjectBuilder builder = SilentChemObjectBuilder.getInstance();
    private final DepictionGenerator generator = new DepictionGenerator();
    private SmilesParser smipar = new SmilesParser(this.builder);
    private final Abbreviations abbreviations = new Abbreviations();
    private final Abbreviations reagents = new Abbreviations();

    public RcdkDepictor(int width, int height) throws IOException {
        this(width, height, 1.3, "cow", "off", "on", true, false, 100, "");
    }

    public RcdkDepictor(int width, int height, double zoom, String style, String annotate, String abbr, boolean suppressh, boolean showTitle, int smaLimit, String sma) throws IOException {
        this.width = width;
        this.height = height;
        this.zoom = zoom;
        this.style = style;
        this.annotate = annotate;
        this.abbr = abbr;
        this.suppressh = suppressh;
        this.showTitle = showTitle;
        this.smaLimit = smaLimit;
        this.sma = sma;
        boolean alignRxnMap = true;
        String fmt = "PNG";
        this.abbreviations.loadFromFile("/org/openscience/cdk/app/abbreviations.smi");
        this.reagents.loadFromFile("/org/openscience/cdk/app/reagents.smi");
        DepictionGenerator myGenerator = this.generator.withSize((double)width, (double)height).withZoom(zoom);
        myGenerator = RcdkDepictor.withStyle(myGenerator, style);
        switch (annotate) {
            case "number": {
                myGenerator = myGenerator.withAtomNumbers();
                abbr = "false";
                break;
            }
            case "mapidx": {
                myGenerator = myGenerator.withAtomMapNumbers();
                break;
            }
            case "atomvalue": {
                myGenerator = myGenerator.withAtomValues();
                break;
            }
            case "colmap": {
                myGenerator = myGenerator.withAtomMapHighlight(new Color[]{new Color(169, 199, 255), new Color(185, 255, 180), new Color(255, 162, 162), new Color(253, 139, 255), new Color(255, 206, 86), new Color(227, 227, 227)}).withOuterGlowHighlight(6.0);
            }
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getAnnotate() {
        return this.annotate;
    }

    public void setAnnotate(String annotate) {
        this.annotate = annotate;
    }

    public String getAbbr() {
        return this.abbr;
    }

    public void setAbbr(String abbr) {
        this.abbr = abbr;
    }

    public boolean isSuppressh() {
        return this.suppressh;
    }

    public void setSuppressh(boolean suppressh) {
        this.suppressh = suppressh;
    }

    public boolean isShowTitle() {
        return this.showTitle;
    }

    public void setShowTitle(boolean showTitle) {
        this.showTitle = showTitle;
    }

    public int getSmaLimit() {
        return this.smaLimit;
    }

    public void setSmaLimit(int smaLimit) {
        this.smaLimit = smaLimit;
    }

    public String getSma() {
        return this.sma;
    }

    public void setSma(String sma) {
        this.sma = sma;
    }

    public BufferedImage getImage(IAtomContainer atomContainer) throws CDKException {
        return this.generate(atomContainer).toImg();
    }

    public byte[] getFormat(IAtomContainer atomContainer, String fmt) throws CDKException, IOException {
        String fmtlc = fmt.toLowerCase(Locale.ROOT);
        Depiction depiction = this.generate(atomContainer);
        switch (fmtlc) {
            case "svg": {
                return depiction.toSvgStr().getBytes();
            }
            case "pdf": {
                return depiction.toPdfStr().getBytes();
            }
            case "png": 
            case "jpg": 
            case "gif": {
                ByteArrayOutputStream bao = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)depiction.toImg(), fmtlc, bao);
                return bao.toByteArray();
            }
        }
        throw new IllegalArgumentException("Unsupported format.");
    }

    private Depiction generate(IAtomContainer atomContainer) throws CDKException {
        DepictionGenerator myGenerator = this.generator.withSize((double)this.width, (double)this.height).withZoom(this.zoom);
        myGenerator = RcdkDepictor.withStyle(myGenerator, this.style);
        switch (this.annotate) {
            case "number": {
                myGenerator = myGenerator.withAtomNumbers();
                this.abbr = "false";
                break;
            }
            case "mapidx": {
                myGenerator = myGenerator.withAtomMapNumbers();
                break;
            }
            case "atomvalue": {
                myGenerator = myGenerator.withAtomValues();
                break;
            }
            case "colmap": {
                myGenerator = myGenerator.withAtomMapHighlight(new Color[]{new Color(169, 199, 255), new Color(185, 255, 180), new Color(255, 162, 162), new Color(253, 139, 255), new Color(255, 206, 86), new Color(227, 227, 227)}).withOuterGlowHighlight(6.0);
            }
        }
        boolean isRxn = false;
        boolean isRgp = false;
        IReaction rxn = null;
        IAtomContainer mol = atomContainer;
        Object mols = null;
        if (this.suppressh) {
            AtomContainerManipulator.suppressHydrogens((IAtomContainer)mol);
        }
        Set<IChemObject> highlight = this.findHits(this.sma, rxn, mol, this.smaLimit);
        this.abbreviate(mol, this.abbr, this.annotate);
        if (this.suppressh) {
            AtomContainerManipulator.suppressHydrogens((IAtomContainer)atomContainer);
        }
        highlight = this.findHits(this.sma, rxn, atomContainer, this.smaLimit);
        this.abbreviate(atomContainer, this.abbr, this.annotate);
        switch (this.style) {
            case "nob": {
                myGenerator = myGenerator.withHighlight(highlight, new Color(0xFFAAAA));
                break;
            }
            case "bow": 
            case "wob": {
                myGenerator = myGenerator.withHighlight(highlight, new Color(0xFF0000));
                break;
            }
            default: {
                myGenerator = myGenerator.withHighlight(highlight, new Color(0xAAFFAA));
            }
        }
        if (this.showTitle) {
            myGenerator = myGenerator.withMolTitle();
        }
        Depiction depiction = myGenerator.depict(atomContainer);
        return depiction;
    }

    private void contractHydrates(IAtomContainer mol) {
        HashSet<IAtom> hydrate = new HashSet<IAtom>();
        for (IAtom atom : mol.atoms()) {
            if (atom.getAtomicNumber() != 8 || atom.getImplicitHydrogenCount() != 2 || mol.getConnectedAtomsList(atom).size() != 0) continue;
            hydrate.add(atom);
        }
        if (hydrate.size() < 2) {
            return;
        }
        ArrayList<Sgroup> sgroups = (ArrayList<Sgroup>)mol.getProperty((Object)"cdk:CtabSgroups", List.class);
        if (sgroups == null) {
            sgroups = new ArrayList();
            mol.setProperty((Object)"cdk:CtabSgroups", sgroups);
        } else {
            sgroups = new ArrayList<Sgroup>(sgroups);
        }
        Sgroup sgrp = new Sgroup();
        for (IAtom atom : hydrate) {
            sgrp.addAtom(atom);
        }
        sgrp.putValue(SgroupKey.CtabParentAtomList, Collections.singleton(hydrate.iterator().next()));
        sgrp.setType(SgroupType.CtabMultipleGroup);
        sgrp.setSubscript(Integer.toString(hydrate.size()));
        sgroups.add(sgrp);
    }

    private boolean add(Set<IAtom> set, Set<IAtom> atomsToAdd) {
        boolean res = true;
        for (IAtom atom : atomsToAdd) {
            if (set.add(atom)) continue;
            res = false;
        }
        return res;
    }

    private void abbreviate(IReaction rxn, String mode, String annotate) {
        HashMap<IAtomContainer, ArrayList> sgroupmap = new HashMap<IAtomContainer, ArrayList>();
        switch (mode.toLowerCase()) {
            case "true": 
            case "on": 
            case "yes": {
                HashSet<IAtom> atoms;
                for (IAtomContainer mol2 : rxn.getReactants().atomContainers()) {
                    this.contractHydrates(mol2);
                    atoms = new HashSet<IAtom>();
                    for (Sgroup sgroup : this.abbreviations.generate(mol2)) {
                        if (!this.add(atoms, sgroup.getAtoms())) continue;
                        sgroupmap.computeIfAbsent(mol2, k -> new ArrayList()).add(sgroup);
                    }
                }
                for (IAtomContainer mol2 : rxn.getProducts().atomContainers()) {
                    this.contractHydrates(mol2);
                    atoms = new HashSet();
                    for (Sgroup sgroup : this.abbreviations.generate(mol2)) {
                        if (!this.add(atoms, sgroup.getAtoms())) continue;
                        sgroupmap.computeIfAbsent(mol2, k -> new ArrayList()).add(sgroup);
                    }
                }
                for (IAtomContainer mol2 : rxn.getAgents().atomContainers()) {
                    this.contractHydrates(mol2);
                    this.reagents.apply(mol2);
                    this.abbreviations.apply(mol2);
                }
                break;
            }
            case "groups": {
                for (IAtomContainer mol2 : rxn.getAgents().atomContainers()) {
                    this.contractHydrates(mol2);
                    this.abbreviations.apply(mol2);
                }
                break;
            }
            case "reagents": {
                for (IAtomContainer mol2 : rxn.getAgents().atomContainers()) {
                    this.contractHydrates(mol2);
                    this.reagents.apply(mol2);
                }
                break;
            }
        }
        HashSet include = new HashSet();
        sgroupmap.forEach((mol, valcoll) -> valcoll.forEach(abbrv -> {
            int numAtoms = mol.getAtomCount();
            if (abbrv.getBonds().isEmpty()) {
                include.add(abbrv.getSubscript());
            } else {
                int numAbbr = abbrv.getAtoms().size();
                double f = (double)numAbbr / (double)numAtoms;
                if (numAtoms - numAbbr > 1 && f <= 0.4) {
                    include.add(abbrv.getSubscript());
                }
            }
        }));
        for (Map.Entry e : sgroupmap.entrySet()) {
            IAtomContainer mol2;
            mol2 = (IAtomContainer)e.getKey();
            ArrayList<Object> sgroups = (ArrayList<Sgroup>)mol2.getProperty((Object)"cdk:CtabSgroups");
            sgroups = sgroups == null ? new ArrayList<Sgroup>() : new ArrayList(sgroups);
            mol2.setProperty((Object)"cdk:CtabSgroups", sgroups);
            for (Sgroup abbrv : (ArrayList)e.getValue()) {
                if (!include.contains(abbrv.getSubscript())) continue;
                sgroups.add(abbrv);
            }
        }
    }

    private void abbreviate(IAtomContainer mol, String mode, String annotate) {
        switch (mode.toLowerCase()) {
            case "true": 
            case "on": 
            case "yes": 
            case "groups": {
                this.contractHydrates(mol);
                this.abbreviations.apply(mol);
                break;
            }
            case "reagents": {
                this.contractHydrates(mol);
            }
        }
        if ("mapidx".equals(annotate)) {
            List sgroups = (List)mol.getProperty((Object)"cdk:CtabSgroups");
            ArrayList<Sgroup> filtered = new ArrayList<Sgroup>();
            if (sgroups != null) {
                for (Sgroup sgroup : sgroups) {
                    if (sgroup.getType() == SgroupType.CtabAbbreviation || sgroup.getType() == SgroupType.CtabMultipleGroup) {
                        boolean okay = true;
                        for (IAtom atom : sgroup.getAtoms()) {
                            if (atom.getProperty((Object)"cdk:AtomAtomMapping") == null) continue;
                            okay = false;
                            break;
                        }
                        if (!okay) continue;
                        filtered.add(sgroup);
                        continue;
                    }
                    filtered.add(sgroup);
                }
                mol.setProperty((Object)"cdk:CtabSgroups", filtered);
            }
        }
    }

    private boolean isRxnSmi(String smi) {
        return smi.split(" ")[0].contains(">");
    }

    private static DepictionGenerator withStyle(DepictionGenerator generator, String style) {
        switch (style) {
            case "cow": {
                generator = generator.withAtomColors((IAtomColorer)new CDK2DAtomColors()).withBackgroundColor(Color.WHITE).withOuterGlowHighlight();
                break;
            }
            case "bow": {
                generator = generator.withAtomColors((IAtomColorer)new UniColor(Color.BLACK)).withBackgroundColor(Color.WHITE);
                break;
            }
            case "wob": {
                generator = generator.withAtomColors((IAtomColorer)new UniColor(Color.WHITE)).withBackgroundColor(Color.BLACK);
                break;
            }
            case "cob": {
                generator = generator.withAtomColors((IAtomColorer)new CobColorer()).withBackgroundColor(Color.BLACK).withOuterGlowHighlight();
                break;
            }
            case "nob": {
                generator = generator.withAtomColors((IAtomColorer)new NobColorer()).withBackgroundColor(Color.BLACK).withOuterGlowHighlight();
            }
        }
        return generator;
    }

    private Set<IChemObject> findHits(String sma, IReaction rxn, IAtomContainer mol, int limit) {
        HashSet<IChemObject> highlight;
        block6: {
            SmartsPattern smartsPattern;
            block7: {
                highlight = new HashSet<IChemObject>();
                if (sma.isEmpty()) break block6;
                try {
                    smartsPattern = SmartsPattern.create((String)sma, null);
                }
                catch (Error | Exception e) {
                    return Collections.emptySet();
                }
                if (mol == null) break block7;
                for (Map m : smartsPattern.matchAll(mol).limit(limit).uniqueAtoms().toAtomBondMap()) {
                    for (Map.Entry e : m.entrySet()) {
                        highlight.add((IChemObject)e.getValue());
                    }
                }
                break block6;
            }
            if (rxn == null) break block6;
            for (Map m : smartsPattern.matchAll(rxn).limit(limit).uniqueAtoms().toAtomBondMap()) {
                for (Map.Entry e : m.entrySet()) {
                    highlight.add((IChemObject)e.getValue());
                }
            }
        }
        return highlight;
    }

    private static final class NobColorer
    implements IAtomColorer {
        private final CDK2DAtomColors colors = new CDK2DAtomColors();
        private final Color NEON = new Color(65294);

        private NobColorer() {
        }

        public Color getAtomColor(IAtom atom) {
            Color res = this.colors.getAtomColor(atom);
            if (res.equals(Color.BLACK)) {
                return this.NEON;
            }
            return res;
        }

        public Color getAtomColor(IAtom atom, Color color) {
            Color res = this.colors.getAtomColor(atom, color);
            if (res.equals(Color.BLACK)) {
                return this.NEON;
            }
            return res;
        }
    }

    private static final class CobColorer
    implements IAtomColorer {
        private final CDK2DAtomColors colors = new CDK2DAtomColors();

        private CobColorer() {
        }

        public Color getAtomColor(IAtom atom) {
            Color res = this.colors.getAtomColor(atom);
            if (res.equals(Color.BLACK)) {
                return Color.WHITE;
            }
            return res;
        }

        public Color getAtomColor(IAtom atom, Color color) {
            Color res = this.colors.getAtomColor(atom);
            if (res.equals(Color.BLACK)) {
                return Color.WHITE;
            }
            return res;
        }
    }
}

