/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.widgets;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import org.af.commons.widgets.MyJPopupMenu;
import org.af.commons.widgets.tables.ExtendedJTable;
import org.af.jhlir.call.RDataFrame;
import org.af.jhlir.call.RMatrixDouble;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mutoss.gui.widgets.ContrastColorRenderer;
import org.mutoss.gui.widgets.ContrastTableModel;
import org.mutoss.gui.widgets.GroupingBox;
import org.mutoss.gui.widgets.LevelOrderSL;

public class ContrastTable
extends ExtendedJTable
implements ActionListener {
    private MyJPopupMenu popupMenu;
    private GroupingBox cbGroup;
    private LevelOrderSL slLevelOrder;
    private RDataFrame df;
    protected static final Log logger = LogFactory.getLog(ContrastTable.class);
    JLabel jlInfo;

    public ContrastTable(RDataFrame df, GroupingBox cbGroup, LevelOrderSL slLevelOrder, JLabel jlInfo) {
        this.setDefaultRenderer(Double.class, new ContrastColorRenderer());
        cbGroup.addActionListener(this);
        this.cbGroup = cbGroup;
        this.slLevelOrder = slLevelOrder;
        this.jlInfo = jlInfo;
        this.df = df;
        this.buildModel();
        this.setRowSelectionAllowed(true);
        this.popupMenu = new MyJPopupMenu(new String[]{"Add Line", "Delete Line"}, new String[]{"add_line", "del_line"}, (ActionListener)this);
        this.setComponentPopupMenu((JPopupMenu)this.popupMenu);
        this.setPreferredWidth(800);
    }

    public void addMatrix(RMatrixDouble m) throws RemoteException {
        logger.info((Object)("Adding matrix:\n " + m + "."));
        for (int i = 0; i < m.nrow(); ++i) {
            logger.info((Object)("Adding row " + i + "."));
            this.getContrastModel().addLine(m.getRow(i));
        }
        logger.info((Object)"Contrast matrix successfully added.");
    }

    private void buildModel() {
        List groupLevels = this.slLevelOrder.getRight();
        this.setModel(new ContrastTableModel(groupLevels, this.jlInfo));
    }

    public ContrastTableModel getContrastModel() {
        return (ContrastTableModel)super.getModel();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("add_line")) {
            this.getContrastModel().addLine();
        } else if (e.getActionCommand().equals("del_line")) {
            int[] rows;
            for (int i : rows = this.getSelectedRows()) {
                if (i < 0 || i >= this.getRowCount()) continue;
                this.getContrastModel().removeLine(i);
            }
        } else if (e.getSource().equals((Object)this.cbGroup)) {
            this.buildModel();
        }
        this.getContrastModel().check();
    }

    public void scale() {
        this.getContrastModel().scale();
    }

    public String getMatrix() {
        return this.getContrastModel().getMatrix();
    }

    public void setRatio(boolean b) {
        this.getContrastModel().setRatio(b);
    }
}

