/*-------------------------------------------------------------------------
 |                                                                         
 |                    SAS SETUP FILE FOR ICPSR 36657
 |                NATIONAL PRISONER STATISTICS, 1978-2015
 |                            (DATASET 0001: )
 |
 |
 | SAS setup sections are provided for the ASCII version of this data
 | collection.  These sections are listed below:
 |
 | PROC FORMAT:  creates user-defined formats for the variables. Formats
 | replace original value codes with value code descriptions. Only
 | variables with user-defined formats are included in this section.
 |
 | DATA:  begins a SAS data step and names an output SAS data set.
 |
 | INFILE:  identifies the input file to be read with the input statement.
 | Users must replace the "data-filename" with a filename specifying the
 | directory on the user's computer system in which the downloaded and
 | unzipped data file is physically located (e.g.,
 | "c:\temp\36657-0001-data.txt").
 |
 | INPUT:  assigns the name, type, decimal specification (if any), and
 | specifies the beginning and ending column locations for each variable
 | in the data file.
 |
 | LABEL:  assigns descriptive labels to all variables. Variable labels
 | and variable names may be identical for some variables.
 |
 | MISSING VALUE RECODES:  sets user-defined numeric missing values to
 | missing as interpreted by the SAS system. Only variables with
 | user-defined missing values are included in this section.
 |
 | If any variables have more than one missing value, they are assigned
 | to the standard missing value of a single period (.) in the statement
 | below. To maintain the original meaning of missing codes, users may want
 | to take advantage of the SAS missing values (the letters A-Z or an
 | underscore preceded by a period).
 |
 | An example of a standard missing value recode:
 |
 |   IF (RELATION = 98 OR RELATION = 99) THEN RELATION = .; 
 |
 | The same example using special missing value recodes:
 |
 |    IF RELATION = 98 THEN RELATION = .A;
 |    IF RELATION = 99 THEN RELATION = .B;
 |
 | FORMAT:  associates the formats created by the PROC FORMAT step with
 | the variables named in the INPUT statement.
 |
 | NOTE:  Users should modify this setup file to suit their specific needs.
 | Sections for PROC FORMAT, FORMAT, and MISSING VALUE RECODES have been
 | commented out (i.e., '/*'). To include these sections in the final SAS
 | setup, users should remove the SAS comment indicators from the desired
 | section(s).
 |
 |------------------------------------------------------------------------*/

* SAS PROC FORMAT;

/*
PROC FORMAT;
VALUE stateidf  1='(01) 01. Alabama' 2='(02) 02. Alaska' 4='(04) 04. Arizona'
                5='(05) 05. Arkansas' 6='(06) 06. California' 8='(08) 08. Colorado'
                9='(09) 09. Connecticut' 10='(10) 10. Delaware' 11='(11) 11. District of Columbia'
                12='(12) 12. Florida' 13='(13) 13. Georgia' 15='(15) 15. Hawaii' 16='(16) 16. Idaho'
                17='(17) 17. Illinois' 18='(18) 18. Indiana' 19='(19) 19. Iowa' 20='(20) 20. Kansas'
                21='(21) 21. Kentucky' 22='(22) 22. Louisiana' 23='(23) 23. Maine' 24='(24) 24. Maryland'
                25='(25) 25. Massachusetts' 26='(26) 26. Michigan' 27='(27) 27. Minnesota'
                28='(28) 28. Mississippi' 29='(29) 29. Missouri' 30='(30) 30. Montana'
                31='(31) 31. Nebraska' 32='(32) 32. Nevada' 33='(33) 33. New Hampshire'
                34='(34) 34. New Jersey' 35='(35) 35. New Mexico' 36='(36) 36. New York'
                37='(37) 37. North Carolina' 38='(38) 38. North Dakota' 39='(39) 39. Ohio'
                40='(40) 40. Oklahoma' 41='(41) 41. Oregon' 42='(42) 42. Pennsylvania'
                44='(44) 44. Rhode Island' 45='(45) 45. South Carolina' 46='(46) 46. South Dakota'
                47='(47) 47. Tennessee' 48='(48) 48. Texas' 49='(49) 49. Utah' 50='(50) 50. Vermont'
                51='(51) 51. Virginia' 52='(52) 52. Jurisdiction shared between States'
                53='(53) 53. Washington' 54='(54) 54. West Virginia' 55='(55) 55. Wisconsin'
                56='(56) 56. Wyoming' 60='(60) State prison total'
                70='(70) US prison total (state+federal)' 99='(99) Federal BOP';
VALUE pvinclmf  -9='(-9) Data are missing because the state did not respond to the item'
                -8='(-8) Data are missing because the item was not applicable to the state'
                -2='(-2) Item was asked, but only in the aggregate prison population, not by male or female'
                -1='(-1) Item not asked in survey for this year' 1='(1) Yes' 2='(2) No';
VALUE commitff  -9='(-9) Data are missing because the state did not respond to the item'
                -8='(-8) Data are missing because the item was not applicable to the state'
                -7='(-7) Item was asked for both males and females, but only the aggregate was reported'
                -2='(-2) Item was asked, but only in the aggregate prison population, not by male or female'
                -1='(-1) Item not asked in survey for this year';
VALUE regionff  1='(1) Northeast' 2='(2) Midwest' 3='(3) South' 4='(4) West'
                5='(5) U.S. total' 6='(6) Federal Bureau of Prisons' 7='(7) State total';
VALUE cusgt1mf  -9='(-9) Data are missing because the state did not respond to the item'
                -8='(-8) Data are missing because the item was not applicable to the state'
                -2='(-2) Item was asked, but only in the aggregate prison population, not by male or female'
                -1='(-1) Item not asked in survey for this year';
*/


* SAS DATA, INFILE, INPUT STATEMENTS;

DATA;
INFILE "data-filename" LRECL=826;
INPUT
       YEAR 1-4                STATEID 5-6
        STATE $7-8              REGION 9                CUSGT1M 10-16
        CUSGT1F 17-21           CUSLT1M 22-26           CUSLT1F 27-30
        CUSUNSM 31-35           CUSUNSF 36-39           CUSTOTM 40-46
        CUSTOTF 47-51           CUSGT1T 52-57           CUSLT1T 58-61
        CUSUNST 62-65           CUSTOTT 66-71           CNOPRIVM 72-78
        CNOPRIVF 79-83          CWPRIVM 84-90           CWPRIVF 91-96
        JURGT1M 97-103          JURGT1F 104-109         JURLT1M 110-114
        JURLT1F 115-118         JURUNSM 119-123         JURUNSF 124-127
        JURTOTM 128-134         JURTOTF 135-140         PVINM 141-145
        PVINF 146-149           PVOTHM 150-154          PVOTHF 155-158
        PVINCLM 159-160         PVINCLF 161-162         LFM 163-167
        LFF 168-171             LFINCLM 172-173         LFINCLF 174-175
        LFCROWDM 176-180        LFCROWDF 181-184        LFCRSTM 185-186
        LFCRSTF 187-188         LFCRINCM 189-190        LFCRINCF 191-192
        FEDM 193-196            FEDF 197-199            OTHSTM 200-203
        OTHSTF 204-206          FACINCLM 207-208        FACINCLF 209-210
        FACROWDM 211-214        FACROWDF 215-217        WHITEM 218-223
        WHITEF 224-228          BLACKM 229-234          BLACKF 235-239
        HISPM 240-245           HISPF 246-250           AIANM 251-255
        AIANF 256-259           ASIANM 260-263          ASIANF 264-267
        NHPIM 268-271           NHPIF 272-274           APIM 275-278
        APIF 279-281            TWORACEM 282-284        TWORACEF 285-287
        ADDRACEM 288-293        ADDRACEF 294-297        UNKRACEM 298-303
        UNKRACEF 304-307        TOTRACEM 308-314        TOTRACEF 315-320
        NOTHISPM 321-326        NOTHISPF 327-331        UNKHISPM 332-337
        UNKHISPF 338-342        TOTHCATM 343-349        TOTHCATF 350-354
        COMMITM 355-360         COMMITF 361-365         PARNEWM 366-370
        PARNEWF 371-374         PARNOM 375-380          PARNOF 381-385
        ADCRNEWM 386-390        ADCRNEWF 391-394        ADCRNOM 395-399
        ADCRNOF 400-404         ADTRANSM 405-408        ADTRANSF 409-411
        ADAWOLM 412-415         ADAWOLF 416-418         ADESCAPM 419-422
        ADESCAPF 423-425        ADAWESM 426-430         ADAWESF 431-434
        ADRETM 435-438          ADRETF 439-441          ADOTHM 442-446
        ADOTHF 447-450          ADTOTM 451-456          ADTOTF 457-461
        RLUNEXPM 462-467        RLUNEXPF 468-472        RLUNCOMM 473-476
        RLUNCOMF 477-479        RLUNOTHM 480-484        RLUNOTHF 485-488
        RLCOPROM 489-493        RLCOPROF 494-498        RLCOSUPM 499-504
        RLCOSUPF 505-509        RLCODPM 510-515         RLCODPF 516-520
        RLCOOTHM 521-525        RLCOOTHF 526-529        RLDEATHM 530-533
        RLDEATHF 534-536        RLAWOLM 537-540         RLAWOLF 541-543
        RLESCAPM 544-547        RLESCAPF 548-550        RLAWESM 551-555
        RLAWESF 556-559         RLTRANM 560-563         RLTRANF 564-566
        RLBONDM 567-570         RLBONDF 571-573         RLOTHM 574-578
        RLOTHF 579-582          RLTOTM 583-588          RLTOTF 589-593
        FLOJANM 594-600         FLOJANF 601-606         FLOADMM 607-612
        FLOADMF 613-617         FLORLM 618-623          FLORLF 624-629
        FLODECM 630-636         FLODECF 637-642         CAPRATEM 643-648
        CAPRATEF 649-653        CAPOPM 654-660          CAPOPF 661-665
        CAPDESM 666-671         CAPDESF 672-676         CAPRATET 677-682
        CAPOPT 683-688          CAPDEST 689-694         HIVTEST 695-696
        HIVINC 697-698          HIVCUR 699-701          HIVREL 702-704
        HIVRAN 705-707          HIVCERT 708-710         HIVHIGH 711-712
        HIVREQ 713-714          HIVORD 715-716          HIVCLIN 717-718
        HIVINCID 719-720        HIVOTH 721-722          HIVASYMM 723-724
        HIVASYMF 725-726        HIVASYMT 727-728        HIVLESSM 729-730
        HIVLESSF 731-732        HIVLESST 733-734        AIDSCONM 735-736
        AIDSCONF 737-738        AIDSCONT 739-742        HIVATOTM 743-747
        HIVATOTF 748-751        HIVATOTT 752-756        CUSLT18M 757-760
        CUSLT18F 761-763        CUSCTZNM 764-768        CUSCTZNF 769-772
        DTHEXECM 773-774        DTHEXECF 775-776        DTHILLNM 777-780
        DTHILLNF 781-783        DTHAIDSM 784-786        DTHAIDSF 787-788
        DTHSUICM 789-791        DTHSUICF 792-793        DTHACCM 794-795
        DTHACCF 796-797         DTHHOMIM 798-799        DTHHOMIF 800-801
        DTHHOMOM 802-803        DTHHOMOF 804-805        DTHPERSM 806-808
        DTHPERSF 809-810        DTHOTHM 811-813         DTHOTHF 814-815
        DTHTOTM 816-819         DTHTOTF 820-822         HANDLEM 823-824
        HANDLEF 825-826         ;


* SAS LABEL STATEMENT;

LABEL 
   YEAR    = 'SURVEY YEAR' 
   STATEID = 'STATE FIPS IDENTIFICATION CODE' 
   STATE   = 'STATE TWO-CHARACTER IDENTIFICATION ABBREVIATION' 
   REGION  = 'STATE REGIONAL CODE' 
   CUSGT1M = 'CUSTODY WITH MAXIMUM SENTENCE GREATER THAN 1 YEAR, MALES' 
   CUSGT1F = 'CUSTODY WITH MAXIMUM SENTENCE GREATER THAN 1 YEAR, FEMALES' 
   CUSLT1M = 'CUSTODY WITH MAXIMUM SENTENCE 1 YEAR OR LESS, MALES' 
   CUSLT1F = 'CUSTODY WITH MAXIMUM SENTENCE 1 YEAR OR LESS, FEMALES' 
   CUSUNSM = 'CUSTODY UNSENTENCED, MALES' 
   CUSUNSF = 'CUSTODY UNSENTENCED, FEMALES' 
   CUSTOTM = 'TOTAL UNDER CUSTODY, MALES' 
   CUSTOTF = 'TOTAL UNDER CUSTODY, FEMALES' 
   CUSGT1T = 'CUSTODY WITH MAXIMUM SENTENCE GREATER THAN 1 YEAR, TOTAL (1978-1982 ONLY)' 
   CUSLT1T = 'CUSTODY WITH MAXIMUM SENTENCE 1 YEAR OR LESS, TOTAL (1978-1982 ONLY)' 
   CUSUNST = 'CUSTODY UNSENTENCED, TOTAL (1978-1982 ONLY)' 
   CUSTOTT = 'TOTAL UNDER CUSTODY, TOTAL (1978-1982 ONLY)' 
   CNOPRIVM= 'CUSTODY, EXCLUDING PRIVATE FACILITIES, MALE' 
   CNOPRIVF= 'CUSTODY, EXCLUDING PRIVATE FACILITIES, FEMALE' 
   CWPRIVM = 'CUSTODY, INCLUDING PRIVATE FACILITIES, MALE' 
   CWPRIVF = 'CUSTODY, INCLUDING PRIVATE FACILITIES, FEMALE' 
   JURGT1M = 'JURISDICTION WITH MAXIMUM SENTENCE GREATER THAN 1 YEAR, MALES' 
   JURGT1F = 'JURISDICTION WITH MAXIMUM SENTENCE GREATER THAN 1 YEAR, FEMALES' 
   JURLT1M = 'JURISDICTION WITH MAXIMUM SENTENCE 1 YEAR OR LESS, MALES' 
   JURLT1F = 'JURISDICTION WITH MAXIMUM SENTENCE 1 YEAR OR LESS, FEMALES' 
   JURUNSM = 'JURISDICTION UNSENTENCED, MALES' 
   JURUNSF = 'JURISDICTION UNSENTENCED, FEMALES' 
   JURTOTM = 'TOTAL UNDER JURISDICTION, MALES' 
   JURTOTF = 'TOTAL UNDER JURISDICTION, FEMALES' 
   PVINM   = 'INMATES UNDER JURISDICTION HOUSED IN PRIVATELY OPERATED CORRECTIONAL FACILITY IN STATE, MALE' 
   PVINF   = 'INMATES UNDER JURISDICTION HOUSED IN PRIVATELY OPERATED CORRECTIONAL FACILITY IN STATE, FEMALE' 
   PVOTHM  = 'INMATES UNDER JURISDICTION HOUSED IN PRIVATELY OPERATED CORRECTIONAL FACILITY IN OTHER STATE, MALE' 
   PVOTHF  = 'INMATES UNDER JURISDICTION HOUSED IN PRIVATELY OPERATED CORRECTIONAL FACILITY IN OTHER STATE, FEMALE' 
   PVINCLM = 'ARE PRIVATELY OPERATED CORRECTION FACILITY NUMBERS INCLUDED IN JURISDICTION TOTALS, MALE' 
   PVINCLF = 'ARE PRIVATELY OPERATED CORRECTION FACILITY NUMBERS INCLUDED IN JURISDICTION TOTALS, FEMALE' 
   LFM     = 'INMATES UNDER JURISDICTION HOUSED IN LOCAL FACILITIES OPERATED BY COUNTY OR OTHER LOCAL AUTHORITY, 
MALE' 
   LFF     = 'INMATES UNDER JURISDICTION HOUSED IN LOCAL FACILITIES OPERATED BY COUNTY OR OTHER LOCAL AUTHORITY, 
FEMALE' 
   LFINCLM = 'ARE LOCAL FACILITIES INCLUDED IN JURISDICTION TOTALS, MALE' 
   LFINCLF = 'ARE LOCAL FACILITIES INCLUDED IN JURISDICTION TOTALS, FEMALE' 
   LFCROWDM= 'LOCAL FACILITIES SOLELY TO EASE PRISON CROWDING, MALE' 
   LFCROWDF= 'LOCAL FACILITIES SOLELY TO EASE PRISON CROWDING, FEMALE' 
   LFCRSTM = 'LOCAL FACILITIES SOLELY TO EASE PRISON CROWDING, MALE (1978 ONLY)' 
   LFCRSTF = 'LOCAL FACILITIES SOLELY TO EASE PRISON CROWDING, FEMALE (1978 ONLY)' 
   LFCRINCM= 'LOCAL FACILITIES SOLELY TO EASE CROWDING, INCLUDED IN JURISDICTION TOTALS, MALE' 
   LFCRINCF= 'LOCAL FACILITIES SOLELY TO EASE CROWDING, INCLUDED IN JURISDICTION TOTALS, FEMALE' 
   FEDM    = 'INMATES UNDER JURISDICTION HOUSED IN FEDERAL FACILITIES, MALE' 
   FEDF    = 'INMATES UNDER JURISDICTION HOUSED IN FEDERAL FACILITIES, FEMALE' 
   OTHSTM  = 'INMATES UNDER JURISDICTION HOUSED IN OTHER STATES'' FACILITIES, MALE' 
   OTHSTF  = 'INMATES UNDER JURISDICTION HOUSED IN OTHER STATES'' FACILITIES, FEMALE' 
   FACINCLM= 'ARE FEDERAL OR OTHER STATES'' FACILITIES INCLUDED IN JURISDICTION TOTALS, MALE' 
   FACINCLF= 'ARE FEDERAL OR OTHER STATES'' FACILITIES INCLUDED IN JURISDICTION TOTALS, FEMALE' 
   FACROWDM= 'FEDERAL OR OTHER STATES'' FACILITIES SOLELY TO EASE CROWDING, MALE' 
   FACROWDF= 'FEDERAL OR OTHER STATES'' FACILITIES SOLELY TO EASE CROWDING, FEMALE' 
   WHITEM  = 'WHITE MALE' 
   WHITEF  = 'WHITE FEMALE' 
   BLACKM  = 'BLACK MALE' 
   BLACKF  = 'BLACK FEMALE' 
   HISPM   = 'HISPANIC OR LATINO MALE' 
   HISPF   = 'HISPANIC OR LATINO FEMALE' 
   AIANM   = 'AMERICAN INDIAN OR ALASKA NATIVE MALE' 
   AIANF   = 'AMERICAN INDIAN OR ALASKA NATIVE FEMALE' 
   ASIANM  = 'ASIAN MALE' 
   ASIANF  = 'ASIAN FEMALE' 
   NHPIM   = 'NATIVE HAWAIIAN OR OTHER PACIFIC ISLANDER MALE' 
   NHPIF   = 'NATIVE HAWAIIAN OR OTHER PACIFIC ISLAND FEMALE' 
   APIM    = 'ASIAN OR PACIFIC ISLANDER MALE' 
   APIF    = 'ASIAN OR PACIFIC ISLANDER FEMALE' 
   TWORACEM= 'TWO OR MORE RACES MALE' 
   TWORACEF= 'TWO OR MORE RACES FEMALE' 
   ADDRACEM= 'ADDITIONAL/OTHER CATEGORIES FOR RACE, MALE' 
   ADDRACEF= 'ADDITIONAL/OTHER CATEGORIES FOR RACE, FEMALE' 
   UNKRACEM= 'UNKNOWN RACE, MALE' 
   UNKRACEF= 'UNKNOWN RACE, FEMALE' 
   TOTRACEM= 'TOTAL RACE, MALE' 
   TOTRACEF= 'TOTAL RACE, FEMALE' 
   NOTHISPM= 'NOT OF HISPANIC ORIGIN, MALE' 
   NOTHISPF= 'NOT OF HISPANIC ORIGIN, FEMALE' 
   UNKHISPM= 'UNKNOWN HISPANIC OR LATINO ORIGIN, MALE' 
   UNKHISPF= 'UNKNOWN HISPANIC OR LATINO ORIGIN, FEMALE' 
   TOTHCATM= 'TOTAL HISPANIC, NON-HISPANIC, AND UNKNOWN, MALE' 
   TOTHCATF= 'TOTAL HISPANIC, NON-HISPANIC, AND UNKNOWN, FEMALE' 
   COMMITM = 'NEW COURT COMMITMENTS, MALE' 
   COMMITF = 'NEW  COURT COMMITMENTS, FEMALE' 
   PARNEWM = 'PAROLE VIOLATORS WITH NEW SENTENCE, MALE' 
   PARNEWF = 'PAROLE VIOLATORS WITH NEW SENTENCE, FEMALE' 
   PARNOM  = 'PAROLE VIOLATORS WITHOUT NEW SENTENCE, MALE' 
   PARNOF  = 'PAROLE VIOLATORS WITHOUT NEW SENTENCE, FEMALE' 
   ADCRNEWM= 'OTHER CONDITIONAL RELEASE VIOLATORS ADMITTED WITH NEW SENTENCE, MALE' 
   ADCRNEWF= 'OTHER CONDITIONAL RELEASE VIOLATORS ADMITTED WITH NEW SENTENCE, FEMALE' 
   ADCRNOM = 'OTHER CONDITIONAL RELEASE VIOLATORS ADMITTED WITHOUT NEW SENTENCE, MALE' 
   ADCRNOF = 'OTHER CONDITIONAL RELEASE VIOLATORS ADMITTED WITHOUT NEW SENTENCE, FEMALE' 
   ADTRANSM= 'TRANSFERS ADMITTED FROM OTHER JURISDICTIONS, MALE' 
   ADTRANSF= 'TRANSFERS ADMITTED FROM OTHER JURISDICTIONS, FEMALE' 
   ADAWOLM = 'AWOL RETURNS, WITH OR WITHOUT NEW SENTENCES, MALE' 
   ADAWOLF = 'AWOL RETURNS, WITH OR WITHOUT NEW SENTENCES, FEMALE' 
   ADESCAPM= 'ESCAPEE RETURNS, WITH OR WITHOUT NEW SENTENCES, MALE' 
   ADESCAPF= 'ESCAPEE RETURNS, WITH OR WITHOUT NEW SENTENCES, FEMALE' 
   ADAWESM = 'AWOL OR ESCAPEE RETURNS, COMBINED, MALE' 
   ADAWESF = 'AWOL OR ESCAPEE RETURNS, COMBINED, FEMALE' 
   ADRETM  = 'RETURNS FROM APPEAL OR BOND, MALE' 
   ADRETF  = 'RETURNS FROM APPEAL OR BOND, FEMALE' 
   ADOTHM  = 'OTHER ADMISSIONS, MALE' 
   ADOTHF  = 'OTHER ADMISSIONS, FEMALE' 
   ADTOTM  = 'TOTAL ADMISSIONS, MALE' 
   ADTOTF  = 'TOTAL ADMISSIONS, FEMALE' 
   RLUNEXPM= 'UNCONDITIONAL RELEASE EXPIRATIONS OF SENTENCE, MALE' 
   RLUNEXPF= 'UNCONDITIONAL RELEASE EXPIRATIONS OF SENTENCE, FEMALE' 
   RLUNCOMM= 'UNCONDITIONAL RELEASE COMMUTATIONS, MALE' 
   RLUNCOMF= 'UNCONDITIONAL RELEASE COMMUTATIONS, FEMALE' 
   RLUNOTHM= 'OTHER UNCONDITIONAL RELEASE, MALE' 
   RLUNOTHF= 'OTHER UNCONDITIONAL RELEASE, FEMALE' 
   RLCOPROM= 'CONDITIONAL RELEASE PROBATIONS, MALE' 
   RLCOPROF= 'CONDITIONAL RELEASE PROBATIONS, FEMALE' 
   RLCOSUPM= 'SUPERVISED MANDATORY RELEASE, MALE' 
   RLCOSUPF= 'SUPERVISED MANDATORY RELEASE, FEMALE' 
   RLCODPM = 'DISCRETIONARY PAROLE, MALE' 
   RLCODPF = 'DISCRETIONARY PAROLE, FEMALE' 
   RLCOOTHM= 'OTHER CONDITIONAL RELEASE, MALE' 
   RLCOOTHF= 'OTHER CONDITIONAL RELEASE, FEMALE' 
   RLDEATHM= 'DEATHS, MALE' 
   RLDEATHF= 'DEATHS, FEMALE' 
   RLAWOLM = 'AWOL RELEASE, MALE' 
   RLAWOLF = 'AWOL RELEASE, FEMALE' 
   RLESCAPM= 'ESCAPE FROM CONFINEMENT, MALE' 
   RLESCAPF= 'ESCAPE FROM CONFINEMENT, FEMALE' 
   RLAWESM = 'AWOL RELEASE OR ESCAPE, COMBINED, MALE' 
   RLAWESF = 'AWOL RELEASE OR ESCAPE, COMBINED, FEMALE' 
   RLTRANM = 'TRANSFERS TO OTHER JURISDICTIONS, MALE' 
   RLTRANF = 'TRANSFERS TO OTHER JURISDICTIONS, FEMALE' 
   RLBONDM = 'RELEASE TO APPEAL OR BOND, MALE' 
   RLBONDF = 'RELEASE TO APPEAL OR BOND, FEMALE' 
   RLOTHM  = 'OTHER RELEASE, MALE' 
   RLOTHF  = 'OTHER RELEASE, FEMALE' 
   RLTOTM  = 'TOTAL RELEASES, MALE' 
   RLTOTF  = 'TOTAL RELEASES, FEMALE' 
   FLOJANM = 'UNDER JURISDICTION ON JANUARY 1, [CURRENT YEAR], SENTENCE GT 1 YEAR, MALE [OR DECEMBER 31 OF PRIOR 
YEAR]' 
   FLOJANF = 'UNDER JURISDICTION ON JANUARY 1, [CURRENT YEAR], SENTENCE GT 1 YEAR, FEMALE [OR DECEMBER 31 OF 
PRIOR YEAR]' 
   FLOADMM = 'ADMITTED DURING CURRENT YEAR, SENTENCE GT 1 YEAR, MALE' 
   FLOADMF = 'ADMITTED DURING CURRENT YEAR, SENTENCE GT 1 YEAR, FEMALE' 
   FLORLM  = 'RELEASED DURING CURRENT YEAR, SENTENCE GT 1 YEAR, MALE' 
   FLORLF  = 'RELEASED DURING CURRENT YEAR, SENTENCE GT 1 YEAR, FEMALE' 
   FLODECM = 'UNDER JURISDICTION ON DECEMBER 31, [CURRENT YEAR], SENTENCE GT 1 YEAR, MALE' 
   FLODECF = 'UNDER JURISDICTION ON DECEMBER 31, [CURRENT YEAR], SENTENCE GT 1 YEAR, FEMALE' 
   CAPRATEM= 'RATED CAPACITY, MALE' 
   CAPRATEF= 'RATED CAPACITY, FEMALE' 
   CAPOPM  = 'OPERATIONAL CAPACITY, MALE' 
   CAPOPF  = 'OPERATIONAL CAPACITY, FEMALE' 
   CAPDESM = 'DESIGN CAPACITY, MALE' 
   CAPDESF = 'DESIGN CAPACITY, FEMALE' 
   CAPRATET= 'RATED CAPACITY, TOTAL' 
   CAPOPT  = 'OPERATIONAL CAPACITY, TOTAL' 
   CAPDEST = 'DESIGN CAPACITY, TOTAL' 
   HIVTEST = 'TESTED INMATES IN CUSTODY FOR HIV ANTIBODY' 
   HIVINC  = 'TESTED ALL INCOMING INMATES' 
   HIVCUR  = 'TESTED ALL INMATES CURRENTLY IN CUSTODY' 
   HIVREL  = 'TESTED ALL INMATES AT TIME OF RELEASE' 
   HIVRAN  = 'TESTED RANDOM SAMPLES WHILE IN CUSTODY' 
   HIVCERT = 'TESTED CERTAIN INMATES' 
   HIVHIGH = 'TESTED HIGH RISK GROUPS IN CUSTODY' 
   HIVREQ  = 'TESTED UPON INMATE REQUEST WHILE IN CUSTODY' 
   HIVORD  = 'TESTED UPON COURT ORDER OF INMATE IN CUSTODY' 
   HIVCLIN = 'TESTED UPON CLINICAL INDICATION OF NEED OF INMATE IN CUSTODY' 
   HIVINCID= 'TESTED UPON INVOLVEMENT IN INCIDENT OF INMATE IN CUSTODY' 
   HIVOTH  = 'TESTED INMATES IN CUSTODY UNDER OTHER CIRCUMSTANCES' 
   HIVASYMM= 'ASYMPTOMATIC HIV POSITIVE, MALE' 
   HIVASYMF= 'ASYMPTOMATIC HIV POSITIVE, FEMALE' 
   HIVASYMT= 'ASYMPTOMATIC HIV POSITIVE, TOTAL' 
   HIVLESSM= 'INFECTED WITH LESSER FORMS OF SYMPTOMATIC HIV DISEASE, MALE' 
   HIVLESSF= 'INFECTED WITH LESSER FORMS OF SYMPTOMATIC HIV DISEASE,' 
   HIVLESST= 'INFECTED WITH LESSER FORMS OF SYMPTOMATIC HIV DISEASE, TOTAL' 
   AIDSCONM= 'CONFIRMED TO HAVE AIDS, MALE' 
   AIDSCONF= 'CONFIRMED TO HAVE AIDS, FEMALE' 
   AIDSCONT= 'CONFIRMED TO HAVE AIDS, TOTAL' 
   HIVATOTM= 'TOTAL IN CUSTODY HIV POSITIVE OR WITH AIDS, MALE' 
   HIVATOTF= 'TOTAL IN CUSTODY HIV POSITIVE OR WITH AIDS, FEMALE' 
   HIVATOTT= 'TOTAL IN CUSTODY HIV POSITIVE OR WITH AIDS, TOTAL' 
   CUSLT18M= 'IN CUSTODY UNDER 18 YEARS OF AGE, MALE' 
   CUSLT18F= 'IN CUSTODY UNDER 18 YEARS OF AGE, FEMALE' 
   CUSCTZNM= 'IN CUSTODY NOT U.S. CITIZENS, MALE' 
   CUSCTZNF= 'IN CUSTODY NOT U.S. CITIZENS, FEMALE' 
   DTHEXECM= 'DEATHS FROM EXECUTION, MALE' 
   DTHEXECF= 'DEATHS FROM EXECUTION, FEMALE' 
   DTHILLNM= 'DEATHS FROM ILLNESS OR NATURAL CAUSE, MALE' 
   DTHILLNF= 'DEATHS FROM ILLNESS OR NATURAL CAUSE, FEMALE' 
   DTHAIDSM= 'DEATHS FROM AIDS, MALE' 
   DTHAIDSF= 'DEATHS FROM AIDS, FEMALE' 
   DTHSUICM= 'DEATHS FROM SUICIDE, MALE' 
   DTHSUICF= 'DEATHS FROM SUICIDE, FEMALE' 
   DTHACCM = 'DEATHS FROM ACCIDENTAL INJURY TO SELF, MALE' 
   DTHACCF = 'DEATHS FROM ACCIDENTAL INJURY TO SELF, FEMALE' 
   DTHHOMIM= 'DEATHS FROM HOMICIDE BY OTHER INMATES, MALE' 
   DTHHOMIF= 'DEATHS FROM HOMICIDE  BY OTHER INMATES, FEMALE' 
   DTHHOMOM= 'DEATHS FROM OTHER HOMICIDE, MALE' 
   DTHHOMOF= 'DEATHS FROM OTHER HOMICIDE, FEMALE' 
   DTHPERSM= 'DEATHS CAUSED BY ANOTHER PERSON, MALE' 
   DTHPERSF= 'DEATHS CAUSED BY ANOTHER PERSON, FEMALE' 
   DTHOTHM = 'OTHER DEATHS, MALE' 
   DTHOTHF = 'OTHER DEATHS, FEMALE' 
   DTHTOTM = 'TOTAL DEATHS, MALE' 
   DTHTOTF = 'TOTAL DEATHS, FEMALE' 
   HANDLEM = 'TOTAL INMATES HANDLED, JURISDICTION POPULATION PLUS ADMISSIONS, MALE' 
   HANDLEF = 'TOTAL INMATES HANDLED, JURISDICTION POPULATION PLUS ADMISSIONS, FEMALE' 
        ; 


* USER-DEFINED MISSING VALUES RECODE TO SAS SYSMIS;

/*
   IF (YEAR >= -9 AND YEAR <= -1) THEN YEAR = .;
   IF (STATEID >= -9 AND STATEID <= -1) THEN STATEID = .;
   IF (REGION >= -9 AND REGION <= -1) THEN REGION = .;
   IF (CUSGT1M >= -9 AND CUSGT1M <= -1) THEN CUSGT1M = .;
   IF (CUSGT1F >= -9 AND CUSGT1F <= -1) THEN CUSGT1F = .;
   IF (CUSLT1M >= -9 AND CUSLT1M <= -1) THEN CUSLT1M = .;
   IF (CUSLT1F >= -9 AND CUSLT1F <= -1) THEN CUSLT1F = .;
   IF (CUSUNSM >= -9 AND CUSUNSM <= -1) THEN CUSUNSM = .;
   IF (CUSUNSF >= -9 AND CUSUNSF <= -1) THEN CUSUNSF = .;
   IF (CUSTOTM >= -9 AND CUSTOTM <= -1) THEN CUSTOTM = .;
   IF (CUSTOTF >= -9 AND CUSTOTF <= -1) THEN CUSTOTF = .;
   IF (CUSGT1T >= -9 AND CUSGT1T <= -1) THEN CUSGT1T = .;
   IF (CUSLT1T >= -9 AND CUSLT1T <= -1) THEN CUSLT1T = .;
   IF (CUSUNST >= -9 AND CUSUNST <= -1) THEN CUSUNST = .;
   IF (CUSTOTT >= -9 AND CUSTOTT <= -1) THEN CUSTOTT = .;
   IF (CNOPRIVM >= -9 AND CNOPRIVM <= -1) THEN CNOPRIVM = .;
   IF (CNOPRIVF >= -9 AND CNOPRIVF <= -1) THEN CNOPRIVF = .;
   IF (CWPRIVM >= -9 AND CWPRIVM <= -1) THEN CWPRIVM = .;
   IF (CWPRIVF >= -9 AND CWPRIVF <= -1) THEN CWPRIVF = .;
   IF (JURGT1M >= -9 AND JURGT1M <= -1) THEN JURGT1M = .;
   IF (JURGT1F >= -9 AND JURGT1F <= -1) THEN JURGT1F = .;
   IF (JURLT1M >= -9 AND JURLT1M <= -1) THEN JURLT1M = .;
   IF (JURLT1F >= -9 AND JURLT1F <= -1) THEN JURLT1F = .;
   IF (JURUNSM >= -9 AND JURUNSM <= -1) THEN JURUNSM = .;
   IF (JURUNSF >= -9 AND JURUNSF <= -1) THEN JURUNSF = .;
   IF (JURTOTM >= -9 AND JURTOTM <= -1) THEN JURTOTM = .;
   IF (JURTOTF >= -9 AND JURTOTF <= -1) THEN JURTOTF = .;
   IF (PVINM >= -9 AND PVINM <= -1) THEN PVINM = .;
   IF (PVINF >= -9 AND PVINF <= -1) THEN PVINF = .;
   IF (PVOTHM >= -9 AND PVOTHM <= -1) THEN PVOTHM = .;
   IF (PVOTHF >= -9 AND PVOTHF <= -1) THEN PVOTHF = .;
   IF (PVINCLM >= -9 AND PVINCLM <= -1) THEN PVINCLM = .;
   IF (PVINCLF >= -9 AND PVINCLF <= -1) THEN PVINCLF = .;
   IF (LFM >= -9 AND LFM <= -1) THEN LFM = .;
   IF (LFF >= -9 AND LFF <= -1) THEN LFF = .;
   IF (LFINCLM >= -9 AND LFINCLM <= -1) THEN LFINCLM = .;
   IF (LFINCLF >= -9 AND LFINCLF <= -1) THEN LFINCLF = .;
   IF (LFCROWDM >= -9 AND LFCROWDM <= -1) THEN LFCROWDM = .;
   IF (LFCROWDF >= -9 AND LFCROWDF <= -1) THEN LFCROWDF = .;
   IF (LFCRSTM >= -9 AND LFCRSTM <= -1) THEN LFCRSTM = .;
   IF (LFCRSTF >= -9 AND LFCRSTF <= -1) THEN LFCRSTF = .;
   IF (LFCRINCM >= -9 AND LFCRINCM <= -1) THEN LFCRINCM = .;
   IF (LFCRINCF >= -9 AND LFCRINCF <= -1) THEN LFCRINCF = .;
   IF (FEDM >= -9 AND FEDM <= -1) THEN FEDM = .;
   IF (FEDF >= -9 AND FEDF <= -1) THEN FEDF = .;
   IF (OTHSTM >= -9 AND OTHSTM <= -1) THEN OTHSTM = .;
   IF (OTHSTF >= -9 AND OTHSTF <= -1) THEN OTHSTF = .;
   IF (FACINCLM >= -9 AND FACINCLM <= -1) THEN FACINCLM = .;
   IF (FACINCLF >= -9 AND FACINCLF <= -1) THEN FACINCLF = .;
   IF (FACROWDM >= -9 AND FACROWDM <= -1) THEN FACROWDM = .;
   IF (FACROWDF >= -9 AND FACROWDF <= -1) THEN FACROWDF = .;
   IF (WHITEM >= -9 AND WHITEM <= -1) THEN WHITEM = .;
   IF (WHITEF >= -9 AND WHITEF <= -1) THEN WHITEF = .;
   IF (BLACKM >= -9 AND BLACKM <= -1) THEN BLACKM = .;
   IF (BLACKF >= -9 AND BLACKF <= -1) THEN BLACKF = .;
   IF (HISPM >= -9 AND HISPM <= -1) THEN HISPM = .;
   IF (HISPF >= -9 AND HISPF <= -1) THEN HISPF = .;
   IF (AIANM >= -9 AND AIANM <= -1) THEN AIANM = .;
   IF (AIANF >= -9 AND AIANF <= -1) THEN AIANF = .;
   IF (ASIANM >= -9 AND ASIANM <= -1) THEN ASIANM = .;
   IF (ASIANF >= -9 AND ASIANF <= -1) THEN ASIANF = .;
   IF (NHPIM >= -9 AND NHPIM <= -1) THEN NHPIM = .;
   IF (NHPIF >= -9 AND NHPIF <= -1) THEN NHPIF = .;
   IF (APIM >= -9 AND APIM <= -1) THEN APIM = .;
   IF (APIF >= -9 AND APIF <= -1) THEN APIF = .;
   IF (TWORACEM >= -9 AND TWORACEM <= -1) THEN TWORACEM = .;
   IF (TWORACEF >= -9 AND TWORACEF <= -1) THEN TWORACEF = .;
   IF (ADDRACEM >= -9 AND ADDRACEM <= -1) THEN ADDRACEM = .;
   IF (ADDRACEF >= -9 AND ADDRACEF <= -1) THEN ADDRACEF = .;
   IF (UNKRACEM >= -9 AND UNKRACEM <= -1) THEN UNKRACEM = .;
   IF (UNKRACEF >= -9 AND UNKRACEF <= -1) THEN UNKRACEF = .;
   IF (TOTRACEM >= -9 AND TOTRACEM <= -1) THEN TOTRACEM = .;
   IF (TOTRACEF >= -9 AND TOTRACEF <= -1) THEN TOTRACEF = .;
   IF (NOTHISPM >= -9 AND NOTHISPM <= -1) THEN NOTHISPM = .;
   IF (NOTHISPF >= -9 AND NOTHISPF <= -1) THEN NOTHISPF = .;
   IF (UNKHISPM >= -9 AND UNKHISPM <= -1) THEN UNKHISPM = .;
   IF (UNKHISPF >= -9 AND UNKHISPF <= -1) THEN UNKHISPF = .;
   IF (TOTHCATM >= -9 AND TOTHCATM <= -1) THEN TOTHCATM = .;
   IF (TOTHCATF >= -9 AND TOTHCATF <= -1) THEN TOTHCATF = .;
   IF (COMMITM >= -9 AND COMMITM <= -1) THEN COMMITM = .;
   IF (COMMITF >= -9 AND COMMITF <= -1) THEN COMMITF = .;
   IF (PARNEWM >= -9 AND PARNEWM <= -1) THEN PARNEWM = .;
   IF (PARNEWF >= -9 AND PARNEWF <= -1) THEN PARNEWF = .;
   IF (PARNOM >= -9 AND PARNOM <= -1) THEN PARNOM = .;
   IF (PARNOF >= -9 AND PARNOF <= -1) THEN PARNOF = .;
   IF (ADCRNEWM >= -9 AND ADCRNEWM <= -1) THEN ADCRNEWM = .;
   IF (ADCRNEWF >= -9 AND ADCRNEWF <= -1) THEN ADCRNEWF = .;
   IF (ADCRNOM >= -9 AND ADCRNOM <= -1) THEN ADCRNOM = .;
   IF (ADCRNOF >= -9 AND ADCRNOF <= -1) THEN ADCRNOF = .;
   IF (ADTRANSM >= -9 AND ADTRANSM <= -1) THEN ADTRANSM = .;
   IF (ADTRANSF >= -9 AND ADTRANSF <= -1) THEN ADTRANSF = .;
   IF (ADAWOLM >= -9 AND ADAWOLM <= -1) THEN ADAWOLM = .;
   IF (ADAWOLF >= -9 AND ADAWOLF <= -1) THEN ADAWOLF = .;
   IF (ADESCAPM >= -9 AND ADESCAPM <= -1) THEN ADESCAPM = .;
   IF (ADESCAPF >= -9 AND ADESCAPF <= -1) THEN ADESCAPF = .;
   IF (ADAWESM >= -9 AND ADAWESM <= -1) THEN ADAWESM = .;
   IF (ADAWESF >= -9 AND ADAWESF <= -1) THEN ADAWESF = .;
   IF (ADRETM >= -9 AND ADRETM <= -1) THEN ADRETM = .;
   IF (ADRETF >= -9 AND ADRETF <= -1) THEN ADRETF = .;
   IF (ADOTHM >= -9 AND ADOTHM <= -1) THEN ADOTHM = .;
   IF (ADOTHF >= -9 AND ADOTHF <= -1) THEN ADOTHF = .;
   IF (ADTOTM >= -9 AND ADTOTM <= -1) THEN ADTOTM = .;
   IF (ADTOTF >= -9 AND ADTOTF <= -1) THEN ADTOTF = .;
   IF (RLUNEXPM >= -9 AND RLUNEXPM <= -1) THEN RLUNEXPM = .;
   IF (RLUNEXPF >= -9 AND RLUNEXPF <= -1) THEN RLUNEXPF = .;
   IF (RLUNCOMM >= -9 AND RLUNCOMM <= -1) THEN RLUNCOMM = .;
   IF (RLUNCOMF >= -9 AND RLUNCOMF <= -1) THEN RLUNCOMF = .;
   IF (RLUNOTHM >= -9 AND RLUNOTHM <= -1) THEN RLUNOTHM = .;
   IF (RLUNOTHF >= -9 AND RLUNOTHF <= -1) THEN RLUNOTHF = .;
   IF (RLCOPROM >= -9 AND RLCOPROM <= -1) THEN RLCOPROM = .;
   IF (RLCOPROF >= -9 AND RLCOPROF <= -1) THEN RLCOPROF = .;
   IF (RLCOSUPM >= -9 AND RLCOSUPM <= -1) THEN RLCOSUPM = .;
   IF (RLCOSUPF >= -9 AND RLCOSUPF <= -1) THEN RLCOSUPF = .;
   IF (RLCODPM >= -9 AND RLCODPM <= -1) THEN RLCODPM = .;
   IF (RLCODPF >= -9 AND RLCODPF <= -1) THEN RLCODPF = .;
   IF (RLCOOTHM >= -9 AND RLCOOTHM <= -1) THEN RLCOOTHM = .;
   IF (RLCOOTHF >= -9 AND RLCOOTHF <= -1) THEN RLCOOTHF = .;
   IF (RLDEATHM >= -9 AND RLDEATHM <= -1) THEN RLDEATHM = .;
   IF (RLDEATHF >= -9 AND RLDEATHF <= -1) THEN RLDEATHF = .;
   IF (RLAWOLM >= -9 AND RLAWOLM <= -1) THEN RLAWOLM = .;
   IF (RLAWOLF >= -9 AND RLAWOLF <= -1) THEN RLAWOLF = .;
   IF (RLESCAPM >= -9 AND RLESCAPM <= -1) THEN RLESCAPM = .;
   IF (RLESCAPF >= -9 AND RLESCAPF <= -1) THEN RLESCAPF = .;
   IF (RLAWESM >= -9 AND RLAWESM <= -1) THEN RLAWESM = .;
   IF (RLAWESF >= -9 AND RLAWESF <= -1) THEN RLAWESF = .;
   IF (RLTRANM >= -9 AND RLTRANM <= -1) THEN RLTRANM = .;
   IF (RLTRANF >= -9 AND RLTRANF <= -1) THEN RLTRANF = .;
   IF (RLBONDM >= -9 AND RLBONDM <= -1) THEN RLBONDM = .;
   IF (RLBONDF >= -9 AND RLBONDF <= -1) THEN RLBONDF = .;
   IF (RLOTHM >= -9 AND RLOTHM <= -1) THEN RLOTHM = .;
   IF (RLOTHF >= -9 AND RLOTHF <= -1) THEN RLOTHF = .;
   IF (RLTOTM >= -9 AND RLTOTM <= -1) THEN RLTOTM = .;
   IF (RLTOTF >= -9 AND RLTOTF <= -1) THEN RLTOTF = .;
   IF (FLOJANM >= -9 AND FLOJANM <= -1) THEN FLOJANM = .;
   IF (FLOJANF >= -9 AND FLOJANF <= -1) THEN FLOJANF = .;
   IF (FLOADMM >= -9 AND FLOADMM <= -1) THEN FLOADMM = .;
   IF (FLOADMF >= -9 AND FLOADMF <= -1) THEN FLOADMF = .;
   IF (FLORLM >= -9 AND FLORLM <= -1) THEN FLORLM = .;
   IF (FLORLF >= -9 AND FLORLF <= -1) THEN FLORLF = .;
   IF (FLODECM >= -9 AND FLODECM <= -1) THEN FLODECM = .;
   IF (FLODECF >= -9 AND FLODECF <= -1) THEN FLODECF = .;
   IF (CAPRATEM >= -9 AND CAPRATEM <= -1) THEN CAPRATEM = .;
   IF (CAPRATEF >= -9 AND CAPRATEF <= -1) THEN CAPRATEF = .;
   IF (CAPOPM >= -9 AND CAPOPM <= -1) THEN CAPOPM = .;
   IF (CAPOPF >= -9 AND CAPOPF <= -1) THEN CAPOPF = .;
   IF (CAPDESM >= -9 AND CAPDESM <= -1) THEN CAPDESM = .;
   IF (CAPDESF >= -9 AND CAPDESF <= -1) THEN CAPDESF = .;
   IF (CAPRATET >= -9 AND CAPRATET <= -1) THEN CAPRATET = .;
   IF (CAPOPT >= -9 AND CAPOPT <= -1) THEN CAPOPT = .;
   IF (CAPDEST >= -9 AND CAPDEST <= -1) THEN CAPDEST = .;
   IF (HIVTEST >= -9 AND HIVTEST <= -1) THEN HIVTEST = .;
   IF (HIVINC >= -9 AND HIVINC <= -1) THEN HIVINC = .;
   IF (HIVCUR >= -9 AND HIVCUR <= -1) THEN HIVCUR = .;
   IF (HIVREL >= -9 AND HIVREL <= -1) THEN HIVREL = .;
   IF (HIVRAN >= -9 AND HIVRAN <= -1) THEN HIVRAN = .;
   IF (HIVCERT >= -9 AND HIVCERT <= -1) THEN HIVCERT = .;
   IF (HIVHIGH >= -9 AND HIVHIGH <= -1) THEN HIVHIGH = .;
   IF (HIVREQ >= -9 AND HIVREQ <= -1) THEN HIVREQ = .;
   IF (HIVORD >= -9 AND HIVORD <= -1) THEN HIVORD = .;
   IF (HIVCLIN >= -9 AND HIVCLIN <= -1) THEN HIVCLIN = .;
   IF (HIVINCID >= -9 AND HIVINCID <= -1) THEN HIVINCID = .;
   IF (HIVOTH >= -9 AND HIVOTH <= -1) THEN HIVOTH = .;
   IF (HIVASYMM >= -9 AND HIVASYMM <= -1) THEN HIVASYMM = .;
   IF (HIVASYMF >= -9 AND HIVASYMF <= -1) THEN HIVASYMF = .;
   IF (HIVASYMT >= -9 AND HIVASYMT <= -1) THEN HIVASYMT = .;
   IF (HIVLESSM >= -9 AND HIVLESSM <= -1) THEN HIVLESSM = .;
   IF (HIVLESSF >= -9 AND HIVLESSF <= -1) THEN HIVLESSF = .;
   IF (HIVLESST >= -9 AND HIVLESST <= -1) THEN HIVLESST = .;
   IF (AIDSCONM >= -9 AND AIDSCONM <= -1) THEN AIDSCONM = .;
   IF (AIDSCONF >= -9 AND AIDSCONF <= -1) THEN AIDSCONF = .;
   IF (AIDSCONT >= -9 AND AIDSCONT <= -1) THEN AIDSCONT = .;
   IF (HIVATOTM >= -9 AND HIVATOTM <= -1) THEN HIVATOTM = .;
   IF (HIVATOTF >= -9 AND HIVATOTF <= -1) THEN HIVATOTF = .;
   IF (HIVATOTT >= -9 AND HIVATOTT <= -1) THEN HIVATOTT = .;
   IF (CUSLT18M >= -9 AND CUSLT18M <= -1) THEN CUSLT18M = .;
   IF (CUSLT18F >= -9 AND CUSLT18F <= -1) THEN CUSLT18F = .;
   IF (CUSCTZNM >= -9 AND CUSCTZNM <= -1) THEN CUSCTZNM = .;
   IF (CUSCTZNF >= -9 AND CUSCTZNF <= -1) THEN CUSCTZNF = .;
   IF (DTHEXECM >= -9 AND DTHEXECM <= -1) THEN DTHEXECM = .;
   IF (DTHEXECF >= -9 AND DTHEXECF <= -1) THEN DTHEXECF = .;
   IF (DTHILLNM >= -9 AND DTHILLNM <= -1) THEN DTHILLNM = .;
   IF (DTHILLNF >= -9 AND DTHILLNF <= -1) THEN DTHILLNF = .;
   IF (DTHAIDSM >= -9 AND DTHAIDSM <= -1) THEN DTHAIDSM = .;
   IF (DTHAIDSF >= -9 AND DTHAIDSF <= -1) THEN DTHAIDSF = .;
   IF (DTHSUICM >= -9 AND DTHSUICM <= -1) THEN DTHSUICM = .;
   IF (DTHSUICF >= -9 AND DTHSUICF <= -1) THEN DTHSUICF = .;
   IF (DTHACCM >= -9 AND DTHACCM <= -1) THEN DTHACCM = .;
   IF (DTHACCF >= -9 AND DTHACCF <= -1) THEN DTHACCF = .;
   IF (DTHHOMIM >= -9 AND DTHHOMIM <= -1) THEN DTHHOMIM = .;
   IF (DTHHOMIF >= -9 AND DTHHOMIF <= -1) THEN DTHHOMIF = .;
   IF (DTHHOMOM >= -9 AND DTHHOMOM <= -1) THEN DTHHOMOM = .;
   IF (DTHHOMOF >= -9 AND DTHHOMOF <= -1) THEN DTHHOMOF = .;
   IF (DTHPERSM >= -9 AND DTHPERSM <= -1) THEN DTHPERSM = .;
   IF (DTHPERSF >= -9 AND DTHPERSF <= -1) THEN DTHPERSF = .;
   IF (DTHOTHM >= -9 AND DTHOTHM <= -1) THEN DTHOTHM = .;
   IF (DTHOTHF >= -9 AND DTHOTHF <= -1) THEN DTHOTHF = .;
   IF (DTHTOTM >= -9 AND DTHTOTM <= -1) THEN DTHTOTM = .;
   IF (DTHTOTF >= -9 AND DTHTOTF <= -1) THEN DTHTOTF = .;
   IF (HANDLEM >= -9 AND HANDLEM <= -1) THEN HANDLEM = .;
   IF (HANDLEF >= -9 AND HANDLEF <= -1) THEN HANDLEF = .;
*/


* SAS FORMAT STATEMENT;

/*
   FORMAT
         ADAWESF cusgt1mf. ADAWESM cusgt1mf. ADAWOLF cusgt1mf.
         ADAWOLM cusgt1mf. ADCRNEWF cusgt1mf. ADCRNEWM cusgt1mf.
         ADCRNOF cusgt1mf. ADCRNOM cusgt1mf. ADDRACEF cusgt1mf.
         ADDRACEM cusgt1mf. ADESCAPF cusgt1mf. ADESCAPM cusgt1mf.
         ADOTHF cusgt1mf. ADOTHM cusgt1mf. ADRETF cusgt1mf.
         ADRETM cusgt1mf. ADTOTF cusgt1mf. ADTOTM cusgt1mf.
         ADTRANSF cusgt1mf. ADTRANSM cusgt1mf. AIANF cusgt1mf.
         AIANM cusgt1mf. AIDSCONF commitff. AIDSCONM commitff.
         AIDSCONT commitff. APIF cusgt1mf. APIM cusgt1mf.
         ASIANF cusgt1mf. ASIANM cusgt1mf. BLACKF cusgt1mf.
         BLACKM cusgt1mf. CAPDESF commitff. CAPDESM cusgt1mf.
         CAPDEST cusgt1mf. CAPOPF commitff. CAPOPM cusgt1mf.
         CAPOPT cusgt1mf. CAPRATEF commitff. CAPRATEM cusgt1mf.
         CAPRATET cusgt1mf. CNOPRIVF cusgt1mf. CNOPRIVM cusgt1mf.
         COMMITF commitff. COMMITM cusgt1mf. CUSCTZNF cusgt1mf.
         CUSCTZNM cusgt1mf. CUSGT1F cusgt1mf. CUSGT1M cusgt1mf.
         CUSGT1T cusgt1mf. CUSLT18F cusgt1mf. CUSLT18M cusgt1mf.
         CUSLT1F cusgt1mf. CUSLT1M cusgt1mf. CUSLT1T cusgt1mf.
         CUSTOTF cusgt1mf. CUSTOTM cusgt1mf. CUSTOTT cusgt1mf.
         CUSUNSF cusgt1mf. CUSUNSM cusgt1mf. CUSUNST cusgt1mf.
         CWPRIVF cusgt1mf. CWPRIVM cusgt1mf. DTHACCF cusgt1mf.
         DTHACCM cusgt1mf. DTHAIDSF cusgt1mf. DTHAIDSM cusgt1mf.
         DTHEXECF cusgt1mf. DTHEXECM cusgt1mf. DTHHOMIF cusgt1mf.
         DTHHOMIM cusgt1mf. DTHHOMOF cusgt1mf. DTHHOMOM cusgt1mf.
         DTHILLNF cusgt1mf. DTHILLNM cusgt1mf. DTHOTHF cusgt1mf.
         DTHOTHM cusgt1mf. DTHPERSF cusgt1mf. DTHPERSM cusgt1mf.
         DTHSUICF cusgt1mf. DTHSUICM cusgt1mf. DTHTOTF cusgt1mf.
         DTHTOTM cusgt1mf. FACINCLF pvinclmf. FACINCLM pvinclmf.
         FACROWDF cusgt1mf. FACROWDM cusgt1mf. FEDF cusgt1mf.
         FEDM cusgt1mf. FLOADMF cusgt1mf. FLOADMM cusgt1mf.
         FLODECF cusgt1mf. FLODECM cusgt1mf. FLOJANF cusgt1mf.
         FLOJANM cusgt1mf. FLORLF cusgt1mf. FLORLM cusgt1mf.
         HANDLEF cusgt1mf. HANDLEM cusgt1mf. HISPF cusgt1mf.
         HISPM cusgt1mf. HIVASYMF commitff. HIVASYMM commitff.
         HIVASYMT commitff. HIVATOTF commitff. HIVATOTM commitff.
         HIVATOTT commitff. HIVCERT commitff. HIVCLIN commitff.
         HIVCUR commitff. HIVHIGH commitff. HIVINC commitff.
         HIVINCID commitff. HIVLESSF commitff. HIVLESSM commitff.
         HIVLESST commitff. HIVORD commitff. HIVOTH commitff.
         HIVRAN commitff. HIVREL commitff. HIVREQ commitff.
         HIVTEST commitff. JURGT1F cusgt1mf. JURGT1M cusgt1mf.
         JURLT1F cusgt1mf. JURLT1M cusgt1mf. JURTOTF cusgt1mf.
         JURTOTM cusgt1mf. JURUNSF cusgt1mf. JURUNSM cusgt1mf.
         LFCRINCF cusgt1mf. LFCRINCM cusgt1mf. LFCROWDF cusgt1mf.
         LFCROWDM cusgt1mf. LFCRSTF cusgt1mf. LFCRSTM cusgt1mf.
         LFF cusgt1mf. LFINCLF pvinclmf. LFINCLM pvinclmf.
         LFM cusgt1mf. NHPIF cusgt1mf. NHPIM cusgt1mf.
         NOTHISPF cusgt1mf. NOTHISPM cusgt1mf. OTHSTF cusgt1mf.
         OTHSTM cusgt1mf. PARNEWF cusgt1mf. PARNEWM cusgt1mf.
         PARNOF cusgt1mf. PARNOM cusgt1mf. PVINCLF pvinclmf.
         PVINCLM pvinclmf. PVINF cusgt1mf. PVINM cusgt1mf.
         PVOTHF cusgt1mf. PVOTHM cusgt1mf. REGION regionff.
         RLAWESF cusgt1mf. RLAWESM cusgt1mf. RLAWOLF cusgt1mf.
         RLAWOLM cusgt1mf. RLBONDF cusgt1mf. RLBONDM cusgt1mf.
         RLCODPF cusgt1mf. RLCODPM cusgt1mf. RLCOOTHF cusgt1mf.
         RLCOOTHM cusgt1mf. RLCOPROF cusgt1mf. RLCOPROM cusgt1mf.
         RLCOSUPF cusgt1mf. RLCOSUPM cusgt1mf. RLDEATHF cusgt1mf.
         RLDEATHM cusgt1mf. RLESCAPF cusgt1mf. RLESCAPM cusgt1mf.
         RLOTHF cusgt1mf. RLOTHM cusgt1mf. RLTOTF cusgt1mf.
         RLTOTM cusgt1mf. RLTRANF cusgt1mf. RLTRANM cusgt1mf.
         RLUNCOMF cusgt1mf. RLUNCOMM cusgt1mf. RLUNEXPF cusgt1mf.
         RLUNEXPM cusgt1mf. RLUNOTHF cusgt1mf. RLUNOTHM cusgt1mf.
         STATEID stateidf. TOTHCATF cusgt1mf. TOTHCATM cusgt1mf.
         TOTRACEF cusgt1mf. TOTRACEM cusgt1mf. TWORACEF cusgt1mf.
         TWORACEM cusgt1mf. UNKHISPF cusgt1mf. UNKHISPM cusgt1mf.
         UNKRACEF cusgt1mf. UNKRACEM cusgt1mf. WHITEF cusgt1mf.
         WHITEM cusgt1mf.
    ;
*/

RUN ;
