/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.streams;

import java.io.Serializable;
import java.util.Vector;
import weka.core.Instance;
import weka.core.Instances;
import weka.gui.streams.InstanceEvent;
import weka.gui.streams.InstanceListener;
import weka.gui.streams.InstanceProducer;
import weka.gui.streams.SerialInstanceListener;

public class InstanceJoiner
implements Serializable,
InstanceProducer,
SerialInstanceListener {
    private Vector listeners = new Vector();
    private boolean b_Debug = false;
    protected Instances m_InputFormat = null;
    private Instance m_OutputInstance = null;
    private boolean b_FirstInputFinished = false;
    private boolean b_SecondInputFinished = false;

    public boolean inputFormat(Instances instances) {
        this.m_InputFormat = new Instances(instances, 0);
        this.notifyInstanceProduced(new InstanceEvent(this, 1));
        this.b_FirstInputFinished = false;
        this.b_SecondInputFinished = false;
        return true;
    }

    public Instances outputFormat() throws Exception {
        if (this.m_InputFormat == null) {
            throw new Exception("No output format defined.");
        }
        return new Instances(this.m_InputFormat, 0);
    }

    public boolean input(Instance instance) throws Exception {
        if (this.m_InputFormat == null) {
            throw new Exception("No input instance format defined");
        }
        if (instance != null) {
            this.m_OutputInstance = (Instance)instance.copy();
            this.notifyInstanceProduced(new InstanceEvent(this, 2));
            return true;
        }
        return false;
    }

    public void batchFinished() throws Exception {
        if (this.m_InputFormat == null) {
            throw new Exception("No input instance format defined");
        }
        this.notifyInstanceProduced(new InstanceEvent(this, 3));
    }

    public Instance outputPeek() throws Exception {
        if (this.m_InputFormat == null) {
            throw new Exception("No output instance format defined");
        }
        if (this.m_OutputInstance == null) {
            return null;
        }
        return (Instance)this.m_OutputInstance.copy();
    }

    public void setDebug(boolean bl) {
        this.b_Debug = bl;
    }

    public boolean getDebug() {
        return this.b_Debug;
    }

    public synchronized void addInstanceListener(InstanceListener instanceListener) {
        this.listeners.addElement(instanceListener);
    }

    public synchronized void removeInstanceListener(InstanceListener instanceListener) {
        this.listeners.removeElement(instanceListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyInstanceProduced(InstanceEvent instanceEvent) {
        if (this.listeners.size() > 0) {
            Vector vector;
            if (this.b_Debug) {
                System.err.println(this.getClass().getName() + "::notifyInstanceProduced()");
            }
            InstanceJoiner instanceJoiner = this;
            synchronized (instanceJoiner) {
                vector = (Vector)this.listeners.clone();
            }
            for (int i = 0; i < vector.size(); ++i) {
                ((InstanceListener)vector.elementAt(i)).instanceProduced(instanceEvent);
            }
            try {
                if (instanceEvent.getID() == 2) {
                    this.m_OutputInstance = null;
                }
            }
            catch (Exception exception) {
                System.err.println("Problem: notifyInstanceProduced() was\ncalled with INSTANCE_AVAILABLE, but output()\nthrew an exception: " + exception.getMessage());
            }
        }
    }

    public void instanceProduced(InstanceEvent instanceEvent) {
        Object object = instanceEvent.getSource();
        if (object instanceof InstanceProducer) {
            try {
                InstanceProducer instanceProducer = (InstanceProducer)object;
                switch (instanceEvent.getID()) {
                    case 1: {
                        if (this.b_Debug) {
                            System.err.println(this.getClass().getName() + "::firstInstanceProduced() - Format available");
                        }
                        this.inputFormat(instanceProducer.outputFormat());
                        break;
                    }
                    case 2: {
                        if (this.b_Debug) {
                            System.err.println(this.getClass().getName() + "::firstInstanceProduced() - Instance available");
                        }
                        this.input(instanceProducer.outputPeek());
                        break;
                    }
                    case 3: {
                        if (this.b_Debug) {
                            System.err.println(this.getClass().getName() + "::firstInstanceProduced() - End of instance batch");
                        }
                        this.batchFinished();
                        this.b_FirstInputFinished = true;
                        break;
                    }
                    default: {
                        System.err.println(this.getClass().getName() + "::firstInstanceProduced() - unknown event type");
                        break;
                    }
                }
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        } else {
            System.err.println(this.getClass().getName() + "::firstInstanceProduced() - Unknown source object type");
        }
    }

    public void secondInstanceProduced(InstanceEvent instanceEvent) {
        Object object = instanceEvent.getSource();
        if (object instanceof InstanceProducer) {
            try {
                if (!this.b_FirstInputFinished) {
                    throw new Exception(this.getClass().getName() + "::secondInstanceProduced() - Input received from" + " second stream before first stream finished");
                }
                InstanceProducer instanceProducer = (InstanceProducer)object;
                switch (instanceEvent.getID()) {
                    case 1: {
                        if (this.b_Debug) {
                            System.err.println(this.getClass().getName() + "::secondInstanceProduced() - Format available");
                        }
                        if (!instanceProducer.outputFormat().equalHeaders(this.outputFormat())) {
                            throw new Exception(this.getClass().getName() + "::secondInstanceProduced() - incompatible instance streams");
                        }
                        break;
                    }
                    case 2: {
                        if (this.b_Debug) {
                            System.err.println(this.getClass().getName() + "::secondInstanceProduced() - Instance available");
                        }
                        this.input(instanceProducer.outputPeek());
                        break;
                    }
                    case 3: {
                        if (this.b_Debug) {
                            System.err.println(this.getClass().getName() + "::secondInstanceProduced() - End of instance batch");
                        }
                        this.batchFinished();
                        break;
                    }
                    default: {
                        System.err.println(this.getClass().getName() + "::secondInstanceProduced() - unknown event type");
                        break;
                    }
                }
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        } else {
            System.err.println(this.getClass().getName() + "::secondInstanceProduced() - Unknown source object type");
        }
    }
}

