/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.util;

import it.bancaditalia.oss.sdmx.api.BaseObservation;
import it.bancaditalia.oss.sdmx.api.DoubleObservation;
import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import java.util.Iterator;

public class Utils {
    public static <T> Function<BaseObservation<? extends T>, String> timeslotExtractor() {
        return new Function<BaseObservation<? extends T>, String>(){

            @Override
            public String apply(BaseObservation<? extends T> baseObservation) {
                return baseObservation.getTimeslot();
            }
        };
    }

    public static <T> Function<BaseObservation<? extends T>, T> obsExtractor() {
        return new Function<BaseObservation<? extends T>, T>(){

            @Override
            public T apply(BaseObservation<? extends T> baseObservation) {
                return baseObservation.getValue();
            }
        };
    }

    public static <T> Function<BaseObservation<? extends T>, String> obsLevelAttrsExtractor(final String string) {
        return new Function<BaseObservation<? extends T>, String>(){

            @Override
            public String apply(BaseObservation<? extends T> baseObservation) {
                return baseObservation.getAttributeValue(string);
            }
        };
    }

    private Utils() {
    }

    public static <T> Function<T, T> identity() {
        return new Function<T, T>(){

            @Override
            public T apply(T t) {
                return t;
            }
        };
    }

    public static double[] toDoubleArray(PortableTimeSeries<?> portableTimeSeries) {
        double[] dArray = new double[portableTimeSeries.size()];
        for (int i = 0; i < portableTimeSeries.size(); ++i) {
            dArray[i] = ((BaseObservation)portableTimeSeries.get(i)).getValueAsDouble();
        }
        return dArray;
    }

    public static PortableTimeSeries<Double> mapToDoubleValues(PortableTimeSeries<?> portableTimeSeries) {
        PortableTimeSeries<Double> portableTimeSeries2 = new PortableTimeSeries<Double>(portableTimeSeries);
        for (BaseObservation<?> baseObservation : portableTimeSeries) {
            portableTimeSeries2.add(new DoubleObservation(baseObservation, baseObservation.getValueAsDouble()));
        }
        return portableTimeSeries2;
    }

    public static PortableTimeSeries<Double> combineValuesAsDouble(PortableTimeSeries<Double> portableTimeSeries, PortableTimeSeries<Double> portableTimeSeries2, DoubleBinaryOperator doubleBinaryOperator) {
        if (portableTimeSeries.size() != portableTimeSeries2.size()) {
            throw new UnsupportedOperationException("The two series do not have the same size.");
        }
        PortableTimeSeries<Double> portableTimeSeries3 = new PortableTimeSeries<Double>(portableTimeSeries);
        Iterator<BaseObservation<Double>> iterator = portableTimeSeries2.iterator();
        for (BaseObservation<Double> baseObservation : portableTimeSeries) {
            portableTimeSeries3.add(new DoubleObservation(baseObservation, doubleBinaryOperator.applyAsDouble(baseObservation.getValueAsDouble(), iterator.next().getValueAsDouble())));
        }
        return portableTimeSeries3;
    }

    public static PortableTimeSeries<Double> mapValuesAsDouble(PortableTimeSeries<Double> portableTimeSeries, DoubleUnaryOperator doubleUnaryOperator) {
        PortableTimeSeries<Double> portableTimeSeries2 = new PortableTimeSeries<Double>(portableTimeSeries);
        for (BaseObservation<Double> baseObservation : portableTimeSeries) {
            portableTimeSeries2.add(new DoubleObservation(baseObservation, doubleUnaryOperator.applyAsDouble(baseObservation.getValueAsDouble())));
        }
        return portableTimeSeries2;
    }

    public static interface DoubleBinaryOperator {
        public double applyAsDouble(double var1, double var3);
    }

    public static interface DoubleUnaryOperator {
        public double applyAsDouble(double var1);
    }

    public static interface BinaryOperator<T>
    extends BiFunction<T, T, T> {
    }

    public static interface BiFunction<T, U, R> {
        public R apply(T var1, U var2);
    }

    public static interface Function<T, R> {
        public R apply(T var1);
    }
}

