/*
 * Decompiled with CFR 0.152.
 */
package jd2.workspace.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import jd2.workspace.io.IO;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class Xml {
    private Xml() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class WrappedException
    extends IOException {
        public WrappedException(Exception ex) {
            super(ex);
        }
    }

    public static interface Parser<T> {
        default public @NonNull T parseChars(@NonNull CharSequence source) throws IOException {
            return this.parseReader(() -> new StringReader(source.toString()));
        }

        default public @NonNull T parseFile(@NonNull File source) throws IOException {
            return this.parseStream(() -> new FileInputStream(source));
        }

        default public @NonNull T parsePath(@NonNull Path source) throws IOException {
            Optional<File> file = IO.getFile(source);
            return file.isPresent() ? this.parseFile(file.get()) : this.parseReader(() -> Files.newBufferedReader(source));
        }

        default public @NonNull T parseReader(IO.Supplier<? extends Reader> source) throws IOException {
            try (Reader resource = source.getWithIO();){
                T t = this.parseReader(resource);
                return t;
            }
        }

        default public @NonNull T parseStream(IO.Supplier<? extends InputStream> source) throws IOException {
            try (InputStream resource = source.getWithIO();){
                T t = this.parseStream(resource);
                return t;
            }
        }

        public @NonNull T parseReader(@NonNull Reader var1) throws IOException;

        public @NonNull T parseStream(@NonNull InputStream var1) throws IOException;
    }
}

