/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.x13;

import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.InformationSetSerializable;
import ec.tstoolkit.modelling.DefaultTransformationType;
import ec.tstoolkit.timeseries.calendars.LengthOfPeriodType;
import ec.tstoolkit.utilities.Jdk6;
import java.util.Map;
import java.util.Objects;

public class TransformSpec
implements Cloneable,
InformationSetSerializable {
    private DefaultTransformationType fn_ = DefaultTransformationType.None;
    private LengthOfPeriodType adjust_ = LengthOfPeriodType.None;
    private double aicdiff_ = -2.0;
    private double const_;
    public static final double DEF_AICDIFF = -2.0;
    public static final String FN = "function";
    public static final String ADJUST = "adjust";
    public static final String AICDIFF = "aicdiff";
    public static final String CONST = "const";
    private static final String[] DICTIONARY = new String[]{"function", "adjust", "aicdiff", "const"};

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        dic.put(InformationSet.item(prefix, ADJUST), String.class);
        dic.put(InformationSet.item(prefix, AICDIFF), Double.class);
        dic.put(InformationSet.item(prefix, FN), String.class);
        dic.put(InformationSet.item(prefix, CONST), Double.class);
    }

    public void reset() {
        this.fn_ = DefaultTransformationType.None;
        this.adjust_ = LengthOfPeriodType.None;
        this.aicdiff_ = -2.0;
        this.const_ = 0.0;
    }

    public DefaultTransformationType getFunction() {
        return this.fn_;
    }

    public void setFunction(DefaultTransformationType value) {
        this.fn_ = value;
    }

    public LengthOfPeriodType getAdjust() {
        return this.adjust_;
    }

    public void setAdjust(LengthOfPeriodType value) {
        this.adjust_ = value;
    }

    public double getAICDiff() {
        return this.aicdiff_;
    }

    public void setAICDiff(double value) {
        this.aicdiff_ = value;
    }

    public double getConst() {
        return this.const_;
    }

    public void setConst(double value) {
        this.const_ = value;
    }

    public boolean isDefault() {
        if (this.adjust_ != LengthOfPeriodType.None) {
            return false;
        }
        if (this.aicdiff_ != -2.0) {
            return false;
        }
        if (this.const_ != 0.0) {
            return false;
        }
        return this.fn_ == DefaultTransformationType.None;
    }

    public TransformSpec clone() {
        try {
            TransformSpec spec = (TransformSpec)super.clone();
            return spec;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public int hashCode() {
        int hash = 5;
        hash = 79 * hash + Objects.hashCode((Object)this.fn_);
        hash = 79 * hash + Objects.hashCode((Object)this.adjust_);
        hash = 79 * hash + Jdk6.Double.hashCode(this.aicdiff_);
        hash = 79 * hash + Jdk6.Double.hashCode(this.const_);
        return hash;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof TransformSpec && this.equals((TransformSpec)obj);
    }

    private boolean equals(TransformSpec other) {
        return this.adjust_ == other.adjust_ && this.aicdiff_ == other.aicdiff_ && this.const_ == other.const_ && this.fn_ == other.fn_;
    }

    @Override
    public InformationSet write(boolean verbose) {
        if (!verbose && this.isDefault()) {
            return null;
        }
        InformationSet info = new InformationSet();
        if (verbose || this.fn_ != DefaultTransformationType.None) {
            info.add(FN, this.fn_.name());
        }
        if (verbose || this.adjust_ != LengthOfPeriodType.None) {
            info.add(ADJUST, this.adjust_.name());
        }
        if (verbose || this.aicdiff_ != -2.0) {
            info.add(AICDIFF, Double.valueOf(this.aicdiff_));
        }
        if (verbose || this.const_ != 0.0) {
            info.add(CONST, Double.valueOf(this.const_));
        }
        return info;
    }

    @Override
    public boolean read(InformationSet info) {
        try {
            Double cnt;
            Double aic;
            String adjust;
            this.reset();
            String fn = info.get(FN, String.class);
            if (fn != null) {
                this.fn_ = DefaultTransformationType.valueOf(fn);
            }
            if ((adjust = info.get(ADJUST, String.class)) != null) {
                this.adjust_ = LengthOfPeriodType.valueOf(adjust);
            }
            if ((aic = info.get(AICDIFF, Double.class)) != null) {
                this.aicdiff_ = aic;
            }
            if ((cnt = info.get(CONST, Double.class)) != null) {
                this.const_ = cnt;
            }
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }
}

