/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.polynomials;

import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.Constants;
import ec.tstoolkit.maths.polynomials.IRootsSolver;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.polynomials.PolynomialException;

public class GrantHitchinsSolver
implements IRootsSolver {
    private static final double ONE = 1.0;
    private static final double TWO = 2.0;
    private static final double ZERO = 0.0;
    private static final double TEN = 10.0;
    private static final double P8 = 0.8;
    private static final double A8 = 8.0;
    private static final double A1P5 = 1.5;
    private static final double P4Z1 = 1.0E-5;
    private static final double P5 = 0.5;
    private static final double P2Z1 = 0.001;
    private static final double P1 = 0.1;
    private static final double P3Z2 = 2.0E-4;
    private static final double FOUR = 4.0;
    private static final int g_max = 100;
    private double m_x;
    private double m_y;
    private double m_r;
    private double m_j;
    private double m_rx;
    private double m_jx;
    private double m_tol = g_eps;
    private double[] m_b;
    private double[] m_c;
    private double m_fac;
    private static final double g_eps = Constants.getEpsilon();
    private static final double g_small = 1.0E-15;
    private static final double g_cmax = Math.sqrt(Double.MAX_VALUE);
    private static final double g_eps2 = g_eps * 10000.0;
    private Polynomial m_remainder;
    private Complex[] m_roots;

    private boolean evaluate(double[] a, int n, double tol) {
        double a3;
        double b1;
        double p = -2.0 * this.m_x;
        double q = this.m_x * this.m_x + this.m_y * this.m_y;
        double t = Math.sqrt(q);
        double a2 = 0.0;
        double b2 = 0.0;
        double a1 = b1 = a[0];
        double c = Math.abs(a1) * 0.8;
        n -= 2;
        for (int k = 1; k < n; ++k) {
            a3 = a2;
            a2 = a1;
            a1 = a[k] - p * a2 - q * a3;
            c = t * c + Math.abs(a1);
            double b3 = b2;
            b2 = b1;
            b1 = a1 - p * b2 - q * b3;
        }
        a3 = a2;
        a2 = a1;
        a1 = a[(n += 2) - 2] - p * a2 - q * a3;
        this.m_r = a[n - 1] + this.m_x * a1 - q * a2;
        this.m_j = a1 * this.m_y;
        this.m_rx = a1 - 2.0 * b2 * this.m_y * this.m_y;
        this.m_jx = 2.0 * this.m_y * (b1 - this.m_x * b2);
        c = t * (t * c + Math.abs(a1)) + Math.abs(this.m_r);
        double eps = (10.0 * c - 8.0 * (Math.abs(this.m_r) + Math.abs(a1) * t) + 2.0 * Math.abs(this.m_x * a1)) * tol;
        return Math.sqrt(this.m_r * this.m_r + this.m_j * this.m_j) < eps;
    }

    @Override
    public void clear() {
        this.m_remainder = null;
        this.m_roots = null;
    }

    private void compositedeflation(double[] a, int n, double[] rez, double[] imz) {
        int i;
        double tol2 = Math.pow(this.m_tol, 1.5);
        double fun = 1.0 / tol2;
        int k = -1;
        for (i = 0; i < n; ++i) {
            double nfun = Math.abs(this.m_b[i]) + Math.abs(this.m_c[i]);
            if (!(nfun > this.m_tol) || !((nfun = Math.abs(this.m_b[i] - this.m_c[i]) / nfun) < fun)) continue;
            fun = nfun;
            k = i;
        }
        for (i = 0; i < k; ++i) {
            a[i] = this.m_b[i];
        }
        a[k] = 0.5 * (this.m_b[k] + this.m_c[k]);
        for (i = k + 1; i < n; ++i) {
            a[i] = this.m_c[i];
        }
    }

    private int deflate(double[] a, int n, double[] rez, double[] imz, double eps) {
        n = this.isrealroot(a, n, eps) ? this.deflaterealroot(a, n, rez, imz) : this.deflatecomplexroot(a, n, rez, imz);
        this.compositedeflation(a, n, rez, imz);
        return n;
    }

    private int deflatecomplexroot(double[] a, int n, double[] rez, double[] imz) {
        rez[n -= 2] = this.m_x * this.m_fac;
        rez[n - 1] = this.m_x * this.m_fac;
        imz[n] = this.m_y * this.m_fac;
        imz[n - 1] = -imz[n];
        this.m_r = 2.0 * this.m_x;
        this.m_j = -(this.m_x * this.m_x + this.m_y * this.m_y);
        this.m_b[0] = a[0];
        this.m_b[1] = a[1] + this.m_r * this.m_b[0];
        this.m_c[n - 1] = -a[n + 1] / this.m_j;
        this.m_c[n - 2] = -(a[n] + this.m_r * this.m_c[n - 1]) / this.m_j;
        boolean cbig = false;
        for (int i = 2; i < n; ++i) {
            this.m_b[i] = a[i] + this.m_r * this.m_b[i - 1] + this.m_j * this.m_b[i - 2];
            int j = n - i;
            if (!cbig) {
                this.m_c[j] = -(a[j + 2] - this.m_c[j + 2] + this.m_r * this.m_c[j + 1]) / this.m_j;
                if (Math.abs(this.m_c[j]) <= g_cmax) continue;
                cbig = true;
            }
            this.m_c[j] = g_cmax;
        }
        return n;
    }

    private int deflaterealroot(double[] a, int n, double[] rez, double[] imz) {
        rez[--n - 1] = this.m_x * this.m_fac;
        imz[n - 1] = 0.0;
        this.m_b[0] = a[0];
        this.m_c[n - 1] = -a[n] / this.m_x;
        boolean cbig = false;
        for (int i = 1; i < n; ++i) {
            this.m_b[i] = a[i] + this.m_x * this.m_b[i - 1];
            int j = n - i;
            if (!cbig) {
                this.m_c[j] = (this.m_c[j + 1] - a[j + 1]) / this.m_x;
                if (Math.abs(this.m_c[j]) <= g_cmax) continue;
                cbig = true;
            }
            this.m_c[j] = g_cmax;
        }
        return n;
    }

    @Override
    public boolean factorize(Polynomial p) {
        int degree;
        for (degree = p.getDegree(); degree > 0 && p.get(degree) == 0.0; --degree) {
        }
        if (degree == 0) {
            return false;
        }
        double[] a = new double[degree + 1];
        for (int i = 0; i <= degree; ++i) {
            a[i] = p.get(degree - i);
        }
        double[] rez = new double[degree];
        double[] imz = new double[degree];
        try {
            if (this.solve(a, a.length, rez, imz)) {
                this.m_roots = new Complex[degree];
                for (int i = 0; i < degree; ++i) {
                    this.m_roots[i] = Complex.cart(rez[i], imz[i]);
                }
                this.m_remainder = Polynomial.valueOf(p.get(p.getDegree()), new double[0]);
                return true;
            }
            return false;
        }
        catch (PolynomialException ex) {
            return false;
        }
    }

    public double getTol() {
        return this.m_tol;
    }

    private boolean isrealroot(double[] a, int n, double tol) {
        double tmp = this.m_y;
        this.m_y = 0.0;
        boolean rslt = this.evaluate(a, n, tol);
        this.m_y = tmp;
        return rslt;
    }

    @Override
    public Polynomial remainder() {
        return this.m_remainder;
    }

    @Override
    public GrantHitchinsSolver exemplar() {
        GrantHitchinsSolver solver = new GrantHitchinsSolver();
        solver.setTol(this.m_tol);
        return solver;
    }

    private void rescale_a(double[] a, int n) {
        double scale = 1.0;
        int i = n - 1;
        while (--i >= 0) {
            int n2 = i;
            a[n2] = a[n2] / (scale *= this.m_fac);
        }
    }

    @Override
    public Complex[] roots() {
        return this.m_roots;
    }

    private void scale_a(double[] a, int n) {
        double scale = 0.0;
        for (int i = 0; i < n; ++i) {
            double ai = Math.abs(a[i]);
            if (!(ai >= 1.0E-5)) continue;
            scale += Math.log(ai);
        }
        int q = (int)(scale / ((double)n * Math.log(2.0)) + 0.5);
        scale = Math.pow(2.0, -q);
        int i = 0;
        while (i < n) {
            int n2 = i++;
            a[n2] = a[n2] * scale;
        }
    }

    private boolean search(double[] a, int n, double tol) {
        this.evaluate(a, n, tol);
        double fun = this.m_r * this.m_r + this.m_j * this.m_j;
        int j = 0;
        double tol2 = Math.pow(this.m_tol, 1.5);
        while (++j < 100) {
            double g = this.m_rx * this.m_rx + this.m_jx * this.m_jx;
            if (g < fun * tol2) {
                return false;
            }
            double s1 = -(this.m_r * this.m_rx + this.m_j * this.m_jx) / g;
            double s2 = (this.m_r * this.m_jx - this.m_j * this.m_rx) / g;
            double sig = 2.0E-4;
            double s = Math.sqrt(s1 * s1 + s2 * s2);
            if (s > 1.0) {
                s1 /= s;
                s2 /= s;
                sig /= s;
            }
            this.m_x += s1;
            this.m_y += s2;
            double nfun = 0.0;
            int k = 0;
            while (++k < 100) {
                if (this.evaluate(a, n, tol)) {
                    return true;
                }
                nfun = this.m_r * this.m_r + this.m_j * this.m_j;
                if (fun - nfun >= sig * fun) break;
                s1 = 0.5 * s1;
                s2 = 0.5 * s2;
                if (Math.abs(s1) <= g_eps * Math.abs(this.m_x) && Math.abs(s2) <= g_eps * Math.abs(this.m_y)) {
                    return false;
                }
                s *= 0.5;
                sig *= 0.5;
                this.m_x -= s1;
                this.m_y -= s2;
            }
            if (k == 100) {
                throw new PolynomialException("Infinite loop in GrantHitchinsSolver");
            }
            fun = nfun;
        }
        if (j == 100) {
            throw new PolynomialException("Infinite loop in GrantHitchinsSolver");
        }
        return true;
    }

    public void setTol(double tol) {
        if (tol < g_eps) {
            throw new PolynomialException("tol is too small");
        }
        this.m_tol = tol;
    }

    private boolean solve(double[] a, int n, double[] rez, double[] imz) {
        if ((n = this.solve(a, n, rez, imz, false, this.m_tol)) != 1) {
            n = this.solve(a, n, rez, imz, true, g_eps2);
        }
        return n <= 1;
    }

    private int solve(double[] a, int n, double[] rez, double[] imz, boolean reentry, double eps) {
        if (n < 2) {
            return n;
        }
        if (Math.abs(a[0]) <= 1.0E-15) {
            throw new PolynomialException("invalid polynomial");
        }
        this.m_fac = 1.0;
        while (a[n - 1] == 0.0) {
            rez[--n - 1] = 0.0;
            imz[n - 1] = 0.0;
        }
        while (n > 1) {
            if (n == 2) {
                this.solve1(a, rez, imz);
                return 1;
            }
            if (n == 3) {
                this.solve2(a, rez, imz);
                return 1;
            }
            int nn = this.solven(a, n, rez, imz, reentry, eps);
            if (nn == n) {
                return n;
            }
            n = nn;
        }
        return 1;
    }

    private void solve1(double[] a, double[] rez, double[] imz) {
        rez[0] = -a[1] / a[0] * this.m_fac;
        imz[0] = 0.0;
    }

    private void solve2(double[] a, double[] rez, double[] imz) {
        this.m_r = a[1] * a[1] - 4.0 * a[0] * a[2];
        if (this.m_r > 0.0) {
            imz[0] = 0.0;
            imz[1] = 0.0;
            rez[0] = a[1] < 0.0 ? 0.5 * (-a[1] + Math.sqrt(this.m_r)) / a[0] * this.m_fac : (a[1] == 0.0 ? -0.5 * Math.sqrt(this.m_r) / a[0] * this.m_fac : 0.5 * (-a[1] - Math.sqrt(this.m_r)) / a[0] * this.m_fac);
            rez[1] = a[2] / (rez[0] * a[0]) * this.m_fac * this.m_fac;
        } else {
            rez[1] = -0.5 * a[1] / a[0] * this.m_fac;
            rez[0] = rez[1];
            imz[1] = 0.5 * Math.sqrt(-this.m_r) / a[0] * this.m_fac;
            imz[0] = -imz[1];
        }
    }

    private int solven(double[] a, int n, double[] rez, double[] imz, boolean reentry, double eps) {
        this.scale_a(a, n);
        this.m_b = (double[])a.clone();
        this.m_c = new double[n];
        this.step1(a, n);
        if (!reentry) {
            this.m_x = 0.001;
            this.m_y = 0.1;
        } else {
            this.m_x = rez[0];
            this.m_y = imz[0] + 2.0 * eps;
            reentry = false;
        }
        if (!this.search(a, n, eps)) {
            this.rescale_a(a, n);
            return n;
        }
        return this.deflate(a, n, rez, imz, eps);
    }

    /*
     * Unable to fully structure code
     */
    private void step1(double[] a, int n) {
        while (true) {
            for (i = n - 1; i > 0; --i) {
                if (this.m_b[i] == 0.0) {
                    return;
                }
                t = this.m_b[0] / this.m_b[i];
                if (Math.abs(t) >= 1.0) {
                    return;
                }
                for (k = 1; k <= i; ++k) {
                    this.m_c[k - 1] = this.m_b[k] - t * this.m_b[i - k];
                }
                for (k = 0; k < i; ++k) {
                    this.m_b[k] = this.m_c[k];
                }
            }
            this.m_fac *= 2.0;
            scale = 1.0;
            i = n - 2;
            while (true) {
                if (i < 0) ** continue;
                v0 = i;
                a[v0] = a[v0] * (scale *= 2.0);
                this.m_b[i] = a[i];
                --i;
            }
            break;
        }
    }
}

