/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.api;

import com.portfolioeffect.quant.client.api.Metric;
import com.portfolioeffect.quant.client.api.Position;
import com.portfolioeffect.quant.client.api.Util;
import com.portfolioeffect.quant.client.model.ComputeErrorException;
import com.portfolioeffect.quant.client.util.SimpleLazyMetricBuilder;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Portfolio {
    private com.portfolioeffect.quant.client.portfolio.Portfolio portfolio;

    public Portfolio(com.portfolioeffect.quant.client.portfolio.Portfolio portfolio) {
        this.portfolio = portfolio;
    }

    public Portfolio(Portfolio portfolio) throws IOException {
        this.portfolio = new com.portfolioeffect.quant.client.portfolio.Portfolio(portfolio.portfolio);
    }

    public Portfolio(String fromTime, String toTime, String index) throws ComputeErrorException {
        this.portfolio = new com.portfolioeffect.quant.client.portfolio.Portfolio(Util.getClientConnection(), fromTime, toTime, index);
    }

    public Portfolio(String fromTime, String toTime) throws ComputeErrorException {
        this(fromTime, toTime, "SPY");
    }

    public Portfolio(double[] indexPrice, long[] indexTime) throws ComputeErrorException {
        this.portfolio = new com.portfolioeffect.quant.client.portfolio.Portfolio(Util.getClientConnection());
        this.portfolio.addIndex(indexPrice, indexTime);
        this.portfolio.setFromTime(new Timestamp(indexTime[0]).toString());
        this.portfolio.setToTime(new Timestamp(indexTime[indexTime.length - 1]).toString());
    }

    public Position add_position(String symbol, int quantity) {
        com.portfolioeffect.quant.client.portfolio.Position position = new com.portfolioeffect.quant.client.portfolio.Position(this.portfolio, symbol, quantity);
        return new Position(position);
    }

    public Position add_position(String symbol, int[] quantity, long[] timeQuantity) {
        com.portfolioeffect.quant.client.portfolio.Position position = new com.portfolioeffect.quant.client.portfolio.Position(this.portfolio, symbol, quantity, timeQuantity);
        return new Position(position);
    }

    public Position add_position(String symbol, int[] quantity, String[] timeQuantity) {
        com.portfolioeffect.quant.client.portfolio.Position position = new com.portfolioeffect.quant.client.portfolio.Position(this.portfolio, symbol, quantity, timeQuantity);
        return new Position(position);
    }

    public Position add_position(String symbol, int quantity, double[] price, long[] priceTime) {
        com.portfolioeffect.quant.client.portfolio.Position position = new com.portfolioeffect.quant.client.portfolio.Position(this.portfolio, symbol, price, quantity, priceTime);
        return new Position(position);
    }

    public Position add_position(String symbol, int[] quantity, long[] quantityTime, double[] price, long[] priceTime) {
        com.portfolioeffect.quant.client.portfolio.Position position = new com.portfolioeffect.quant.client.portfolio.Position(this.portfolio, symbol, price, priceTime, quantity, quantityTime);
        return new Position(position);
    }

    public void remove_position(String symbol) {
        this.portfolio.removePositionPrice(symbol);
        this.portfolio.removePositionQuantity(symbol);
    }

    public Portfolio settings(String key, String value) {
        this.portfolio.setParam(key, value);
        return this;
    }

    public String settings(String key) {
        return this.portfolio.getParam(key);
    }

    public HashMap<String, String> settings() {
        return this.portfolio.getPortfolioSettingsR();
    }

    public void settings(HashMap<String, String> map) {
        this.portfolio.setPortfolioSettings(map);
    }

    private Metric buildMetric(String metric) {
        SimpleLazyMetricBuilder builder = new SimpleLazyMetricBuilder();
        builder.setMetricName(metric);
        return new Metric(builder.build(this.portfolio));
    }

    private Metric buildMetricCI(String metric, double confidenceInterval) {
        SimpleLazyMetricBuilder builder = new SimpleLazyMetricBuilder();
        builder.setMetricName(metric);
        builder.setConfidenceInterval(confidenceInterval);
        return new Metric(builder.build(this.portfolio));
    }

    private Metric buildMetricCI(String metric, double confidenceIntervalA, double confidenceIntervalB) {
        SimpleLazyMetricBuilder builder = new SimpleLazyMetricBuilder();
        builder.setMetricName(metric);
        builder.setConfidenceIntervalAlphaBeta(confidenceIntervalA, confidenceIntervalB);
        return new Metric(builder.build(this.portfolio));
    }

    private Metric buildMetricTR(String metric, double thresholdReturn) {
        SimpleLazyMetricBuilder builder = new SimpleLazyMetricBuilder();
        builder.setMetricName(metric);
        builder.setThresholdReturn(thresholdReturn);
        return new Metric(builder.build(this.portfolio));
    }

    public Metric value() {
        return this.buildMetric("VALUE");
    }

    public Metric log_return() {
        return this.buildMetric("RETURN");
    }

    public Metric expected_return() {
        return this.buildMetric("EXPECTED_RETURN");
    }

    public Metric profit() {
        return this.buildMetric("PROFIT");
    }

    public Metric beta() {
        return this.buildMetric("BETA");
    }

    public Metric alpha_exante() {
        return this.buildMetric("ALPHA");
    }

    public Metric variance() {
        return this.buildMetric("VARIANCE");
    }

    public Metric max_drawdown() {
        return this.buildMetric("MAX_DRAWDOWN");
    }

    public Metric calmar_ratio() {
        return this.buildMetric("CALMAR_RATIO");
    }

    public Metric value_at_risk(double confidenceInterval) {
        return this.buildMetricCI("VAR", confidenceInterval);
    }

    public Metric expected_power_utility(double alpha) {
        SimpleLazyMetricBuilder builder = new SimpleLazyMetricBuilder();
        builder.setMetricName("PORTFOLIO_EXPECTED_POWER_UTILITY");
        builder.setParam("alpha", "" + alpha);
        return new Metric(builder.build(this.portfolio));
    }

    public Metric expected_kelly_utility() {
        SimpleLazyMetricBuilder builder = new SimpleLazyMetricBuilder();
        builder.setMetricName("PORTFOLIO_EXPECTED_POWER_UTILITY");
        builder.setParam("alpha", "0");
        return new Metric(builder.build(this.portfolio));
    }

    public Metric expected_shortfall(double confidenceInterval) {
        return this.buildMetricCI("CVAR", confidenceInterval);
    }

    public Metric mod_sharpe_ratio(double confidenceInterval) {
        return this.buildMetricCI("SHARPE_RATIO_MOD", confidenceInterval);
    }

    public Metric starr_ratio(double confidenceInterval) {
        return this.buildMetricCI("STARR_RATIO", confidenceInterval);
    }

    public Metric sharpe_ratio() {
        return this.buildMetric("SHARPE_RATIO");
    }

    public Metric treynor_ratio() {
        return this.buildMetric("TREYNOR_RATIO");
    }

    public Metric skewness() {
        return this.buildMetric("SKEWNESS");
    }

    public Metric kurtosis() {
        return this.buildMetric("KURTOSIS");
    }

    public Metric information_ratio() {
        return this.buildMetric("INFORMATION_RATIO");
    }

    public Metric alpha_jensens() {
        return this.buildMetric("ALPHA_JENSEN");
    }

    public Metric omega_ratio(double thresholdReturn) {
        return this.buildMetricTR("OMEGA_RATIO", thresholdReturn);
    }

    public Metric rachev_ratio(double confidenceIntervalA, double confidenceIntervalB) {
        return this.buildMetricCI("RACHEV_RATIO", confidenceIntervalA, confidenceIntervalB);
    }

    public Metric gain_variance() {
        return this.buildMetric("GAIN_VARIANCE");
    }

    public Metric loss_variance() {
        return this.buildMetric("LOSS_VARIANCE");
    }

    public Metric downside_variance(double thresholdReturn) {
        return this.buildMetricTR("DOWNSIDE_VARIANCE", thresholdReturn);
    }

    public Metric upside_variance(double thresholdReturn) {
        return this.buildMetricTR("UPSIDE_VARIANCE", thresholdReturn);
    }

    public Metric expected_downside_return(double thresholdReturn) {
        return this.buildMetricTR("EXPECTED_DOWNSIDE_THRESHOLD_RETURN", thresholdReturn);
    }

    public Metric expected_upside_return(double thresholdReturn) {
        return this.buildMetricTR("EXPECTED_UPSIDE_THRESHOLD_RETURN", thresholdReturn);
    }

    public Metric hurst_exponent() {
        return this.buildMetric("HURST_EXPONENT");
    }

    public Metric fractal_dimension() {
        return this.buildMetric("FRACTAL_DIMENSION");
    }

    public Metric txn_costs() {
        return this.buildMetric("TRANSACTION_COSTS_SIZE");
    }

    public Metric sortino_ratio(double thresholdReturn) {
        return this.buildMetricTR("SORTINO_RATIO", thresholdReturn);
    }

    public Metric upside_downside_variance_ratio(double thresholdReturn) {
        return this.buildMetricTR("UPSIDE_DOWNSIDE_VARIANCE_RATIO", thresholdReturn);
    }

    public Metric gain_loss_variance_ratio() {
        return this.buildMetric("GAIN_LOSS_VARIANCE_RATIO");
    }

    public Metric down_capture_ratio() {
        return this.buildMetric("DOWN_CAPTURE_RATIO");
    }

    public Metric up_capture_ratio() {
        return this.buildMetric("UP_CAPTURE_RATIO");
    }

    public Metric down_number_ratio() {
        return this.buildMetric("DOWN_NUMBER_RATIO");
    }

    public Metric up_number_ratio() {
        return this.buildMetric("UP_NUMBER_RATIO");
    }

    public Metric down_percentage_ratio() {
        return this.buildMetric("DOWN_PERCENTAGE_RATIO");
    }

    public Metric up_percentage_ratio() {
        return this.buildMetric("UP_PERCENTAGE_RATIO");
    }

    public Metric cumulant(int order) {
        return this.buildMetric("CUMULANT" + order);
    }

    public Metric moment(int order) {
        return this.buildMetric("MOMENT" + order);
    }

    public Metric constraints_only() {
        return this.buildMetric("CONTRAINTS_ONLY");
    }

    public Metric equiweight() {
        return this.buildMetric("EQUIWEIGHT");
    }

    public String[] symbols() {
        return this.portfolio.getSymbols();
    }

    public Position get_position(String symbol) throws Exception {
        com.portfolioeffect.quant.client.portfolio.Position position = this.portfolio.getPosition(symbol);
        if (position != null) {
            return new Position(position);
        }
        throw new Exception("Position " + symbol + " is not exist");
    }

    public List<String[]> symbols_available() throws Exception {
        com.portfolioeffect.quant.client.result.Metric methodResult = this.portfolio.getAllSymbolsList();
        if (methodResult.hasError()) {
            throw new Exception(methodResult.getErrorMessage());
        }
        ArrayList<String[]> list = new ArrayList<String[]>();
        list.add(methodResult.getStringArray("id"));
        list.add(methodResult.getStringArray("exchange"));
        list.add(methodResult.getStringArray("description"));
        return list;
    }

    public com.portfolioeffect.quant.client.portfolio.Portfolio getPortfolio() {
        return this.portfolio;
    }
}

