/*
 * Decompiled with CFR 0.152.
 */
package com.sosnoski.util.array;

import com.sosnoski.util.array.ArrayBase;

public class IntArray
extends ArrayBase {
    protected int[] m_baseArray;

    public IntArray(int n, int n2) {
        super(n, n2, Integer.TYPE);
    }

    public IntArray(int n) {
        super(n, Integer.TYPE);
    }

    public IntArray() {
        this(8);
    }

    public IntArray(IntArray intArray) {
        super(intArray);
    }

    protected final Object getArray() {
        return this.m_baseArray;
    }

    protected final void setArray(Object object) {
        this.m_baseArray = (int[])object;
    }

    public final int add(int n) {
        int n2 = this.getAddIndex();
        this.m_baseArray[n2] = n;
        return n2;
    }

    public void add(int n, int n2) {
        this.makeInsertSpace(n);
        this.m_baseArray[n] = n2;
    }

    public final int get(int n) {
        if (n < this.m_countPresent) {
            return this.m_baseArray[n];
        }
        throw new ArrayIndexOutOfBoundsException("Invalid index value");
    }

    public final void set(int n, int n2) {
        if (n >= this.m_countPresent) {
            throw new ArrayIndexOutOfBoundsException("Invalid index value");
        }
        this.m_baseArray[n] = n2;
    }

    public int[] toArray() {
        return (int[])this.buildArray(Integer.TYPE, 0, this.m_countPresent);
    }

    public int[] toArray(int n, int n2) {
        return (int[])this.buildArray(Integer.TYPE, n, n2);
    }

    public Object clone() {
        return new IntArray(this);
    }
}

