/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.tree.MutableTree;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.SimpleTree;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.HashSet;

public class RescaledTreeParser
extends AbstractXMLObjectParser {
    public static final String RESCALED_TREE = "rescaledTree";
    public static final String CLADE = "clade";
    public static final String HEIGHT = "height";
    private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("height", true), new ElementRule(Tree.class), new ElementRule("clade", new XMLSyntaxRule[]{AttributeRule.newDoubleRule("height", true), new ElementRule(TaxonList.class)}, 0, Integer.MAX_VALUE)};

    @Override
    public String getParserName() {
        return RESCALED_TREE;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        int n;
        Tree tree = (Tree)xMLObject.getChild(Tree.class);
        SimpleTree simpleTree = new SimpleTree(tree);
        for (n = 0; n < simpleTree.getInternalNodeCount(); ++n) {
            simpleTree.setNodeHeight(simpleTree.getInternalNode(n), Double.NEGATIVE_INFINITY);
        }
        for (n = 0; n < xMLObject.getChildCount(); ++n) {
            XMLObject xMLObject2;
            if (!(xMLObject.getChild(n) instanceof XMLObject) || !(xMLObject2 = (XMLObject)xMLObject.getChild(n)).getName().equals(CLADE)) continue;
            TaxonList taxonList = (TaxonList)xMLObject2.getChild(TaxonList.class);
            HashSet<String> hashSet = new HashSet<String>();
            for (Taxon taxon : taxonList) {
                hashSet.add(taxon.getId());
            }
            NodeRef nodeRef = TreeUtils.getCommonAncestorNode(simpleTree, hashSet);
            if (nodeRef == null || TreeUtils.getLeafCount(simpleTree, nodeRef) != hashSet.size()) {
                throw new XMLParseException("Clade defined by taxon Set, " + taxonList.getId() + ", is not found in the guide tree");
            }
            if (!xMLObject2.hasAttribute(HEIGHT)) continue;
            double d = xMLObject2.getDoubleAttribute(HEIGHT);
            simpleTree.setNodeHeight(nodeRef, d);
        }
        if (xMLObject.hasAttribute(HEIGHT)) {
            simpleTree.setNodeHeight(simpleTree.getRoot(), xMLObject.getDoubleAttribute(HEIGHT));
        }
        this.interpolateHeights(simpleTree, simpleTree.getRoot());
        return simpleTree;
    }

    private double interpolateHeights(MutableTree mutableTree, NodeRef nodeRef) {
        if (!mutableTree.isExternal(nodeRef)) {
            double d = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < mutableTree.getChildCount(nodeRef); ++i) {
                NodeRef nodeRef2 = mutableTree.getChild(nodeRef, i);
                double d2 = this.interpolateHeights(mutableTree, nodeRef2);
                if (!(d2 > d)) continue;
                d = d2;
            }
            double d3 = mutableTree.getNodeHeight(nodeRef);
            if (Double.isInfinite(d3)) {
                int n = 1;
                NodeRef nodeRef3 = mutableTree.getParent(nodeRef);
                while (nodeRef3 != null && Double.isInfinite(mutableTree.getNodeHeight(nodeRef3))) {
                    nodeRef3 = mutableTree.getParent(nodeRef3);
                    ++n;
                }
                d3 = nodeRef3 == null ? d + (double)n : (mutableTree.getNodeHeight(nodeRef3) + d) / 2.0;
            }
            mutableTree.setNodeHeight(nodeRef, d3);
            return d3;
        }
        return mutableTree.getNodeHeight(nodeRef);
    }

    @Override
    public String getParserDescription() {
        return "This element rescales a given tree with a set of clade heights.";
    }

    @Override
    public Class getReturnType() {
        return Tree.class;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }
}

