/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.continuous;

import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.continuous.ContinuousDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.preorder.NewTipFullConditionalDistributionDelegate;
import dr.evomodel.treedatalikelihood.preorder.TipFullConditionalDistributionDelegate;
import dr.evomodel.treedatalikelihood.preorder.TipGradientViaFullConditionalDelegate;
import dr.inference.hmc.GradientWrtParameterProvider;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.math.matrixAlgebra.Vector;
import dr.xml.Reportable;

public class TreeTipGradient
implements GradientWrtParameterProvider,
Reportable {
    private final TreeDataLikelihood treeDataLikelihood;
    private final TreeTrait treeTraitProvider;
    private final Tree tree;
    private final Parameter traitParameter;
    private final int nTaxa;
    private final int nTraits;
    private final int dimTrait;
    private final Parameter maskParameter;

    public TreeTipGradient(String string, TreeDataLikelihood treeDataLikelihood, ContinuousDataLikelihoodDelegate continuousDataLikelihoodDelegate, Parameter parameter) {
        String string2;
        String string3;
        assert (treeDataLikelihood != null);
        this.treeDataLikelihood = treeDataLikelihood;
        this.tree = treeDataLikelihood.getTree();
        this.maskParameter = parameter;
        String string4 = TipGradientViaFullConditionalDelegate.getName(string);
        TreeTrait treeTrait = treeDataLikelihood.getTreeTrait(string4);
        if (treeTrait == null) {
            continuousDataLikelihoodDelegate.addFullConditionalGradientTrait(string);
        }
        if (treeDataLikelihood.getTreeTrait(string3 = TipFullConditionalDistributionDelegate.getName(string)) == null) {
            continuousDataLikelihoodDelegate.addFullConditionalDensityTrait(string);
        }
        if (treeDataLikelihood.getTreeTrait(string2 = NewTipFullConditionalDistributionDelegate.getName(string)) == null) {
            continuousDataLikelihoodDelegate.addNewFullConditionalDensityTrait(string);
        }
        this.treeTraitProvider = treeDataLikelihood.getTreeTrait(string4);
        assert (this.treeTraitProvider != null);
        this.nTaxa = treeDataLikelihood.getTree().getExternalNodeCount();
        this.nTraits = treeDataLikelihood.getDataLikelihoodDelegate().getTraitCount();
        this.dimTrait = treeDataLikelihood.getDataLikelihoodDelegate().getTraitDim();
        if (this.nTraits != 1) {
            throw new RuntimeException("Not yet implemented for >1 traits");
        }
        this.traitParameter = continuousDataLikelihoodDelegate.getDataModel().getParameter();
        if (parameter != null && parameter.getDimension() != this.traitParameter.getDimension()) {
            throw new RuntimeException("Trait and mask parameters must be the same size");
        }
    }

    @Override
    public Likelihood getLikelihood() {
        return this.treeDataLikelihood;
    }

    @Override
    public Parameter getParameter() {
        return this.traitParameter;
    }

    @Override
    public int getDimension() {
        return this.getParameter().getDimension();
    }

    @Override
    public double[] getGradientLogDensity() {
        int n;
        double[] dArray = new double[this.nTaxa * this.dimTrait * this.nTraits];
        int n2 = 0;
        for (n = 0; n < this.nTaxa; ++n) {
            double[] dArray2 = (double[])this.treeTraitProvider.getTrait(this.tree, this.tree.getExternalNode(n));
            System.arraycopy(dArray2, 0, dArray, n2, dArray2.length);
            n2 += dArray2.length;
        }
        if (this.maskParameter != null) {
            for (n = 0; n < this.maskParameter.getDimension(); ++n) {
                if (this.maskParameter.getParameterValue(n) != 0.0) continue;
                dArray[n] = 0.0;
            }
        }
        return dArray;
    }

    @Override
    public String getReport() {
        return new Vector(this.getGradientLogDensity()).toString();
    }
}

