/*
 * Decompiled with CFR 0.152.
 */
package moa.streams;

import com.github.javacliparser.FileOption;
import com.github.javacliparser.RangeOption;
import com.yahoo.labs.samoa.instances.Instances;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import moa.core.InputStreamProgressMonitor;
import moa.core.InstanceExample;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.streams.MultiTargetInstanceStream;
import moa.tasks.TaskMonitor;

public class MultiTargetArffFileStream
extends AbstractOptionHandler
implements MultiTargetInstanceStream {
    private static final long serialVersionUID = 1L;
    public FileOption arffFileOption = new FileOption("arffFile", 'f', "ARFF file to load.", null, "arff", false);
    public RangeOption outputAttributesOption = new RangeOption("outputAttributes", 'c', "Output attributes:  n for first n attributes,  -n for last n attributes  For example, 2 for the two first attributes, -2 for the two last attributes.", "-1");
    protected Instances instances;
    protected Reader fileReader;
    protected boolean hitEndOfFile;
    protected InstanceExample lastInstanceRead;
    protected int numInstancesRead;
    protected InputStreamProgressMonitor fileProgressMonitor;

    @Override
    public String getPurposeString() {
        return "A stream read from an ARFF file.";
    }

    public MultiTargetArffFileStream() {
    }

    public MultiTargetArffFileStream(String arffFileName, String classIndices) {
        this.arffFileOption.setValue(arffFileName);
        this.outputAttributesOption.setValue(classIndices);
        this.restart();
    }

    @Override
    public void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        this.restart();
    }

    @Override
    public InstancesHeader getHeader() {
        return new InstancesHeader(this.instances);
    }

    @Override
    public long estimatedRemainingInstances() {
        double progressFraction = this.fileProgressMonitor.getProgressFraction();
        if (progressFraction > 0.0 && this.numInstancesRead > 0) {
            return (long)((double)this.numInstancesRead / progressFraction - (double)this.numInstancesRead);
        }
        return -1L;
    }

    @Override
    public boolean hasMoreInstances() {
        return !this.hitEndOfFile;
    }

    @Override
    public InstanceExample nextInstance() {
        InstanceExample prevInstance = this.lastInstanceRead;
        this.hitEndOfFile = !this.readNextInstanceFromFile();
        return prevInstance;
    }

    @Override
    public boolean isRestartable() {
        return true;
    }

    @Override
    public void restart() {
        try {
            if (this.fileReader != null) {
                this.fileReader.close();
            }
            FileInputStream fileStream = new FileInputStream(this.arffFileOption.getFile());
            this.fileProgressMonitor = new InputStreamProgressMonitor(fileStream);
            this.fileReader = new BufferedReader(new InputStreamReader(this.fileProgressMonitor));
            this.instances = new Instances(this.fileReader, this.outputAttributesOption.getRange());
            this.numInstancesRead = 0;
            this.lastInstanceRead = null;
            this.hitEndOfFile = !this.readNextInstanceFromFile();
        }
        catch (IOException ioe) {
            throw new RuntimeException("ArffFileStream restart failed.", ioe);
        }
    }

    protected boolean readNextInstanceFromFile() {
        try {
            if (this.instances.readInstance(this.fileReader)) {
                this.lastInstanceRead = new InstanceExample(this.instances.instance(0));
                this.instances.delete();
                ++this.numInstancesRead;
                return true;
            }
            if (this.fileReader != null) {
                this.fileReader.close();
                this.fileReader = null;
            }
            return false;
        }
        catch (IOException ioe) {
            throw new RuntimeException("ArffFileStream failed to read instance from stream.", ioe);
        }
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }
}

