/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.multilabel.attributeclassobservers;

import com.github.javacliparser.FlagOption;
import java.util.HashMap;
import java.util.Map;
import moa.classifiers.rules.core.NominalRulePredicate;
import moa.classifiers.rules.core.Utils;
import moa.classifiers.rules.multilabel.attributeclassobservers.NominalStatisticsObserver;
import moa.classifiers.rules.multilabel.core.AttributeExpansionSuggestion;
import moa.classifiers.rules.multilabel.core.splitcriteria.MultiLabelSplitCriterion;
import moa.core.DoubleVector;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.tasks.TaskMonitor;

public class MultiLabelNominalAttributeObserver
extends AbstractOptionHandler
implements NominalStatisticsObserver {
    protected FlagOption addUndeclaredValuesOption = new FlagOption("addUndeclaredValues", 'a', "Add to the domain values not declared? If false, the value is not used.");
    protected HashMap<Integer, DoubleVector[]> statisticsByNominalValue;
    private static final long serialVersionUID = 1L;

    @Override
    public void observeAttribute(double inputAttributeValue, DoubleVector[] observedStatistics) {
        DoubleVector[] current;
        if (this.statisticsByNominalValue == null) {
            this.statisticsByNominalValue = new HashMap();
        }
        if ((current = this.statisticsByNominalValue.get((int)inputAttributeValue)) == null) {
            current = this.copyOfStatistics(observedStatistics);
        } else {
            this.addStatistics(current, observedStatistics);
        }
        this.statisticsByNominalValue.put((int)inputAttributeValue, current);
    }

    @Override
    public AttributeExpansionSuggestion getBestEvaluatedSplitSuggestion(MultiLabelSplitCriterion criterion, DoubleVector[] preSplitStatistics, int inputAttributeIndex) {
        double bestSuggestionMerit = -1.7976931348623157E308;
        AttributeExpansionSuggestion bestSuggestiong = null;
        for (Map.Entry<Integer, DoubleVector[]> pair : this.statisticsByNominalValue.entrySet()) {
            int splitValue = pair.getKey();
            DoubleVector[] statistics = pair.getValue();
            DoubleVector[][] resultingStatistics = new DoubleVector[statistics.length][2];
            for (int i = 0; i < statistics.length; ++i) {
                resultingStatistics[i] = new DoubleVector[2];
                resultingStatistics[i][0] = statistics[i];
                resultingStatistics[i][1] = new DoubleVector(preSplitStatistics[i]);
                resultingStatistics[i][1].subtractValues(statistics[i]);
            }
            double merit = criterion.getMeritOfSplit(preSplitStatistics, resultingStatistics);
            if (!(merit > bestSuggestionMerit)) continue;
            bestSuggestionMerit = merit;
            bestSuggestiong = new AttributeExpansionSuggestion(new NominalRulePredicate(inputAttributeIndex, splitValue, true), Utils.copy(resultingStatistics), merit);
        }
        return bestSuggestiong;
    }

    private void addStatistics(DoubleVector[] current, DoubleVector[] observedStatistics) {
        for (int i = 0; i < current.length; ++i) {
            current[i].addValues(observedStatistics[i]);
        }
    }

    private DoubleVector[] copyOfStatistics(DoubleVector[] statistics) {
        DoubleVector[] copy = new DoubleVector[statistics.length];
        for (int i = 0; i < statistics.length; ++i) {
            copy[i] = new DoubleVector(statistics[i]);
        }
        return copy;
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
    }
}

