/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.IDataRecordSet;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.util.VKMUtil;

public class DataRecordSet
implements IDataRecordSet {
    protected String relationName;
    protected List<Attribute> attributes;
    private final Map<Attribute, Integer> attributeIndices = new HashMap<Attribute, Integer>();
    protected List<DataRecord> dataRecords;

    public DataRecordSet(DataRecordSet dataset, int capacity) {
        if (capacity < 0) {
            capacity = 0;
        }
        this.relationName = dataset.relationName;
        this.attributes = new ArrayList<Attribute>(dataset.attributes);
        this.dataRecords = new ArrayList<DataRecord>(capacity);
    }

    public DataRecordSet(String name, List<Attribute> attributes) {
        this.relationName = name;
        this.attributes = new ArrayList<Attribute>(attributes);
        this.dataRecords = new ArrayList<DataRecord>();
    }

    public DataRecordSet(String name, List<Attribute> attributes, int capacity) {
        this.relationName = name;
        this.attributes = new ArrayList<Attribute>(attributes);
        this.dataRecords = new ArrayList<DataRecord>(capacity);
    }

    public DataRecordSet(String name, List<Attribute> attributes, List<DataRecord> dataRecords) {
        this.relationName = name;
        this.attributes = new ArrayList<Attribute>(attributes);
        this.dataRecords = new ArrayList<DataRecord>(dataRecords);
        for (DataRecord d : this.dataRecords) {
            d.setDataset(this);
        }
    }

    @Override
    public DataRecord add(DataRecord instance) {
        DataRecord newInstance = instance.copy();
        newInstance.setDataset(this);
        this.dataRecords.add(newInstance);
        return newInstance;
    }

    @Override
    public Iterator<Attribute> attributeIterator() {
        return this.attributes.iterator();
    }

    @Override
    public void compactify() {
        if (this.dataRecords instanceof ArrayList) {
            ((ArrayList)this.dataRecords).trimToSize();
        }
    }

    @Override
    public void delete() {
        this.dataRecords.clear();
    }

    @Override
    public void delete(int index) {
        this.dataRecords.remove(index);
    }

    @Override
    public void deleteAttributeAt(int position) {
        if (position < 0 || position >= this.attributes.size()) {
            throw new IllegalArgumentException("Index out of range");
        }
        this.attributes.remove(position);
        for (DataRecord instance : this.dataRecords) {
            instance.deleteAttributeAt(position);
        }
        this.attributeIndices.clear();
    }

    @Override
    public DataRecord get(int index) {
        return this.dataRecords.get(index);
    }

    @Override
    public Attribute getAttribute(int index) {
        return this.attributes.get(index);
    }

    @Override
    public Attribute getAttribute(String name) {
        int i = 0;
        while (i < this.getNumAttributes()) {
            if (this.getAttribute(i).getId().equals(name)) {
                return this.getAttribute(i);
            }
            ++i;
        }
        return null;
    }

    @Override
    public int getIndex(Attribute attribute) {
        return this.getCachedIndex(attribute);
    }

    @Override
    public int getNumAttributes() {
        return this.attributes.size();
    }

    @Override
    public int getNumInstances() {
        return this.dataRecords.size();
    }

    @Override
    public String getRelationName() {
        return this.relationName;
    }

    @Override
    public void insertAttributeAt(Attribute att, int position) {
        if (position < 0 || position > this.attributes.size()) {
            throw new IllegalArgumentException("Index out of range");
        }
        this.attributes.add(position, att);
        int i = 0;
        while (i < this.getNumInstances()) {
            this.get(i).insertAttributeAt(position);
            ++i;
        }
        this.attributeIndices.clear();
    }

    @Override
    public Iterator<DataRecord> iterator() {
        return this.dataRecords.iterator();
    }

    @Override
    public void updateAttribute(Attribute att, int position) {
        if (position < 0 || position > this.attributes.size()) {
            throw new IllegalArgumentException("Index out of range");
        }
        if (!this.attributes.get(position).getId().equals(att.getId())) {
            throw new IllegalArgumentException("Different attribute-ids");
        }
        this.attributes.set(position, att);
    }

    @Override
    public String printInstances(Ontology om) {
        StringBuffer text = new StringBuffer();
        text.append("@relation").append(" ").append(VKMUtil.quote(this.relationName)).append("\n\n");
        int i = 0;
        while (i < this.getNumAttributes()) {
            text.append(this.getAttribute(i)).append("\n");
            ++i;
        }
        text.append("\n").append("@data").append("\n");
        if (om == null) {
            i = 0;
            while (i < this.getNumInstances()) {
                text.append(this.get(i));
                if (i < this.getNumInstances() - 1) {
                    text.append('\n');
                }
                ++i;
            }
        } else {
            Iterator<DataRecord> iter = om.getDataView().instanceIterator();
            while (iter.hasNext()) {
                text.append(iter.next());
                if (!iter.hasNext()) continue;
                text.append('\n');
            }
        }
        return text.toString();
    }

    @Override
    public void setRelationName(String newName) {
        this.relationName = newName;
    }

    public String toString() {
        return this.printInstances(null);
    }

    protected int getCachedIndex(Attribute attribute) {
        Integer index = this.attributeIndices.get(attribute);
        if (index == null) {
            index = this.attributes.indexOf(attribute);
            this.attributeIndices.put(attribute, index);
        }
        return index;
    }

    protected void clearAttributeIndexCache() {
        this.attributeIndices.clear();
    }

    @Override
    public List<Attribute> getAttributesUnmodifiable() {
        return Collections.unmodifiableList(this.attributes);
    }

    @Override
    public List<DataRecord> getDataRecordsUnmodifiable() {
        return Collections.unmodifiableList(this.dataRecords);
    }
}

