/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.reaction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openscience.cdk.dict.Dictionary;
import org.openscience.cdk.dict.DictionaryDatabase;
import org.openscience.cdk.dict.EntryReact;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.reaction.IReactionMechanism;
import org.openscience.cdk.reaction.IReactionProcess;
import org.openscience.cdk.reaction.type.parameters.IParameterReact;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class ReactionEngine {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(ReactionEngine.class);
    private Dictionary dictionary;
    public HashMap<String, Object> paramsMap;
    public IReactionMechanism mechanism;
    public List<IParameterReact> paramsMap2;

    public ReactionEngine() {
        try {
            IReactionProcess reaction = (IReactionProcess)((Object)this);
            EntryReact entry = this.initiateDictionary("reaction-processes", reaction);
            this.initiateParameterMap2(entry);
            reaction.setParameterList(this.getParameterList());
            if (entry.getMechanism() != null && !entry.getMechanism().isEmpty()) {
                this.extractMechanism(entry);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void extractMechanism(EntryReact entry) {
        String mechanismName = "org.openscience.cdk.reaction.mechanism." + entry.getMechanism();
        try {
            this.mechanism = (IReactionMechanism)this.getClass().getClassLoader().loadClass(mechanismName).newInstance();
            logger.info("Loaded mechanism: ", mechanismName);
        }
        catch (ClassNotFoundException exception) {
            logger.error("Could not find this IReactionMechanism: ", mechanismName);
            logger.debug(exception);
        }
        catch (IllegalAccessException | InstantiationException exception) {
            logger.error("Could not load this IReactionMechanism: ", mechanismName);
            logger.debug(exception);
        }
    }

    private EntryReact initiateDictionary(String nameDict, IReactionProcess reaction) {
        DictionaryDatabase db = new DictionaryDatabase();
        this.dictionary = db.getDictionary(nameDict);
        String entryString = reaction.getSpecification().getSpecificationReference();
        entryString = entryString.substring(entryString.indexOf(35) + 1, entryString.length());
        return (EntryReact)this.dictionary.getEntry(entryString.toLowerCase());
    }

    private void initiateParameterMap2(EntryReact entry) {
        List<List<String>> paramDic = entry.getParameterClass();
        this.paramsMap2 = new ArrayList<IParameterReact>();
        for (List<String> param : paramDic) {
            String paramName = "org.openscience.cdk.reaction.type.parameters." + param.get(0);
            try {
                IParameterReact ipc = (IParameterReact)this.getClass().getClassLoader().loadClass(paramName).newInstance();
                ipc.setParameter(Boolean.parseBoolean(param.get(1)));
                ipc.setValue(param.get(2));
                logger.info("Loaded parameter class: ", paramName);
                this.paramsMap2.add(ipc);
            }
            catch (ClassNotFoundException exception) {
                logger.error("Could not find this IParameterReact: ", paramName);
                logger.debug(exception);
            }
            catch (IllegalAccessException | InstantiationException exception) {
                logger.error("Could not load this IParameterReact: ", paramName);
                logger.debug(exception);
            }
        }
    }

    public void setParameterList(List<IParameterReact> params) throws CDKException {
        this.paramsMap2 = params;
    }

    public List<IParameterReact> getParameterList() {
        return this.paramsMap2;
    }

    public IParameterReact getParameterClass(Class<?> paramClass) {
        for (IParameterReact ipr : this.paramsMap2) {
            if (!ipr.getClass().equals(paramClass)) continue;
            return ipr;
        }
        return null;
    }
}

