/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.modeling.builder3d;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import javax.vecmath.Point3d;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.io.iterator.IteratingSDFReader;
import org.openscience.cdk.isomorphism.Mappings;
import org.openscience.cdk.isomorphism.Pattern;
import org.openscience.cdk.isomorphism.UniversalIsomorphismTester;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainerCreator;
import org.openscience.cdk.silent.SilentChemObjectBuilder;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.RingSetManipulator;

public class TemplateHandler3D {
    private static final IChemObjectBuilder builder = SilentChemObjectBuilder.getInstance();
    public static final String TEMPLATE_PATH = "data/ringTemplateStructures.sdf.gz";
    private final List<IAtomContainer> templates = new ArrayList<IAtomContainer>();
    private final List<IQueryAtomContainer> queries = new ArrayList<IQueryAtomContainer>();
    private final List<Pattern> patterns = new ArrayList<Pattern>();
    private static TemplateHandler3D self = null;
    private final ILoggingTool logger = LoggingToolFactory.createLoggingTool(TemplateHandler3D.class);
    private UniversalIsomorphismTester universalIsomorphismTester = new UniversalIsomorphismTester();

    private TemplateHandler3D() {
    }

    public static TemplateHandler3D getInstance() throws CDKException {
        if (self == null) {
            self = new TemplateHandler3D();
        }
        return self;
    }

    private void addTemplateMol(IAtomContainer mol) {
        this.templates.add(mol);
        QueryAtomContainer query2 = QueryAtomContainerCreator.createAnyAtomAnyBondContainer(mol, false);
        this.queries.add(query2);
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            query2.getAtom(i).setPoint3d(new Point3d(mol.getAtom(i).getPoint3d()));
        }
        this.patterns.add(Pattern.findSubstructure(query2));
    }

    private void loadTemplates() throws CDKException {
        try (InputStream gin = this.getClass().getResourceAsStream(TEMPLATE_PATH);
             GZIPInputStream in = new GZIPInputStream(gin);
             IteratingSDFReader sdfr = new IteratingSDFReader(in, builder);){
            while (sdfr.hasNext()) {
                IAtomContainer mol = sdfr.next();
                this.addTemplateMol(mol);
            }
        }
        catch (IOException e) {
            throw new CDKException("Could not load ring templates", e);
        }
    }

    public static BitSet getBitSetFromFile(StringTokenizer st) throws Exception {
        BitSet bitSet = new BitSet(1024);
        while (st.hasMoreTokens()) {
            bitSet.set(Integer.parseInt(st.nextToken()));
        }
        return bitSet;
    }

    public IRingSet getLargestRingSet(List<IRingSet> ringSystems) {
        IRingSet largestRingSet = null;
        int atomNumber = 0;
        IAtomContainer container = null;
        for (int i = 0; i < ringSystems.size(); ++i) {
            container = this.getAllInOneContainer(ringSystems.get(i));
            if (atomNumber >= container.getAtomCount()) continue;
            atomNumber = container.getAtomCount();
            largestRingSet = ringSystems.get(i);
        }
        return largestRingSet;
    }

    private IAtomContainer getAllInOneContainer(IRingSet ringSet) {
        IAtomContainer resultContainer = ringSet.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        Iterator<IAtomContainer> containers = RingSetManipulator.getAllAtomContainers(ringSet).iterator();
        while (containers.hasNext()) {
            resultContainer.add(containers.next());
        }
        return resultContainer;
    }

    @Deprecated
    public void mapTemplates(IAtomContainer ringSystems, double numberOfRingAtoms) throws CDKException, CloneNotSupportedException {
        this.mapTemplates(ringSystems, (int)numberOfRingAtoms);
    }

    private boolean isExactMatch(IAtomContainer query2, Map<IChemObject, IChemObject> mapping) {
        IChemObject dst;
        for (IAtom iAtom : query2.atoms()) {
            dst = (IAtom)mapping.get(iAtom);
            if (Objects.equals(iAtom.getSymbol(), dst.getSymbol())) continue;
            return false;
        }
        for (IBond iBond : query2.bonds()) {
            dst = (IBond)mapping.get(iBond);
            if (Objects.equals((Object)iBond.getOrder(), (Object)dst.getOrder())) continue;
            return false;
        }
        return true;
    }

    public void mapTemplates(IAtomContainer mol, int numberOfRingAtoms) throws CDKException, CloneNotSupportedException {
        if (this.templates.isEmpty()) {
            this.loadTemplates();
        }
        IAtomContainer best = null;
        HashMap<IChemObject, IChemObject> bestMap = null;
        IAtomContainer secondBest = null;
        HashMap<IChemObject, IChemObject> secondBestMap = null;
        for (int i = 0; i < this.templates.size(); ++i) {
            IAtomContainer query2 = this.queries.get(i);
            if (query2.getAtomCount() != mol.getAtomCount()) continue;
            Mappings mappings = this.patterns.get(i).matchAll(mol);
            for (Map<IChemObject, IChemObject> map : mappings.toAtomBondMap()) {
                if (this.isExactMatch(query2, map)) {
                    this.assignCoords(query2, map);
                    return;
                }
                if (query2.getBondCount() == mol.getBondCount()) {
                    best = query2;
                    bestMap = new HashMap<IChemObject, IChemObject>(map);
                    continue;
                }
                secondBest = query2;
                secondBestMap = new HashMap<IChemObject, IChemObject>(map);
            }
        }
        if (best != null) {
            this.assignCoords(best, bestMap);
        } else if (secondBest != null) {
            this.assignCoords(secondBest, secondBestMap);
        } else {
            this.logger.warn("Maybe RingTemplateError!");
        }
    }

    private void assignCoords(IAtomContainer template, Map<IChemObject, IChemObject> map) {
        for (IAtom src : template.atoms()) {
            IAtom dst = (IAtom)map.get(src);
            dst.setPoint3d(new Point3d(src.getPoint3d()));
        }
    }

    public int getTemplateCount() {
        return this.templates.size();
    }

    public IAtomContainer getTemplateAt(int position) {
        return this.templates.get(position);
    }
}

