/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.formats;

import org.openscience.cdk.io.formats.IChemFormatMatcher;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.SimpleChemFormatMatcher;

public class CIFFormat
extends SimpleChemFormatMatcher
implements IChemFormatMatcher {
    private static IResourceFormat myself = null;

    public static IResourceFormat getInstance() {
        if (myself == null) {
            myself = new CIFFormat();
        }
        return myself;
    }

    @Override
    public String getFormatName() {
        return "Crystallographic Interchange Format";
    }

    @Override
    public String getMIMEType() {
        return "chemical/x-cif";
    }

    @Override
    public String getPreferredNameExtension() {
        return this.getNameExtensions()[0];
    }

    @Override
    public String[] getNameExtensions() {
        return new String[]{"cif"};
    }

    @Override
    public String getReaderClassName() {
        return "org.openscience.cdk.io.CIFReader";
    }

    @Override
    public String getWriterClassName() {
        return null;
    }

    @Override
    public boolean matches(int lineNumber, String line) {
        return line.startsWith("_cell_length_a") || line.startsWith("_audit_creation_date") || line.startsWith("loop_");
    }

    @Override
    public boolean isXMLBased() {
        return false;
    }

    @Override
    public int getSupportedDataFeatures() {
        return 0;
    }

    @Override
    public int getRequiredDataFeatures() {
        return 0;
    }
}

