/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.io.IOException;
import java.util.Vector;
import org.freehep.graphicsio.CubicToQuadPathConstructor;
import org.freehep.graphicsio.swf.SWFConstants;
import org.freehep.graphicsio.swf.SWFShape;

public class SWFPathConstructor
extends CubicToQuadPathConstructor
implements SWFConstants {
    private Vector<SWFShape.Record> path;
    private int x0;
    private int y0;
    private int xc;
    private int yc;
    private int stroke;
    private int fill0;
    private int fill1;

    public SWFPathConstructor(Vector<SWFShape.Record> path, int stroke, int fill0, int fill1) {
        this(path, stroke, fill0, fill1, 0.025);
    }

    public SWFPathConstructor(Vector<SWFShape.Record> path, int stroke, int fill0, int fill1, double resolution) {
        super(resolution);
        this.path = path;
        this.stroke = stroke;
        this.fill0 = fill0;
        this.fill1 = fill1;
    }

    public void move(double x, double y) throws IOException {
        this.x0 = this.toInt(x);
        this.y0 = this.toInt(y);
        this.xc = this.x0;
        this.yc = this.y0;
        this.path.add(new SWFShape.ShapeRecord(true, this.xc, this.yc, this.fill0, this.fill1, this.stroke));
        super.move(x, y);
    }

    public void line(double x, double y) throws IOException {
        int dx = this.toInt(x) - this.xc;
        int dy = this.toInt(y) - this.yc;
        this.path.add(new SWFShape.EdgeRecord(dx, dy));
        this.xc += dx;
        this.yc += dy;
        super.line(x, y);
    }

    public void quad(double x1, double y1, double x2, double y2) throws IOException {
        int cdx = this.toInt(x1) - this.xc;
        int cdy = this.toInt(y1) - this.yc;
        int dx = this.toInt(x2 - x1);
        int dy = this.toInt(y2 - y1);
        this.path.add(new SWFShape.EdgeRecord(cdx, cdy, dx, dy));
        this.xc += dx + cdx;
        this.yc += dy + cdy;
        this.currentX = x2;
        this.currentY = y2;
    }

    public void closePath(double xd0, double yd0) throws IOException {
        if (this.xc != this.x0 || this.yc != this.y0) {
            this.path.add(new SWFShape.EdgeRecord(this.x0 - this.xc, this.y0 - this.yc));
        }
        super.closePath(xd0, yd0);
    }

    private int toInt(double d) {
        return (int)(d * 20.0);
    }
}

