## ------------------------------------------------------------------------
knitr::opts_chunk$set(fig.width=8, fig.height=4)

## ------------------------------------------------------------------------
library(photobiology)
library(photobiologyWavebands)
library(photobiologyLEDs)
library(ggplot2)
library(ggspectra)

## ------------------------------------------------------------------------
blue_leds

## ------------------------------------------------------------------------
led_engin

## ------------------------------------------------------------------------
names(leds.mspct)

## ------------------------------------------------------------------------
leds.mspct$UV395

## ------------------------------------------------------------------------
leds.mspct[["UV395"]]

## ------------------------------------------------------------------------
leds.mspct["UV395"]

## ------------------------------------------------------------------------
leds.mspct[norlux]

## ------------------------------------------------------------------------
leds.mspct[grep("QDDH", names(leds.mspct))]

## ------------------------------------------------------------------------
leds.mspct$LZ1_10R302

## ------------------------------------------------------------------------
getWhatMeasured(leds.mspct$LZ1_10R302)
getWhenMeasured(leds.mspct$LZ1_10R302)

## ------------------------------------------------------------------------
getInstrDesc(leds.mspct$LZ1_10R302)

## ------------------------------------------------------------------------
getInstrSettings(leds.mspct$LZ1_10R302)

## ------------------------------------------------------------------------
is_normalized(leds.mspct$LZ1_10R302)

## ------------------------------------------------------------------------
leds.mspct$UVMAX305

## ------------------------------------------------------------------------
is_normalized(leds.mspct$UVMAX305)

## ------------------------------------------------------------------------
my.spct <- fscale(leds.mspct$UV395,
                  range = c(315, 400),
                  e_irrad,
                  target = 10
                  )
e_irrad(my.spct, waveband(c(315,400)))

## ------------------------------------------------------------------------
getScaled(my.spct)
setScaled(my.spct)
getScaled(my.spct)

## ------------------------------------------------------------------------
my.UV395 <- leds.mspct$UV395
setNormalized(my.UV395)
e_irrad(my.UV395)

## ------------------------------------------------------------------------
q_ratio(leds.mspct$UV395, UVB(), UVA())

## ------------------------------------------------------------------------
plot(leds.mspct$LZ1_10R302)

## ------------------------------------------------------------------------
ggplot(leds.mspct$LZ1_10R302) +
  geom_line()

## ------------------------------------------------------------------------
head(as.data.frame(leds.mspct$UV395))

## ------------------------------------------------------------------------
attach(leds.mspct)
q_ratio(UV395, UVB(), UVA())
detach(leds.mspct)

## ------------------------------------------------------------------------
attach(leds.mspct)
with(UV395, max(w.length))
detach(leds.mspct)

## ------------------------------------------------------------------------
with(leds.mspct, q_ratio(UV395, UVB(), UVA()))

