/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.opres.graph;

import choco.kernel.common.opres.graph.IBinaryNode;
import choco.kernel.common.opres.graph.INodeLabel;
import choco.kernel.common.opres.graph.ITree;
import choco.kernel.common.opres.graph.InternalNode;
import choco.kernel.common.opres.graph.Leaf;
import choco.kernel.common.util.tools.MathUtils;

public class ProperBinaryTree
implements ITree {
    private int nodeCount = 0;
    private IBinaryNode root;
    private int nbLeafs = 0;
    private int depth = -1;

    protected void setRoot(IBinaryNode node) {
        node.setFather(null);
        this.root = node;
    }

    @Override
    public int getNbInternalNodes() {
        return this.getNbLeaves() - 1;
    }

    @Override
    public final int getNbLeaves() {
        return this.nbLeafs;
    }

    @Override
    public final int getDepth() {
        return this.depth;
    }

    public IBinaryNode insert(INodeLabel leafStatus, INodeLabel internalStatus, boolean fireChanged) {
        Leaf leaf = new Leaf(this.nodeCount++, leafStatus);
        if (this.root == null) {
            this.setRoot(leaf);
            this.depth = 0;
        } else {
            int cpt = this.nbLeafs;
            int icpt = 1 << this.depth;
            IBinaryNode subtree = this.root;
            while (!MathUtils.isPowerOfTwo(cpt)) {
                while (icpt > cpt) {
                    icpt >>= 1;
                }
                cpt -= icpt;
                subtree = subtree.getRightChild();
            }
            InternalNode internal = new InternalNode(this.nodeCount++, internalStatus);
            if (subtree.hasFather()) {
                subtree.getFather().setRightChild(internal);
            } else {
                this.setRoot(internal);
                ++this.depth;
            }
            internal.setLeftChild(subtree);
            internal.setRightChild(leaf);
        }
        ++this.nbLeafs;
        if (fireChanged) {
            leaf.fireStatusChanged();
        }
        return leaf;
    }

    protected boolean isLeftOrRight(IBinaryNode node) {
        if (node.hasFather()) {
            if (node.getFather().getLeftChild() == node) {
                return true;
            }
            if (node.getFather().getRightChild() == node) {
                return false;
            }
        }
        throw new UnsupportedOperationException("root node or inconsistent data structure");
    }

    public void removeLast(boolean fireChanged) {
        if (this.root.isLeaf()) {
            this.root.clear();
            this.root = null;
            this.depth = -1;
        } else {
            IBinaryNode last = this.root;
            while (!last.isLeaf()) {
                last = last.getRightChild();
            }
            IBinaryNode irm = last.getFather();
            if (irm.hasFather()) {
                IBinaryNode grandfather = irm.getFather();
                grandfather.setRightChild(irm.getLeftChild());
                if (fireChanged) {
                    grandfather.getRightChild().fireStatusChanged();
                }
            } else {
                this.setRoot(irm.getLeftChild());
                --this.depth;
            }
            last.clear();
            irm.clear();
        }
        --this.nbLeafs;
    }

    public void remove(IBinaryNode leaf, boolean fireChanged) {
        if (leaf.isLeaf()) {
            if (leaf.equals(this.root)) {
                this.root = null;
                this.depth = -1;
            } else {
                IBinaryNode lroot = leaf;
                while (lroot.hasFather()) {
                    lroot = lroot.getFather();
                }
                if (lroot.equals(this.root)) {
                    IBinaryNode last = this.root;
                    while (!last.isLeaf()) {
                        last = last.getRightChild();
                    }
                    IBinaryNode irm = last.getFather();
                    if (!last.equals(leaf)) {
                        if (this.isLeftOrRight(leaf)) {
                            leaf.getFather().setLeftChild(last);
                        } else {
                            leaf.getFather().setRightChild(last);
                        }
                        if (fireChanged) {
                            last.fireStatusChanged();
                        }
                    }
                    if (irm.hasFather()) {
                        IBinaryNode grandfather = irm.getFather();
                        grandfather.setRightChild(irm.getLeftChild());
                        if (fireChanged) {
                            grandfather.getRightChild().fireStatusChanged();
                        }
                    } else {
                        this.setRoot(irm.getLeftChild());
                        --this.depth;
                    }
                    irm.clear();
                } else {
                    throw new UnsupportedOperationException("can't remove: the leaf does not belong to the tree..");
                }
            }
            leaf.clear();
            --this.nbLeafs;
        } else {
            throw new UnsupportedOperationException("cant remove an internal node from a proper binary tree.");
        }
    }

    protected void fireTreeChanged(IBinaryNode node) {
        if (!node.isLeaf()) {
            this.fireTreeChanged(node.getLeftChild());
            this.fireTreeChanged(node.getRightChild());
            node.getNodeStatus().updateInternalNode(node);
        }
    }

    public void fireTreeChanged() {
        if (this.root != null) {
            this.fireTreeChanged(this.root);
        }
    }

    public final IBinaryNode getRoot() {
        return this.root;
    }
}

