/*
 * Decompiled with CFR 0.152.
 */
package org.ecdc.epitweetr.alert;

import demy.mllib.linalg.implicits$;
import demy.storage.Storage;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.spark.ml.classification.ClassificationModel;
import org.apache.spark.ml.classification.Classifier;
import org.apache.spark.ml.classification.OneVsRest;
import org.apache.spark.ml.classification.OneVsRestModel;
import org.apache.spark.ml.classification.OneVsRestModel$;
import org.apache.spark.ml.evaluation.MulticlassClassificationEvaluator;
import org.apache.spark.ml.feature.IndexToString;
import org.apache.spark.ml.feature.StringIndexer;
import org.apache.spark.ml.feature.StringIndexerModel;
import org.apache.spark.ml.feature.StringIndexerModel$;
import org.apache.spark.ml.feature.VectorAssembler;
import org.apache.spark.ml.param.Param;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.ecdc.epitweetr.Settings;
import org.ecdc.epitweetr.alert.AlertActor$;
import org.ecdc.epitweetr.fs.AlertRun;
import org.ecdc.epitweetr.fs.TaggedAlert;
import org.ecdc.twitter.Language;
import org.ecdc.twitter.Language$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple9;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayOps;
import scala.math.Integral;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.Random;
import scala.util.Try$;

public final class AlertActor$ {
    public static AlertActor$ MODULE$;

    static {
        new AlertActor$();
    }

    public <F, E extends Classifier<F, E, M>, M extends ClassificationModel<F, M>> OneVsRest getModel(AlertRun run) {
        Classifier classifier = (Classifier)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Classifier)Class.forName(new StringBuilder(35).append("org.apache.spark.ml.classification.").append(run.models()).toString()).getConstructor(new Class[0]).newInstance(new Object[0])).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new Exception(new StringBuilder(215).append("Cannot create an alert classifier for class org.apache.spark.ml.classification.").append(run.models()).append(". The selected class must inherit from https://spark.apache.org/docs/latest/api/scala/org/apache/spark/ml/classification/Classifier.html").toString());
        });
        Tuple4[] params = (Tuple4[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])classifier.params())).map((Function1 & Serializable & scala.Serializable)p -> {
            String string = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])p.getClass().getName().split("\\."))).last();
            String string2 = "Param".equals(string) ? "String" : string;
            return new Tuple4((Object)p.name(), (Object)string2.replaceAll("Param", ""), classifier.hasDefault(p) ? classifier.getDefault(p) : "", (Object)p.doc());
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple4.class)));
        run.custom_parameters().map((Function1 & Serializable & scala.Serializable)p -> {
            p.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                AlertActor$.$anonfun$getModel$5(classifier$1, params$1, run$1, x0$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        return new OneVsRest().setClassifier(classifier).setFeaturesCol("features").setLabelCol("category_vector").setPredictionCol("predicted_vector");
    }

    public String classificationPath(Settings conf) {
        return new StringBuilder(9).append(conf.epiHome()).append("/alert-ml").toString();
    }

    public String labelIndexerPath(Settings conf) {
        return new StringBuilder(17).append(this.classificationPath(conf)).append("/label-indexer.ml").toString();
    }

    public String alertClassifierPath(Settings conf) {
        return new StringBuilder(14).append(this.classificationPath(conf)).append("/classifier.ml").toString();
    }

    public void ensureFolderExists(Settings conf) {
        Product st = conf.getSparkStorage();
        ((Storage)st).ensurePathExists(this.classificationPath(conf));
    }

    public StringIndexerModel getLabelIndexer(Settings conf) {
        return StringIndexerModel$.MODULE$.load(this.labelIndexerPath(conf));
    }

    public OneVsRestModel getAlertClassifier(Settings conf) {
        Product storage = conf.getSparkStorage();
        if (!((Storage)storage).getNode(this.alertClassifierPath(conf), ((Storage)storage).getNode$default$2()).exists()) {
            throw new Exception("Cannot find alert classification model. Please train alerts");
        }
        return OneVsRestModel$.MODULE$.load(this.alertClassifierPath(conf));
    }

    public StringIndexerModel fitLabelIndexer(Seq<TaggedAlert> alerts, Settings conf) {
        SparkSession spark = conf.getSparkSession();
        Product storage = conf.getSparkStorage();
        this.ensureFolderExists(conf);
        Predef$.MODULE$.assert(((SeqLike)((SeqLike)alerts.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.given_category(), Seq$.MODULE$.canBuildFrom())).distinct()).size() > 1);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_ecdc_epitweetr_alert_AlertActor$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.ecdc.epitweetr.fs.TaggedAlert").asType().toTypeConstructor();
            }

            public Org_ecdc_epitweetr_alert_AlertActor$$typecreator5$1() {
            }
        }
        new StringIndexer().setInputCol("given_category").setOutputCol("category_vector").setHandleInvalid("keep").fit(spark.implicits().localSeqToDatasetHolder(alerts, spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_ecdc_epitweetr_alert_AlertActor$$typecreator5$1()))).toDS()).write().overwrite().save(this.labelIndexerPath(conf));
        return this.getLabelIndexer(conf);
    }

    public OneVsRestModel finalTrain(Dataset<Row> alertsdf, AlertRun run, Settings conf) {
        Random r = new Random(20121205);
        OneVsRest model = this.getModel(run);
        this.ensureFolderExists(conf);
        model.fit(alertsdf.where(functions$.MODULE$.col("given_category").$eq$bang$eq((Object)functions$.MODULE$.lit((Object)"?")))).write().overwrite().save(this.alertClassifierPath(conf));
        return this.getAlertClassifier(conf);
    }

    public Seq<TaggedAlert> classifyAlerts(Seq<TaggedAlert> alerts, Settings conf) {
        Dataset<Row> df = this.alerts2modeldf(alerts, true, conf);
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.classifyAlerts(df, conf).collect())).toSeq();
    }

    public Dataset<TaggedAlert> classifyAlerts(Dataset<Row> alertdf, Settings conf) {
        SparkSession spark = conf.getSparkSession();
        OneVsRestModel model = this.getAlertClassifier(conf);
        Dataset predicted = model.transform(alertdf);
        StringIndexerModel labelIndexer = this.getLabelIndexer(conf);
        IndexToString labelConverter = new IndexToString().setInputCol("predicted_vector").setOutputCol("epitweetr_category").setLabels(labelIndexer.labelsArray()[0]);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_ecdc_epitweetr_alert_AlertActor$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.ecdc.epitweetr.fs.TaggedAlert").asType().toTypeConstructor();
            }

            public Org_ecdc_epitweetr_alert_AlertActor$$typecreator4$1() {
            }
        }
        return labelConverter.transform(predicted).select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"date", "topic", "country", "number_of_tweets", "topwords", "toptweets", "given_category", "epitweetr_category"})).as(spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_ecdc_epitweetr_alert_AlertActor$$typecreator4$1())));
    }

    public AlertRun trainTest(Dataset<Row> alertsdf, AlertRun run, double trainRatio, Settings conf) {
        Random r = new Random(20121205);
        Dataset joinedPredictions = (Dataset)((TraversableOnce)((TraversableLike)((TraversableLike)Seq$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)run.runs()), (Integral)Numeric.IntIsIntegral$.MODULE$)).map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)i -> r.nextLong(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)seed -> AlertActor$.$anonfun$trainTest$2(alertsdf, trainRatio, run, BoxesRunTime.unboxToLong((Object)seed)), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$4, x$5) -> x$4.union(x$5));
        MulticlassClassificationEvaluator evaluator = new MulticlassClassificationEvaluator().setLabelCol("category_vector").setPredictionCol("predicted_vector");
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date now = new Date();
        return new AlertRun(0, run.models(), (Option<Object>)None$.MODULE$, run.runs(), evaluator.setMetricName("f1").evaluate(joinedPredictions), evaluator.setMetricName("accuracy").evaluate(joinedPredictions), evaluator.setMetricName("precisionByLabel").evaluate(joinedPredictions), evaluator.setMetricName("recallByLabel").evaluate(joinedPredictions), evaluator.setMetricName("fMeasureByLabel").evaluate(joinedPredictions), (Option<String>)new Some((Object)sdfDate.format(now)), run.active(), run.documentation(), run.custom_parameters());
    }

    public Dataset<Row> alerts2modeldf(Seq<TaggedAlert> alerts, boolean reuseLabels, Settings conf) {
        public final class Org_ecdc_epitweetr_alert_AlertActor$$typecreator11$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple10"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $m.staticClass("scala.Int").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "Map"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)), (List)Nil$.MODULE$))), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), $m.staticClass("scala.Double").asType().toTypeConstructor()})));
            }

            public Org_ecdc_epitweetr_alert_AlertActor$$typecreator11$1() {
            }
        }
        SparkSession spark = conf.getSparkSession();
        Product storage = conf.getSparkStorage();
        StringIndexerModel indexer = reuseLabels ? this.getLabelIndexer(conf) : this.fitLabelIndexer(alerts, conf);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        return ((Dataset)new Some(alerts).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Seq seq = x0$1;
            Tuple2 tuple2 = new Tuple2((Object)seq, seq.map((Function1 & Serializable & scala.Serializable)ta -> (String)((TraversableOnce)ta.toptweets().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String lang = (String)tuple2._1();
                Seq tweets = (Seq)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)lang, (Object)BoxesRunTime.boxToInteger((int)tweets.size()));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom())).reduceOption((Function2 & Serializable & scala.Serializable)(p1, p2) -> {
                int count1;
                Tuple2 tuple2;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = new Tuple2(p1, p2);
                        if (tuple22 == null) break block2;
                        Tuple2 tuple23 = (Tuple2)tuple22._1();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple23 == null) break block2;
                        count1 = tuple23._2$mcI$sp();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                int count2 = tuple2._2$mcI$sp();
                Tuple2 tuple24 = count1 > count2 ? p1 : p2;
                return tuple24;
            }).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                String lang;
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String string = lang = (String)tuple2._1();
                return string;
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> "en"), Seq$.MODULE$.canBuildFrom()));
            return tuple2;
        }).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            public final class Org_ecdc_epitweetr_alert_AlertActor$$typecreator5$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple9"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $m.staticClass("scala.Int").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "Map"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)), (List)Nil$.MODULE$))), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$))})));
                }

                public Org_ecdc_epitweetr_alert_AlertActor$$typecreator5$2() {
                }
            }
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq alerts = (Seq)tuple2._1();
            Seq topwordlangs = (Seq)tuple2._2();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MODULE$.getClass().getClassLoader());
            Dataset dataset = spark.implicits().localSeqToDatasetHolder((Seq)((TraversableLike)alerts.zip((GenIterable)topwordlangs, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$5 -> {
                String twlang;
                TaggedAlert taggedAlert;
                block3: {
                    Tuple2 tuple2;
                    block2: {
                        tuple2 = x0$5;
                        if (tuple2 == null) break block2;
                        taggedAlert = (TaggedAlert)tuple2._1();
                        twlang = (String)tuple2._2();
                        if (taggedAlert != null) break block3;
                    }
                    throw new MatchError((Object)tuple2);
                }
                String id = taggedAlert.id();
                String date = taggedAlert.date();
                String topic = taggedAlert.topic();
                String country = taggedAlert.country();
                int number_of_tweets = taggedAlert.number_of_tweets();
                Option<String> topwords = taggedAlert.topwords();
                Map<String, Seq<String>> toptweets = taggedAlert.toptweets();
                Option<String> given_category = taggedAlert.given_category();
                Tuple9 tuple9 = new Tuple9((Object)id, (Object)date, (Object)topic, (Object)country, (Object)BoxesRunTime.boxToInteger((int)number_of_tweets), topwords, (Object)twlang, toptweets, (Object)given_category.orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)"?")));
                return tuple9;
            }, Seq$.MODULE$.canBuildFrom()), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_ecdc_epitweetr_alert_AlertActor$$typecreator5$2()))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "date", "topic", "country", "number_of_tweets", "topwords", "twlang", "toptweets", "given_category"}));
            return dataset;
        }).map((Function1 & Serializable & scala.Serializable)df -> {
            Vector langs = (Vector)((TraversableLike)conf.languages().get()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.code(), Vector$.MODULE$.canBuildFrom());
            Seq baseCols = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "date", "topic", "country", "number_of_tweets", "topwords", "twlang", "given_category", "toptweets"}));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MODULE$.getClass().getClassLoader());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(MODULE$.getClass().getClassLoader());
            public final class Org_ecdc_epitweetr_alert_AlertActor$$typecreator9$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_ecdc_epitweetr_alert_AlertActor$$typecreator9$1() {
                }
            }
            public final class Org_ecdc_epitweetr_alert_AlertActor$$typecreator10$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.sql.Row").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                }

                public Org_ecdc_epitweetr_alert_AlertActor$$typecreator10$1() {
                }
            }
            return Language$.MODULE$.LangTools(df.select((Seq)((TraversableLike)((TraversableLike)((TraversableLike)baseCols.map((Function1 & Serializable & scala.Serializable)c -> functions$.MODULE$.col(c), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)functions$.MODULE$.lit((Object)"en").as("topic_lang"), (List)new .colon.colon((Object)functions$.MODULE$.lit((Object)"en").as("country_lang"), (List)Nil$.MODULE$)), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)langs.map((Function1 & Serializable & scala.Serializable)lang -> functions$.MODULE$.array_join(functions$.MODULE$.col("toptweets").getItem(lang), "\n").as(new StringBuilder(4).append("top_").append((String)lang).toString()), Vector$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)langs.map((Function1 & Serializable & scala.Serializable)lang -> functions$.MODULE$.lit(lang).as(new StringBuilder(8).append("toplang_").append((String)lang).toString()), Vector$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom()))).vectorize((Seq<Language>)((Seq)conf.languages().get()), true, conf.langIndexPath(), (Map<String, Option<String>>)((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)new Some((Object)"topic_lang")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"country"), (Object)new Some((Object)"country_lang")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topwords"), (Object)new Some((Object)"twlang"))}))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)langs.map((Function1 & Serializable & scala.Serializable)lang -> new Tuple2((Object)new StringBuilder(4).append("top_").append((String)lang).toString(), (Object)new Some((Object)new StringBuilder(8).append("toplang_").append((String)lang).toString())), Vector$.MODULE$.canBuildFrom()))), conf.splitter(), (Storage)storage).select((Seq)((TraversableLike)baseCols.map((Function1 & Serializable & scala.Serializable)c -> functions$.MODULE$.col(c), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)row -> (org.apache.spark.ml.linalg.Vector)((TraversableOnce)row.map((Function1 & Serializable & scala.Serializable)vectors -> (org.apache.spark.ml.linalg.Vector)vectors.getAs(0), Seq$.MODULE$.canBuildFrom())).reduceOption((Function2 & Serializable & scala.Serializable)(x$7, x$8) -> implicits$.MODULE$.VectorUtil((org.apache.spark.ml.linalg.Vector)x$7).sum((org.apache.spark.ml.linalg.Vector)x$8)).getOrElse((Function0 & Serializable & scala.Serializable)() -> null), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_ecdc_epitweetr_alert_AlertActor$$typecreator9$1()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_ecdc_epitweetr_alert_AlertActor$$typecreator10$1())).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.concat((Seq)((TraversableLike)((TraversableLike)new .colon.colon((Object)"topic_vec", (List)new .colon.colon((Object)"country_vec", (List)new .colon.colon((Object)"topwords_vec", (List)Nil$.MODULE$)))).$plus$plus((GenTraversableOnce)langs.map((Function1 & Serializable & scala.Serializable)lang -> new StringBuilder(8).append("top_").append((String)lang).append("_vec").toString(), Vector$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)c -> functions$.MODULE$.col(c), Seq$.MODULE$.canBuildFrom()))})).as("word_vec"), (List)new .colon.colon((Object)functions$.MODULE$.udf((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)count -> 1.0 - Math.pow(Math.E, -1.0 * (double)count / 1000.0), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int()).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("number_of_tweets")})).as("adjusted_count"), (List)Nil$.MODULE$)), Seq$.MODULE$.canBuildFrom()));
        }).map((Function1 & Serializable & scala.Serializable)df -> indexer.transform(df)).map((Function1 & Serializable & scala.Serializable)df -> new VectorAssembler().setInputCols((String[])((Object[])new String[]{"word_vec", "adjusted_count"})).setOutputCol("features").transform(df)).get()).select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"date", "topic", "country", "number_of_tweets", "topwords", "toptweets", "given_category", "features", "category_vector"})).as(spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_ecdc_epitweetr_alert_AlertActor$$typecreator11$1()))).toDF();
    }

    public static final /* synthetic */ boolean $anonfun$getModel$9(String name$1, Tuple4 x$1) {
        Object object = x$1._1();
        String string = name$1;
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static final /* synthetic */ void $anonfun$getModel$5(Classifier classifier$1, Tuple4[] params$1, AlertRun run$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            String strVal = (String)tuple2._2();
            if (classifier$1.hasParam(name)) {
                Param param = classifier$1.getParam(name);
                if (!(param.getClass().getName().endsWith("DoubleParam") && Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Classifier)classifier$1.set(param, (Object)BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(strVal)).toDouble()))).isSuccess() || param.getClass().getName().endsWith("IntParam") && Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Classifier)classifier$1.set(param, (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(strVal)).toInt()))).isSuccess() || param.getClass().getName().endsWith("param.Param") && Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Classifier)classifier$1.set(param, (Object)strVal)).isSuccess())) {
                    throw new Exception(new StringBuilder(58).append("Could not set the value ").append(strVal).append(" to parameter ").append(name).append(". This is the doc\n: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])params$1)).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AlertActor$.$anonfun$getModel$9(name, x$1))))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple4 tuple4 = x0$2;
                        if (tuple4 == null) {
                            throw new MatchError((Object)tuple4);
                        }
                        String name = (String)tuple4._1();
                        String dtype = (String)tuple4._2();
                        Object object = tuple4._3();
                        String doc = (String)tuple4._4();
                        String string = new StringBuilder(5).append(name).append("[").append(dtype).append("](").append(object).append("):").append(doc).toString();
                        return string;
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",")).toString());
                }
            } else {
                throw new Exception(new StringBuilder(64).append("Model ").append(run$1.models()).append(" does not contains a parameter ").append(name).append(", available parameters are ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])params$1)).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    Tuple4 tuple4 = x0$3;
                    if (tuple4 == null) {
                        throw new MatchError((Object)tuple4);
                    }
                    String name = (String)tuple4._1();
                    String dtype = (String)tuple4._2();
                    Object object = tuple4._3();
                    String string = new StringBuilder(4).append(name).append("[").append(dtype).append("](").append(object).append(")").toString();
                    return string;
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(", ")).toString());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Dataset $anonfun$trainTest$2(Dataset alertsdf$2, double trainRatio$1, AlertRun run$2, long seed) {
        Dataset[] datasetArray = alertsdf$2.randomSplit(new double[]{trainRatio$1, 1.0 - trainRatio$1}, seed);
        Option option = Array$.MODULE$.unapplySeq((Object)datasetArray);
        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) {
            throw new MatchError((Object)datasetArray);
        }
        Dataset training = (Dataset)((SeqLike)option.get()).apply(0);
        Dataset test = (Dataset)((SeqLike)option.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)training, (Object)test);
        Tuple2 tuple22 = tuple2;
        Dataset training2 = (Dataset)tuple22._1();
        Dataset test2 = (Dataset)tuple22._2();
        OneVsRest model = MODULE$.getModel(run$2);
        OneVsRestModel m = model.fit(training2.where(functions$.MODULE$.col("given_category").$eq$bang$eq((Object)functions$.MODULE$.lit((Object)"?"))));
        return m.transform(test2);
    }

    private AlertActor$() {
        MODULE$ = this;
    }
}

