/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.NNEP_Common.initiators;

import keel.Algorithms.Neural_Networks.NNEP_Common.INeuralNetSpecies;
import keel.Algorithms.Neural_Networks.NNEP_Common.initiators.IInitiator;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.ILayer;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.INeuron;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.InputLayer;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.Link;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.LinkedLayer;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.LinkedNeuron;
import net.sf.jclec.IIndividual;
import net.sf.jclec.IPopulation;
import net.sf.jclec.ISpecies;
import net.sf.jclec.ISystem;
import net.sf.jclec.util.random.IRandGen;

public abstract class PureLayerInitiator
implements IInitiator {
    protected IPopulation<? extends IIndividual> context;
    protected INeuralNetSpecies<? extends IIndividual> species;
    protected IRandGen randGen;

    @Override
    public void contextualize(ISystem<? extends IIndividual> context) {
        if (!(context instanceof IPopulation)) {
            throw new IllegalArgumentException("This object uses a population as execution context");
        }
        this.context = (IPopulation)context;
        this.randGen = this.context.createRandGen();
        ISpecies<? extends IIndividual> spc = this.context.getSpecies();
        if (!(spc instanceof INeuralNetSpecies)) {
            throw new IllegalStateException("Illegal species in context");
        }
        this.species = (INeuralNetSpecies)spc;
    }

    public void setRandGen(IRandGen randGen) {
        this.randGen = randGen;
    }

    @Override
    public void initiate(LinkedLayer linkedLayer, ILayer<? extends INeuron> previousLayer, int indexLayer, int indexWeightRange) {
        int i;
        if (linkedLayer.getType() == 1) {
            linkedLayer.setMaxnofneurons(this.species.getHiddenLayerMaxNofneurons(indexLayer));
            linkedLayer.setMinnofneurons(this.species.getHiddenLayerMinNofneurons(indexLayer));
            linkedLayer.setInitialmaxnofneurons(this.species.getHiddenLayerInitialMaxNofneurons(indexLayer));
            linkedLayer.setBiased(this.species.isHiddenLayerBiased(indexLayer));
        } else {
            linkedLayer.setMaxnofneurons(this.species.getNOfOutputs());
            linkedLayer.setBiased(this.species.isOutputLayerBiased());
        }
        this.prepareInitiation();
        int nofneurons = linkedLayer.getType() == 2 ? linkedLayer.getMaxnofneurons() : this.randGen.choose(linkedLayer.getMinnofneurons(), linkedLayer.getInitialmaxnofneurons() + 1);
        for (i = 0; i < nofneurons; ++i) {
            LinkedNeuron newNeuron = linkedLayer.obtainNewNeuron();
            if (linkedLayer.getType() == 2) {
                newNeuron.setWeightRange(this.species.getOutputLayerWeightRange(indexWeightRange));
            } else {
                newNeuron.setWeightRange(this.species.getHiddenLayerWeightRange(indexLayer, indexWeightRange));
            }
            Link[] links = this.createLinks(linkedLayer, previousLayer, newNeuron);
            newNeuron.setLinks(links);
            linkedLayer.addNeuron(newNeuron);
        }
        if (!(previousLayer instanceof InputLayer)) {
            for (i = 0; i < previousLayer.getNofneurons(); ++i) {
                int nOfLayerLinks = 0;
                for (int j = 0; j < linkedLayer.getNofneurons(); ++j) {
                    LinkedNeuron layerNeuron = linkedLayer.getNeuron(j);
                    if (layerNeuron.getLinks()[i].isBroken()) continue;
                    ++nOfLayerLinks;
                }
                if (nOfLayerLinks != 0) continue;
                int selectedNeuron = this.randGen.choose(0, linkedLayer.getNofneurons());
                Link[] links = linkedLayer.getNeuron(selectedNeuron).getLinks();
                links[i].setOrigin(previousLayer.getNeuron(i));
                links[i].setTarget(linkedLayer.getNeuron(selectedNeuron));
                links[i].setBroken(false);
            }
        }
        this.initiateWeights(linkedLayer);
    }

    public abstract void prepareInitiation();

    public abstract Link[] createLinks(LinkedLayer var1, ILayer<? extends INeuron> var2, LinkedNeuron var3);

    public abstract void initiateWeights(LinkedLayer var1);
}

