/*
 * Decompiled with CFR 0.152.
 */
package javolution;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.RandomAccess;
import java.util.concurrent.ConcurrentHashMap;
import javolution.Javolution;
import javolution.JavolutionError;
import javolution.util.FastCollection;
import javolution.util.FastList;
import javolution.util.FastMap;
import javolution.util.FastSet;
import javolution.util.FastTable;

final class Perf_Util
extends Javolution
implements Runnable {
    private static final int MAX_COLLECTION_SIZE = 10000;
    private final Object[] _objects = new Object[10000];

    Perf_Util() {
    }

    public void run() throws JavolutionError {
        Perf_Util.println("//////////////////////////////");
        Perf_Util.println("// Package: javolution.util //");
        Perf_Util.println("//////////////////////////////");
        Perf_Util.println("");
        Perf_Util.println("(new)      : The collection is created (using the new keyword), populated, then discarded (throw-away collections).");
        Perf_Util.println("(recycled) : The collection is cleared, populated, then reused (static collections or throw-away collections in PoolContext).");
        Perf_Util.println("");
        for (int i = 0; i < 10000; ++i) {
            this._objects[i] = new Object();
        }
        Perf_Util.println("-- FastTable versus ArrayList -- ");
        Perf_Util.setOutputStream(null);
        this.benchmarkFastTable();
        Perf_Util.setOutputStream(System.out);
        this.benchmarkFastTable();
        Perf_Util.setOutputStream(null);
        this.benchmarkArrayList();
        Perf_Util.setOutputStream(System.out);
        this.benchmarkArrayList();
        Perf_Util.println("-- FastList versus LinkedList -- ");
        Perf_Util.setOutputStream(null);
        this.benchmarkFastList();
        Perf_Util.setOutputStream(System.out);
        this.benchmarkFastList();
        Perf_Util.setOutputStream(null);
        this.benchmarkLinkedList();
        Perf_Util.setOutputStream(System.out);
        this.benchmarkLinkedList();
        Perf_Util.println("");
        Perf_Util.println("-- FastMap versus HashMap  --");
        Perf_Util.setOutputStream(null);
        this.benchmarkFastMap();
        Perf_Util.setOutputStream(System.out);
        this.benchmarkFastMap();
        Perf_Util.setOutputStream(null);
        this.benchmarkHashMap();
        Perf_Util.setOutputStream(System.out);
        this.benchmarkHashMap();
        Perf_Util.setOutputStream(null);
        this.benchmarkLinkedHashMap();
        Perf_Util.setOutputStream(System.out);
        this.benchmarkLinkedHashMap();
        Perf_Util.println("");
        Perf_Util.println("-- FastMap.setShared(true) versus ConcurrentHashMap  --");
        Perf_Util.setOutputStream(null);
        this.benchmarkSharedFastMap();
        Perf_Util.setOutputStream(System.out);
        this.benchmarkSharedFastMap();
        Perf_Util.setOutputStream(null);
        this.benchmarkConcurrentHashMap();
        Perf_Util.setOutputStream(System.out);
        this.benchmarkConcurrentHashMap();
        Perf_Util.println("");
        Perf_Util.println("-- FastSet versus HashSet --");
        Perf_Util.setOutputStream(null);
        this.benchmarkFastSet();
        Perf_Util.setOutputStream(System.out);
        this.benchmarkFastSet();
        Perf_Util.setOutputStream(null);
        this.benchmarkHashSet();
        Perf_Util.setOutputStream(System.out);
        this.benchmarkHashSet();
        Perf_Util.setOutputStream(null);
        this.benchmarkLinkedHashSet();
        Perf_Util.setOutputStream(System.out);
        this.benchmarkLinkedHashSet();
        Perf_Util.println("");
    }

    private void benchmarkFastTable() {
        FastTable<Object> fastTable = new FastTable<Object>();
        Perf_Util.println(fastTable.getClass());
        for (int i = 10; i <= 10000; i *= 10) {
            int n;
            int n2;
            int n3 = 1000000 / i;
            Perf_Util.print("    Size: " + i);
            Perf_Util.print(", add (new): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                fastTable = new FastTable();
                n = 0;
                while (n < i) {
                    fastTable.add(this._objects[n++]);
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i));
            Perf_Util.print(", add (recycled): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                fastTable.clear();
                n = 0;
                while (n < i) {
                    fastTable.add(this._objects[n++]);
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i));
            Perf_Util.print(", iteration (iterator): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3 * 10; ++n2) {
                Iterator iterator = fastTable.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != fastTable) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i * 10));
            if (fastTable instanceof RandomAccess) {
                Perf_Util.print(", get(int): ");
                Perf_Util.startTime();
                for (n2 = 0; n2 < n3 * 10; ++n2) {
                    int n4 = fastTable.size();
                    while (--n4 > 0) {
                        if (fastTable.get(n4) != fastTable) continue;
                        throw new Error();
                    }
                }
                Perf_Util.print(Perf_Util.endTime(n3 * i * 10));
            }
            Perf_Util.println("");
        }
        Perf_Util.println("");
    }

    private void benchmarkFastList() {
        FastList<Object> fastList = new FastList<Object>();
        Perf_Util.println(fastList.getClass());
        for (int i = 10; i <= 10000; i *= 10) {
            int n;
            int n2;
            int n3 = 1000000 / i;
            Perf_Util.print("    Size: " + i);
            Perf_Util.print(", add (new): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                fastList = new FastList();
                n = 0;
                while (n < i) {
                    fastList.add(this._objects[n++]);
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i));
            Perf_Util.print(", add (recycled): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                fastList.clear();
                n = 0;
                while (n < i) {
                    fastList.add(this._objects[n++]);
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i));
            Perf_Util.print(", iteration (iterator): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3 * 10; ++n2) {
                Iterator iterator = fastList.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != fastList) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i * 10));
            Perf_Util.print(", iteration (node): ");
            FastList<Object> fastList2 = fastList;
            Perf_Util.startTime();
            for (n = 0; n < n3 * 10; ++n) {
                FastCollection.Record record = fastList2.head();
                FastCollection.Record record2 = fastList2.tail();
                while ((record = ((FastList.Node)record).getNext()) != record2) {
                    if (((FastList.Node)record).getValue() != fastList) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i * 10));
            if (fastList instanceof RandomAccess) {
                Perf_Util.print(", get(int): ");
                Perf_Util.startTime();
                for (n = 0; n < n3 * 10; ++n) {
                    int n4 = fastList.size();
                    while (--n4 > 0) {
                        if (fastList.get(n4) != fastList) continue;
                        throw new Error();
                    }
                }
                Perf_Util.print(Perf_Util.endTime(n3 * i * 10));
            }
            Perf_Util.println("");
        }
        Perf_Util.println("");
    }

    private void benchmarkArrayList() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (!arrayList.getClass().getName().equals("java.util.ArrayList")) {
            return;
        }
        Perf_Util.println(arrayList.getClass());
        for (int i = 10; i <= 10000; i *= 10) {
            int n;
            int n2;
            int n3 = 1000000 / i;
            Perf_Util.print("    Size: " + i);
            Perf_Util.print(", add (new): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                arrayList = new ArrayList();
                n = 0;
                while (n < i) {
                    arrayList.add(this._objects[n++]);
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i));
            Perf_Util.print(", add (recycled): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                arrayList.clear();
                n = 0;
                while (n < i) {
                    arrayList.add(this._objects[n++]);
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i));
            Perf_Util.print(", iteration (iterator): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3 * 10; ++n2) {
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != arrayList) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i * 10));
            if (arrayList instanceof RandomAccess) {
                Perf_Util.print(", get(int): ");
                Perf_Util.startTime();
                for (n2 = 0; n2 < n3 * 10; ++n2) {
                    int n4 = arrayList.size();
                    while (--n4 > 0) {
                        if (arrayList.get(n4) != arrayList) continue;
                        throw new Error();
                    }
                }
                Perf_Util.print(Perf_Util.endTime(n3 * i * 10));
            }
            Perf_Util.println("");
        }
        Perf_Util.println("");
    }

    private void benchmarkLinkedList() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        if (!linkedList.getClass().getName().equals("java.util.LinkedList")) {
            return;
        }
        Perf_Util.println(linkedList.getClass());
        for (int i = 10; i <= 10000; i *= 10) {
            int n;
            int n2;
            int n3 = 1000000 / i;
            Perf_Util.print("    Size: " + i);
            Perf_Util.print(", add (new): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                linkedList = new LinkedList();
                n = 0;
                while (n < i) {
                    linkedList.add(this._objects[n++]);
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i));
            Perf_Util.print(", add (recycled): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                linkedList.clear();
                n = 0;
                while (n < i) {
                    linkedList.add(this._objects[n++]);
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i));
            Perf_Util.print(", iteration (iterator): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3 * 10; ++n2) {
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != linkedList) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i * 10));
            if (linkedList instanceof RandomAccess) {
                Perf_Util.print(", get(int): ");
                Perf_Util.startTime();
                for (n2 = 0; n2 < n3 * 10; ++n2) {
                    int n4 = linkedList.size();
                    while (--n4 > 0) {
                        if (linkedList.get(n4) != linkedList) continue;
                        throw new Error();
                    }
                }
                Perf_Util.print(Perf_Util.endTime(n3 * i * 10));
            }
            Perf_Util.println("");
        }
        Perf_Util.println("");
    }

    private void benchmarkFastMap() {
        FastMap<Object, String> fastMap = new FastMap<Object, String>();
        Perf_Util.println(fastMap.getClass());
        for (int i = 10; i <= 10000; i *= 10) {
            int n;
            int n2;
            int n3 = 1000000 / i;
            Perf_Util.print("    Size: " + i);
            Perf_Util.print(", put (new): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                fastMap = new FastMap();
                n = 0;
                while (n < i) {
                    fastMap.put(this._objects[n++], "");
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i));
            Perf_Util.print(", put (recycled): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                fastMap.clear();
                n = 0;
                while (n < i) {
                    fastMap.put(this._objects[n++], "");
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i));
            Perf_Util.print(", get: ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                n = 0;
                while (n < i) {
                    if (fastMap.get(this._objects[n++]) == "") continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i));
            Perf_Util.print(", iteration (iterator): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3 * 10; ++n2) {
                Iterator iterator = fastMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != fastMap) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i * 10));
            Perf_Util.print(", iteration (entry): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3 * 10; ++n2) {
                FastCollection.Record record = fastMap.head();
                FastMap.Entry entry = fastMap.tail();
                while ((record = ((FastMap.Entry)record).getNext()) != entry) {
                    if (((FastMap.Entry)record).getValue() != fastMap) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i * 10));
            Perf_Util.println("");
        }
        Perf_Util.println("");
    }

    private void benchmarkHashMap() {
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        if (!hashMap.getClass().getName().equals("java.util.HashMap")) {
            return;
        }
        Perf_Util.println(hashMap.getClass());
        for (int i = 10; i <= 10000; i *= 10) {
            int n;
            int n2;
            int n3 = 1000000 / i;
            Perf_Util.print("    Size: " + i);
            Perf_Util.print(", put (new): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                hashMap = new HashMap();
                n = 0;
                while (n < i) {
                    hashMap.put(this._objects[n++], "");
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i));
            Perf_Util.print(", put (recycled): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                hashMap.clear();
                n = 0;
                while (n < i) {
                    hashMap.put(this._objects[n++], "");
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i));
            Perf_Util.print(", get: ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                n = 0;
                while (n < i) {
                    if (hashMap.get(this._objects[n++]) == "") continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i));
            Perf_Util.print(", iteration (iterator): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3 * 10; ++n2) {
                Iterator iterator = hashMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != hashMap) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i * 10));
            Perf_Util.println("");
        }
        Perf_Util.println("");
    }

    private void benchmarkSharedFastMap() {
        FastMap<Object, String> fastMap = new FastMap().setShared(true);
        Perf_Util.println("Shared FastMap");
        for (int i = 10; i <= 10000; i *= 10) {
            int n;
            int n2;
            int n3 = 1000000 / i;
            Perf_Util.print("    Size: " + i);
            Perf_Util.print(", put (new): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                fastMap = new FastMap().setShared(true);
                n = 0;
                while (n < i) {
                    fastMap.put(this._objects[n++], "");
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i));
            Perf_Util.print(", put (recycled): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                fastMap.clear();
                n = 0;
                while (n < i) {
                    fastMap.put(this._objects[n++], "");
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i));
            Perf_Util.print(", get: ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                n = 0;
                while (n < i) {
                    if (fastMap.get(this._objects[n++]) == "") continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i));
            Perf_Util.print(", iteration (iterator): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3 * 10; ++n2) {
                Iterator iterator = fastMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != fastMap) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i * 10));
            Perf_Util.print(", iteration (entry): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3 * 10; ++n2) {
                FastCollection.Record record = fastMap.head();
                FastMap.Entry entry = fastMap.tail();
                while ((record = ((FastMap.Entry)record).getNext()) != entry) {
                    if (((FastMap.Entry)record).getValue() != fastMap) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i * 10));
            Perf_Util.println("");
        }
        Perf_Util.println("");
    }

    private void benchmarkConcurrentHashMap() {
        ConcurrentHashMap<Object, String> concurrentHashMap = new ConcurrentHashMap<Object, String>();
        if (!concurrentHashMap.getClass().getName().equals("java.util.concurrent.ConcurrentHashMap")) {
            return;
        }
        Perf_Util.println(concurrentHashMap.getClass());
        for (int i = 10; i <= 10000; i *= 10) {
            int n;
            int n2;
            int n3 = 1000000 / i;
            Perf_Util.print("    Size: " + i);
            Perf_Util.print(", put (new): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                concurrentHashMap = new ConcurrentHashMap();
                n = 0;
                while (n < i) {
                    concurrentHashMap.put(this._objects[n++], "");
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i));
            Perf_Util.print(", put (recycled): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                concurrentHashMap.clear();
                n = 0;
                while (n < i) {
                    concurrentHashMap.put(this._objects[n++], "");
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i));
            Perf_Util.print(", get: ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                n = 0;
                while (n < i) {
                    if (concurrentHashMap.get(this._objects[n++]) == "") continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i));
            Perf_Util.print(", iteration (iterator): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3 * 10; ++n2) {
                Iterator iterator = concurrentHashMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != concurrentHashMap) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i * 10));
            Perf_Util.println("");
        }
        Perf_Util.println("");
    }

    private void benchmarkLinkedHashMap() {
        LinkedHashMap<Object, String> linkedHashMap = new LinkedHashMap<Object, String>();
        if (!linkedHashMap.getClass().getName().equals("java.util.LinkedHashMap")) {
            return;
        }
        Perf_Util.println(linkedHashMap.getClass());
        for (int i = 10; i <= 10000; i *= 10) {
            int n;
            int n2;
            int n3 = 1000000 / i;
            Perf_Util.print("    Size: " + i);
            Perf_Util.print(", put (new): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                linkedHashMap = new LinkedHashMap();
                n = 0;
                while (n < i) {
                    linkedHashMap.put(this._objects[n++], "");
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i));
            Perf_Util.print(", put (recycled): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                linkedHashMap.clear();
                n = 0;
                while (n < i) {
                    linkedHashMap.put(this._objects[n++], "");
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i));
            Perf_Util.print(", get: ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                n = 0;
                while (n < i) {
                    if (linkedHashMap.get(this._objects[n++]) == "") continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i));
            Perf_Util.print(", iteration (iterator): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3 * 10; ++n2) {
                Iterator iterator = linkedHashMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != linkedHashMap) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i * 10));
            Perf_Util.println("");
        }
        Perf_Util.println("");
    }

    private void benchmarkFastSet() {
        FastSet<Object> fastSet = new FastSet<Object>();
        Perf_Util.println(fastSet.getClass());
        for (int i = 10; i <= 10000; i *= 10) {
            int n;
            int n2;
            int n3 = 1000000 / i;
            Perf_Util.print("    Size: " + i);
            Perf_Util.print(", add (new): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                fastSet = new FastSet();
                n = 0;
                while (n < i) {
                    fastSet.add(this._objects[n++]);
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i));
            Perf_Util.print(", add (recycled): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                fastSet.clear();
                n = 0;
                while (n < i) {
                    fastSet.add(this._objects[n++]);
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i));
            Perf_Util.print(", contain: ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                n = 0;
                while (n < i) {
                    if (fastSet.contains(this._objects[n++])) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i));
            Perf_Util.print(", iteration (iterator): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3 * 10; ++n2) {
                Iterator iterator = fastSet.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != fastSet) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i * 10));
            Perf_Util.print(", iteration (record): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3 * 10; ++n2) {
                FastCollection.Record record = fastSet.head();
                FastCollection.Record record2 = fastSet.tail();
                while ((record = record.getNext()) != record2) {
                    if (fastSet.valueOf(record) != fastSet) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i * 10));
            Perf_Util.println("");
        }
        Perf_Util.println("");
    }

    private void benchmarkHashSet() {
        HashSet<Object> hashSet = new HashSet<Object>();
        if (!hashSet.getClass().getName().equals("java.util.HashSet")) {
            return;
        }
        Perf_Util.println(hashSet.getClass());
        for (int i = 10; i <= 10000; i *= 10) {
            int n;
            int n2;
            int n3 = 1000000 / i;
            Perf_Util.print("    Size: " + i);
            Perf_Util.print(", add (new): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                hashSet = new HashSet();
                n = 0;
                while (n < i) {
                    hashSet.add(this._objects[n++]);
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i));
            Perf_Util.print(", add (recycled): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                hashSet.clear();
                n = 0;
                while (n < i) {
                    hashSet.add(this._objects[n++]);
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i));
            Perf_Util.print(", contain: ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                n = 0;
                while (n < i) {
                    if (hashSet.contains(this._objects[n++])) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i));
            Perf_Util.print(", iteration (iterator): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3 * 10; ++n2) {
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != hashSet) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i * 10));
            Perf_Util.println("");
        }
        Perf_Util.println("");
    }

    private void benchmarkLinkedHashSet() {
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        if (!linkedHashSet.getClass().getName().equals("java.util.LinkedHashSet")) {
            return;
        }
        Perf_Util.println(linkedHashSet.getClass());
        for (int i = 10; i <= 10000; i *= 10) {
            int n;
            int n2;
            int n3 = 1000000 / i;
            Perf_Util.print("    Size: " + i);
            Perf_Util.print(", add (new): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                linkedHashSet = new LinkedHashSet();
                n = 0;
                while (n < i) {
                    linkedHashSet.add(this._objects[n++]);
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i));
            Perf_Util.print(", add (recycled): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                linkedHashSet.clear();
                n = 0;
                while (n < i) {
                    linkedHashSet.add(this._objects[n++]);
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i));
            Perf_Util.print(", contain: ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                n = 0;
                while (n < i) {
                    if (linkedHashSet.contains(this._objects[n++])) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i));
            Perf_Util.print(", iteration (iterator): ");
            Perf_Util.startTime();
            for (n2 = 0; n2 < n3 * 10; ++n2) {
                Iterator iterator = linkedHashSet.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != linkedHashSet) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(n3 * i * 10));
            Perf_Util.println("");
        }
        Perf_Util.println("");
    }
}

