/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class LanguagePriorityList {
    public static final LanguagePriorityList ANY = LanguagePriorityList.parse("*");
    private final List<Locale8.LanguageRange> list;
    private final String str;

    public static LanguagePriorityList parse(String string) throws IllegalArgumentException {
        return new LanguagePriorityList(Locale8.LanguageRange.parse(string));
    }

    private LanguagePriorityList(List<Locale8.LanguageRange> list) {
        this.list = list;
        this.str = LanguagePriorityList.asString(list);
    }

    public String lookupTag(Collection<String> collection) {
        return Locale8.lookupTag(this.list, collection);
    }

    public String toString() {
        return this.str;
    }

    public boolean equals(Object object) {
        return object instanceof LanguagePriorityList && ((LanguagePriorityList)object).str.equals(this.str);
    }

    public int hashCode() {
        return this.str.hashCode();
    }

    private static String asString(List<Locale8.LanguageRange> list) {
        if (list.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(LanguagePriorityList.asString(list.get(0)));
        for (int i = 1; i < list.size(); ++i) {
            stringBuilder.append(',').append(LanguagePriorityList.asString(list.get(i)));
        }
        return stringBuilder.toString();
    }

    private static String asString(Locale8.LanguageRange languageRange) {
        return languageRange.getRange() + (languageRange.getWeight() != 1.0 ? ";q=" + languageRange.getWeight() : "");
    }

    private static final class Locale8 {
        private Locale8() {
        }

        public static String lookupTag(List<LanguageRange> list, Collection<String> collection) {
            for (LanguageRange languageRange : list) {
                String string = languageRange.getLanguage();
                if (!collection.contains(string)) continue;
                return string;
            }
            return null;
        }

        private static final class LanguageRange {
            private final String range;
            private final double weight;
            private static final String RANGE = "(?:[a-z]{2,3}|\\*)(?:-[a-zA-Z]{2,3}";
            private static final String WEIGHT = ";q\\s*=\\s*(1|0\\.[0-9]+)";
            private static final Pattern INPUT_PATTERN = Pattern.compile("((?:[a-z]{2,3}|\\*)(?:-[a-zA-Z]{2,3})?)\\s*(;q\\s*=\\s*(1|0\\.[0-9]+))?");
            private static final Pattern WEIGHT_PATTERN = Pattern.compile(";q\\s*=\\s*(1|0\\.[0-9]+)");

            public static List<LanguageRange> parse(String string) {
                ArrayList<LanguageRange> arrayList = new ArrayList<LanguageRange>();
                for (String string2 : string.split("\\s*,\\s*", -1)) {
                    arrayList.add(LanguageRange.parseItem(string2));
                }
                Collections.sort(arrayList, ByWeightDesc.INSTANCE);
                return arrayList;
            }

            private LanguageRange(String string, double d) {
                this.range = string;
                this.weight = d;
            }

            public String getRange() {
                return this.range;
            }

            public double getWeight() {
                return this.weight;
            }

            private String getLanguage() {
                int n = this.range.indexOf("-");
                return n != -1 ? this.range.substring(0, n) : this.range;
            }

            private static LanguageRange parseItem(String string) {
                Matcher matcher = INPUT_PATTERN.matcher(string);
                if (!matcher.matches()) {
                    throw new IllegalArgumentException(string);
                }
                return new LanguageRange(matcher.group(1).toLowerCase(), LanguageRange.parseWeight(matcher.group(2)));
            }

            private static double parseWeight(String string) {
                if (string != null) {
                    Matcher matcher = WEIGHT_PATTERN.matcher(string);
                    matcher.matches();
                    string = matcher.group(1);
                }
                return string != null ? Double.parseDouble(string) : 1.0;
            }

            private static enum ByWeightDesc implements Comparator<LanguageRange>
            {
                INSTANCE;


                @Override
                public int compare(LanguageRange languageRange, LanguageRange languageRange2) {
                    return languageRange2.getWeight() < languageRange.getWeight() ? -1 : (languageRange2.getWeight() > languageRange.getWeight() ? 1 : 0);
                }
            }
        }
    }
}

