/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client;

import com.portfolioeffect.quant.client.ConnectionToServer;
import com.portfolioeffect.quant.client.message.ClientMessage;
import com.portfolioeffect.quant.client.message.Reject;
import com.portfolioeffect.quant.client.message.util.ServerResponseMessageParser;
import com.portfolioeffect.quant.client.model.ConnectFailedException;
import com.portfolioeffect.quant.client.result.Metric;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.openfast.Message;
import org.openfast.session.FastConnectionException;
import org.openfast.template.TemplateRegistry;

public class Connector {
    private final ConnectionToServer connectionToServer;
    private final LinkedBlockingDeque<ClientMessage> clientMessageQueue;
    private final int UID;
    private String apiKey;
    private String username;
    private String password;
    private String host;
    private int port = 0;

    public Connector(Connector connector, int UID, ConnectionToServer connectionToServer, LinkedBlockingDeque<ClientMessage> clientMessageQueue) {
        this.connectionToServer = connectionToServer;
        this.clientMessageQueue = clientMessageQueue;
        this.UID = UID;
        if (connector != null) {
            this.apiKey = connector.apiKey;
            this.username = connector.username;
            this.password = connector.password;
            this.host = connector.host;
            this.port = connector.port;
        }
    }

    public Connector(Connector connector) {
        this.connectionToServer = connector.connectionToServer;
        this.clientMessageQueue = connector.clientMessageQueue;
        this.UID = connector.UID;
        this.apiKey = connector.apiKey;
        this.username = connector.username;
        this.password = connector.password;
        this.host = connector.host;
        this.port = connector.port;
    }

    public Message sendAndAwaitResponse(Message request, int timeoutSec) throws Exception {
        if (!this.connectionToServer.isLoggedOn()) {
            throw new ConnectFailedException();
        }
        try {
            this.connectionToServer.send(this.UID, request);
        }
        catch (Exception e) {
            throw new ConnectFailedException();
        }
        ClientMessage clientMessage = this.clientMessageQueue.poll(timeoutSec, TimeUnit.SECONDS);
        if (clientMessage == null) {
            throw new ConnectFailedException();
        }
        if (clientMessage.isEmpty()) {
            this.connectionToServer.setConnectionBreak("Connector-msg is empty");
            throw new ConnectFailedException();
        }
        if (clientMessage.isRejected()) {
            Reject reject = ServerResponseMessageParser.parseReject(clientMessage.getMessage());
            throw new Exception(reject.getText());
        }
        return clientMessage.getMessage();
    }

    public void send(Message request) throws Exception {
        this.connectionToServer.send(this.UID, request);
    }

    public Message awaitResponse() throws Exception {
        if (!this.connectionToServer.isLoggedOn()) {
            throw new ConnectFailedException();
        }
        ClientMessage clientMessage = this.clientMessageQueue.poll(200L, TimeUnit.DAYS);
        if (clientMessage == null) {
            throw new ConnectFailedException();
        }
        if (clientMessage.isEmpty()) {
            this.connectionToServer.setConnectionBreak("Connector-msg is empty");
            throw new ConnectFailedException();
        }
        if (clientMessage.isRejected()) {
            this.connectionToServer.logoutUID(this.UID);
            Reject reject = ServerResponseMessageParser.parseReject(clientMessage.getMessage());
            throw new Exception(reject.getText());
        }
        return clientMessage.getMessage();
    }

    public void sendToSelf(Message responseMsg) {
        this.clientMessageQueue.offer(new ClientMessage(responseMsg));
    }

    public void stop() {
        this.connectionToServer.stop();
    }

    public Metric start(String username, String password, String apiKey, String remoteHostName) {
        this.username = username;
        this.password = password;
        this.apiKey = apiKey;
        this.host = remoteHostName;
        if (this.port > 0) {
            return this.connectionToServer.start(this.UID, username, password, apiKey, remoteHostName, this.port);
        }
        return this.connectionToServer.start(this.UID, username, password, apiKey, remoteHostName, this.port);
    }

    public Metric restart() {
        this.clientMessageQueue.clear();
        return this.connectionToServer.restart(this.UID, this.username, this.password, this.apiKey, this.host);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public int getRestarTimeWait() {
        return this.connectionToServer.getRestarTimeWait();
    }

    public void setRestarTimeWait(int restarTimeWait) {
        this.connectionToServer.setRestarTimeWait(restarTimeWait);
    }

    public void start() throws IOException, FastConnectionException {
        this.connectionToServer.start(this.UID, this.getUsername(), this.getPassword(), this.getApiKey(), this.getHost());
    }

    public void logon() {
        this.connectionToServer.logon();
    }

    public TemplateRegistry getTemplateRegistry() throws Exception {
        return this.connectionToServer.getTemplateRegistry();
    }

    public int getOutboundMsgSequenceNumber() {
        return this.connectionToServer.getOutboundMsgSequenceNumber();
    }

    public void setTemplatesFileName(String string) {
        this.connectionToServer.setTemplatesFileName(string);
    }

    public int getUID() {
        return this.UID;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

