/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tfloat.bin;

import cern.colt.buffer.tfloat.FloatBuffer;
import cern.colt.buffer.tfloat.FloatBufferConsumer;
import cern.colt.list.tfloat.FloatArrayList;
import cern.jet.stat.tfloat.FloatDescriptive;
import hep.aida.tfloat.bin.AbstractFloatBin;

public abstract class AbstractFloatBin1D
extends AbstractFloatBin
implements FloatBufferConsumer {
    private static final long serialVersionUID = 1L;

    protected AbstractFloatBin1D() {
    }

    public abstract void add(float var1);

    public final synchronized void addAllOf(FloatArrayList floatArrayList) {
        this.addAllOfFromTo(floatArrayList, 0, floatArrayList.size() - 1);
    }

    public synchronized void addAllOfFromTo(FloatArrayList floatArrayList, int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            this.add(floatArrayList.getQuick(i));
        }
    }

    public synchronized FloatBuffer buffered(int n) {
        return new FloatBuffer(this, n);
    }

    public String compareWith(AbstractFloatBin1D abstractFloatBin1D) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nDifferences [percent]");
        stringBuffer.append("\nSize: " + this.relError(this.size(), abstractFloatBin1D.size()) + " %");
        stringBuffer.append("\nSum: " + this.relError(this.sum(), abstractFloatBin1D.sum()) + " %");
        stringBuffer.append("\nSumOfSquares: " + this.relError(this.sumOfSquares(), abstractFloatBin1D.sumOfSquares()) + " %");
        stringBuffer.append("\nMin: " + this.relError(this.min(), abstractFloatBin1D.min()) + " %");
        stringBuffer.append("\nMax: " + this.relError(this.max(), abstractFloatBin1D.max()) + " %");
        stringBuffer.append("\nMean: " + this.relError(this.mean(), abstractFloatBin1D.mean()) + " %");
        stringBuffer.append("\nRMS: " + this.relError(this.rms(), abstractFloatBin1D.rms()) + " %");
        stringBuffer.append("\nVariance: " + this.relError(this.variance(), abstractFloatBin1D.variance()) + " %");
        stringBuffer.append("\nStandard deviation: " + this.relError(this.standardDeviation(), abstractFloatBin1D.standardDeviation()) + " %");
        stringBuffer.append("\nStandard error: " + this.relError(this.standardError(), abstractFloatBin1D.standardError()) + " %");
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof AbstractFloatBin1D)) {
            return false;
        }
        AbstractFloatBin1D abstractFloatBin1D = (AbstractFloatBin1D)object;
        return this.size() == abstractFloatBin1D.size() && this.min() == abstractFloatBin1D.min() && this.max() == abstractFloatBin1D.max() && this.sum() == abstractFloatBin1D.sum() && this.sumOfSquares() == abstractFloatBin1D.sumOfSquares();
    }

    public abstract float max();

    public synchronized float mean() {
        return this.sum() / (float)this.size();
    }

    public abstract float min();

    protected float relError(float f, float f2) {
        return 100.0f * (1.0f - f / f2);
    }

    public synchronized float rms() {
        return FloatDescriptive.rms(this.size(), this.sumOfSquares());
    }

    public synchronized float standardDeviation() {
        return (float)Math.sqrt(this.variance());
    }

    public synchronized float standardError() {
        return FloatDescriptive.standardError(this.size(), this.variance());
    }

    public abstract float sum();

    public abstract float sumOfSquares();

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("\n-------------");
        stringBuffer.append("\nSize: " + this.size());
        stringBuffer.append("\nSum: " + this.sum());
        stringBuffer.append("\nSumOfSquares: " + this.sumOfSquares());
        stringBuffer.append("\nMin: " + this.min());
        stringBuffer.append("\nMax: " + this.max());
        stringBuffer.append("\nMean: " + this.mean());
        stringBuffer.append("\nRMS: " + this.rms());
        stringBuffer.append("\nVariance: " + this.variance());
        stringBuffer.append("\nStandard deviation: " + this.standardDeviation());
        stringBuffer.append("\nStandard error: " + this.standardError());
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public synchronized void trimToSize() {
    }

    public synchronized float variance() {
        return FloatDescriptive.sampleVariance(this.size(), this.sum(), this.sumOfSquares());
    }
}

