/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.decomposition;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import cern.colt.matrix.tfloat.impl.SparseCCFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseRCFloatMatrix2D;
import edu.emory.mathcs.csparsej.tfloat.Scs_common;
import edu.emory.mathcs.csparsej.tfloat.Scs_happly;
import edu.emory.mathcs.csparsej.tfloat.Scs_ipvec;
import edu.emory.mathcs.csparsej.tfloat.Scs_pvec;
import edu.emory.mathcs.csparsej.tfloat.Scs_qr;
import edu.emory.mathcs.csparsej.tfloat.Scs_sqr;
import edu.emory.mathcs.csparsej.tfloat.Scs_usolve;
import edu.emory.mathcs.csparsej.tfloat.Scs_utsolve;

public class SparseFloatQRDecomposition {
    private Scs_common.Scss S;
    private Scs_common.Scsn N;
    private FloatMatrix2D R;
    private FloatMatrix2D V;
    private int m;
    private int n;
    private boolean rcMatrix = false;

    public SparseFloatQRDecomposition(FloatMatrix2D floatMatrix2D, int n) {
        Scs_common.Scs scs;
        FloatProperty.DEFAULT.checkSparse(floatMatrix2D);
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("order must be a number between 0 and 3");
        }
        this.m = floatMatrix2D.rows();
        this.n = floatMatrix2D.columns();
        if (floatMatrix2D instanceof SparseRCFloatMatrix2D) {
            this.rcMatrix = true;
            scs = this.m >= this.n ? ((SparseRCFloatMatrix2D)floatMatrix2D).getColumnCompressed().elements() : ((SparseRCFloatMatrix2D)floatMatrix2D).getColumnCompressed().getTranspose().elements();
        } else {
            scs = this.m >= this.n ? (Scs_common.Scs)floatMatrix2D.elements() : ((SparseCCFloatMatrix2D)floatMatrix2D).getTranspose().elements();
        }
        this.S = Scs_sqr.cs_sqr((int)n, (Scs_common.Scs)scs, (boolean)true);
        if (this.S == null) {
            throw new IllegalArgumentException("Exception occured in cs_sqr()");
        }
        this.N = Scs_qr.cs_qr((Scs_common.Scs)scs, (Scs_common.Scss)this.S);
        if (this.N == null) {
            throw new IllegalArgumentException("Exception occured in cs_qr()");
        }
    }

    public FloatMatrix2D getV() {
        if (this.V == null) {
            this.V = new SparseCCFloatMatrix2D(this.N.L);
            if (this.rcMatrix) {
                this.V = ((SparseCCFloatMatrix2D)this.V).getRowCompressed();
            }
        }
        return this.V.copy();
    }

    public float[] getBeta() {
        if (this.N.B == null) {
            return null;
        }
        float[] fArray = new float[this.N.B.length];
        System.arraycopy(this.N.B, 0, fArray, 0, this.N.B.length);
        return fArray;
    }

    public FloatMatrix2D getR() {
        if (this.R == null) {
            this.R = new SparseCCFloatMatrix2D(this.N.U);
            if (this.rcMatrix) {
                this.R = ((SparseCCFloatMatrix2D)this.R).getRowCompressed();
            }
        }
        return this.R.copy();
    }

    public Scs_common.Scss getSymbolicAnalysis() {
        Scs_common.Scss scss = new Scs_common.Scss();
        scss.cp = this.S.cp != null ? (int[])this.S.cp.clone() : null;
        scss.leftmost = this.S.leftmost != null ? (int[])this.S.leftmost.clone() : null;
        scss.lnz = this.S.lnz;
        scss.m2 = this.S.m2;
        scss.parent = this.S.parent != null ? (int[])this.S.parent.clone() : null;
        scss.pinv = this.S.pinv != null ? (int[])this.S.pinv.clone() : null;
        scss.q = this.S.q != null ? (int[])this.S.q.clone() : null;
        scss.unz = this.S.unz;
        return scss;
    }

    public boolean hasFullRank() {
        if (this.R == null) {
            this.R = new SparseCCFloatMatrix2D(this.N.U);
            if (this.rcMatrix) {
                this.R = ((SparseCCFloatMatrix2D)this.R).getRowCompressed();
            }
        }
        int n = Math.min(this.m, this.n);
        for (int i = 0; i < n; ++i) {
            if (this.R.getQuick(i, i) != 0.0f) continue;
            return false;
        }
        return true;
    }

    public void solve(FloatMatrix1D floatMatrix1D) {
        if (floatMatrix1D.size() != (long)Math.max(this.m, this.n)) {
            throw new IllegalArgumentException("The size b must be equal to max(A.rows(), A.columns()).");
        }
        if (!this.hasFullRank()) {
            throw new IllegalArgumentException("Matrix is rank deficient.");
        }
        float[] fArray = floatMatrix1D.isView() ? (float[])floatMatrix1D.copy().elements() : (float[])floatMatrix1D.elements();
        if (this.m >= this.n) {
            float[] fArray2 = new float[this.S != null ? this.S.m2 : 1];
            Scs_ipvec.cs_ipvec((int[])this.S.pinv, (float[])fArray, (float[])fArray2, (int)this.m);
            for (int i = 0; i < this.n; ++i) {
                Scs_happly.cs_happly((Scs_common.Scs)this.N.L, (int)i, (float)this.N.B[i], (float[])fArray2);
            }
            Scs_usolve.cs_usolve((Scs_common.Scs)this.N.U, (float[])fArray2);
            Scs_ipvec.cs_ipvec((int[])this.S.q, (float[])fArray2, (float[])fArray, (int)this.n);
        } else {
            float[] fArray3 = new float[this.S != null ? this.S.m2 : 1];
            Scs_pvec.cs_pvec((int[])this.S.q, (float[])fArray, (float[])fArray3, (int)this.m);
            Scs_utsolve.cs_utsolve((Scs_common.Scs)this.N.U, (float[])fArray3);
            for (int i = this.m - 1; i >= 0; --i) {
                Scs_happly.cs_happly((Scs_common.Scs)this.N.L, (int)i, (float)this.N.B[i], (float[])fArray3);
            }
            Scs_pvec.cs_pvec((int[])this.S.pinv, (float[])fArray3, (float[])fArray, (int)this.n);
        }
    }
}

