/*
 * Decompiled with CFR 0.152.
 */
package ExperimentalDesign;

import CustomLogging.FileLoggedClass;
import ObjectiveFunctions.ObjectiveFunction;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AllExperimentalDesigns
extends FileLoggedClass {
    public Random rand_obj = new Random();
    protected int n;
    protected int p;
    protected String objective;
    protected Integer num_cores = 1;
    protected AtomicBoolean search_stopped = new AtomicBoolean();
    protected double[][] X;
    protected double[][] Sinv;
    protected double[][] Kgram;
    protected boolean wait;
    protected ExecutorService search_thread_pool;
    protected boolean began_search;
    protected long t0;
    protected Long tf;

    public void beginSearch() {
        this.began_search = true;
        this.t0 = System.currentTimeMillis();
        this.search_thread_pool = Executors.newFixedThreadPool(this.num_cores == null ? 1 : this.num_cores);
    }

    protected void afterBeginSearch() {
        this.search_thread_pool.shutdown();
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    AllExperimentalDesigns.this.search_thread_pool.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                AllExperimentalDesigns.this.tf = System.currentTimeMillis();
            }
        };
        thread.start();
        if (this.wait) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public int timeElapsedInSeconds() {
        if (this.tf == null) {
            return (int)(System.currentTimeMillis() - this.t0) / 1000;
        }
        return (int)(this.tf - this.t0) / 1000;
    }

    public long timeFinished() {
        return this.tf;
    }

    public boolean began() {
        return this.began_search;
    }

    public void stopSearch() {
        this.search_stopped.set(true);
    }

    public void setObjective(String string) throws Exception {
        if (!ObjectiveFunction.isValidObjFunction(string)) {
            throw new Exception("objective function not recognized");
        }
        this.objective = string;
    }

    public void setNumCores(int n) {
        this.num_cores = n;
    }

    public void setN(int n) throws Exception {
        if (n % 2 != 0) {
            throw new Exception("n must be even");
        }
        this.n = n;
    }

    public void setP(int n) {
        this.p = n;
    }

    public void setKgramRow(int n, double[] dArray) {
        if (this.Kgram == null) {
            this.Kgram = new double[this.n][this.n];
        }
        for (int i = 0; i < this.n; ++i) {
            this.Kgram[n][i] = dArray[i];
        }
    }

    public void setDataRow(int n, double[] dArray) {
        if (this.X == null) {
            this.X = new double[this.n][this.p];
        }
        for (int i = 0; i < this.p; ++i) {
            this.X[n][i] = dArray[i];
        }
    }

    public void setDataRow(int n, double d) {
        if (this.X == null) {
            this.X = new double[this.n][this.p];
        }
        double[] dArray = new double[]{d};
        this.X[n] = dArray;
    }

    public void setInvVarCovRow(int n, double[] dArray) {
        if (this.Sinv == null) {
            this.Sinv = new double[this.p][this.p];
        }
        for (int i = 0; i < this.p; ++i) {
            this.Sinv[n][i] = dArray[i];
        }
    }

    public void setInvVarCovRow(int n, double d) {
        if (this.Sinv == null) {
            this.Sinv = new double[this.p][this.p];
        }
        double[] dArray = new double[]{d};
        this.Sinv[n] = dArray;
    }

    public void setSeed(int n) {
        this.rand_obj.setSeed(n);
    }

    public void setWait() {
        this.wait = true;
    }
}

