/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.sitemodel;

import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.oldevomodel.sitemodel.SiteModel;
import dr.oldevomodel.substmodel.FrequencyModel;
import dr.oldevomodel.substmodel.SubstitutionModel;

public class CategorySiteModel
extends AbstractModel
implements SiteModel {
    private SubstitutionModel substitutionModel = null;
    private final Parameter muParameter;
    private final Parameter rateParameter;
    private boolean ratesKnown;
    private final int categoryCount;
    private final double[] categoryRates;
    private final int[] categoryWeights;
    private final int[] categories;
    private final String states;
    private final int siteCount;
    private int relativeTo = 0;

    public CategorySiteModel(SubstitutionModel substitutionModel, Parameter parameter, Parameter parameter2, String string, String string2, int n) {
        super("siteModel");
        this.substitutionModel = substitutionModel;
        this.addModel(substitutionModel);
        this.muParameter = parameter;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.rateParameter = parameter2;
        this.addVariable(parameter2);
        parameter2.addBounds(new Parameter.DefaultBounds(Double.MAX_VALUE, Double.MIN_VALUE, parameter2.getDimension()));
        this.states = string2;
        if (this.states.length() != parameter2.getDimension() + 1) {
            throw new IllegalArgumentException("States must have one more dimension than rate parameter!");
        }
        this.categoryCount = this.states.length();
        this.categories = new int[string.length()];
        this.categoryWeights = new int[this.categoryCount];
        this.categoryRates = new double[this.categoryCount];
        for (int i = 0; i < this.categories.length; ++i) {
            char c = string.charAt(i);
            this.categories[i] = this.states.indexOf(c);
            int n2 = this.categories[i];
            this.categoryWeights[n2] = this.categoryWeights[n2] + 1;
        }
        this.siteCount = this.categories.length;
        this.relativeTo = n;
        this.ratesKnown = false;
    }

    public void setMu(double d) {
        this.muParameter.setParameterValue(0, d);
    }

    public final double getMu() {
        return this.muParameter.getParameterValue(0);
    }

    public Parameter getMutationRateParameter() {
        return this.muParameter;
    }

    @Override
    public boolean integrateAcrossCategories() {
        return false;
    }

    @Override
    public int getCategoryCount() {
        return this.categoryCount;
    }

    @Override
    public int getCategoryOfSite(int n) {
        return this.categories[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getRateForCategory(int n) {
        CategorySiteModel categorySiteModel = this;
        synchronized (categorySiteModel) {
            if (!this.ratesKnown) {
                this.calculateCategoryRates();
            }
        }
        double d = 1.0;
        if (this.muParameter != null) {
            d = this.muParameter.getParameterValue(0);
        }
        return this.categoryRates[n] * d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[] getCategoryRates() {
        Object object = this;
        synchronized (object) {
            if (!this.ratesKnown) {
                this.calculateCategoryRates();
            }
        }
        object = new double[this.categoryRates.length];
        double d = 1.0;
        if (this.muParameter != null) {
            d = this.muParameter.getParameterValue(0);
        }
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = this.categoryRates[i] * d;
        }
        return object;
    }

    public void getTransitionProbabilities(double d, double[] dArray) {
        this.substitutionModel.getTransitionProbabilities(d, dArray);
    }

    @Override
    public double getProportionForCategory(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double[] getCategoryProportions() {
        throw new UnsupportedOperationException();
    }

    private void calculateCategoryRates() {
        int n;
        this.categoryRates[this.relativeTo] = 1.0;
        double d = 1.0;
        int n2 = 0;
        for (n = 0; n < this.categoryRates.length; ++n) {
            if (n == this.relativeTo) continue;
            this.categoryRates[n] = this.rateParameter.getParameterValue(n2);
            d = this.categoryRates[n] * (double)this.categoryWeights[n];
            ++n2;
        }
        d /= (double)this.siteCount;
        n = 0;
        while (n < this.categoryRates.length) {
            int n3 = n++;
            this.categoryRates[n3] = this.categoryRates[n3] / d;
        }
        this.ratesKnown = true;
    }

    @Override
    public FrequencyModel getFrequencyModel() {
        return this.substitutionModel.getFrequencyModel();
    }

    @Override
    public SubstitutionModel getSubstitutionModel() {
        return this.substitutionModel;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.listenerHelper.fireModelChanged(this, object, n);
    }

    @Override
    public void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.rateParameter) {
            this.ratesKnown = false;
        }
        this.listenerHelper.fireModelChanged(this, variable, n);
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
        this.ratesKnown = false;
    }

    @Override
    protected void acceptState() {
    }
}

