/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Bounds;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;
import dr.util.Transform;

public class TransformedParameter
extends Parameter.Abstract
implements VariableListener {
    protected final Parameter parameter;
    protected final Transform transform;
    protected final boolean inverse;
    protected Bounds<Double> transformedBounds;

    public TransformedParameter(Parameter parameter, Transform transform) {
        this(parameter, transform, false);
    }

    public TransformedParameter(Parameter parameter, Transform transform, boolean bl) {
        this.parameter = parameter;
        this.transform = transform;
        this.inverse = bl;
        this.parameter.addVariableListener(this);
        Bounds<Double> bounds = parameter.getBounds();
        if (bounds != null && !(transform instanceof Transform.MultivariateTransform)) {
            this.addBounds(bounds);
        }
    }

    @Override
    public int getDimension() {
        return this.parameter.getDimension();
    }

    @Override
    protected void storeValues() {
        this.parameter.storeParameterValues();
    }

    @Override
    protected void restoreValues() {
        this.parameter.restoreParameterValues();
    }

    @Override
    protected void acceptValues() {
        this.parameter.acceptParameterValues();
    }

    @Override
    protected void adoptValues(Parameter parameter) {
        this.parameter.adoptParameterValues(parameter);
    }

    private double transform(double d) {
        if (this.inverse) {
            return this.transform.inverse(d);
        }
        return this.transform.transform(d);
    }

    protected double[] transform(double[] dArray) {
        if (this.inverse) {
            return this.transform.inverse(dArray, 0, dArray.length);
        }
        return this.transform.transform(dArray, 0, dArray.length);
    }

    private double inverse(double d) {
        return this.inverse ? this.transform.transform(d) : this.transform.inverse(d);
    }

    protected double[] inverse(double[] dArray) {
        if (this.inverse) {
            return this.transform.transform(dArray, 0, dArray.length);
        }
        return this.transform.inverse(dArray, 0, dArray.length);
    }

    @Override
    public double getParameterValue(int n) {
        return this.transform(this.parameter.getParameterValue(n));
    }

    @Override
    public double getParameterUntransformedValue(int n) {
        return this.parameter.getParameterValue(n);
    }

    public double[] getParameterUntransformedValues() {
        return this.parameter.getParameterValues();
    }

    @Override
    public void setParameterUntransformedValue(int n, double d) {
        this.parameter.setParameterValue(n, d);
    }

    public Parameter getUntransformedParameter() {
        return this.parameter;
    }

    @Override
    public void setParameterValue(int n, double d) {
        this.parameter.setParameterValue(n, this.inverse(d));
    }

    @Override
    public void setParameterValueQuietly(int n, double d) {
        this.parameter.setParameterValueQuietly(n, this.inverse(d));
    }

    @Override
    public void setParameterValueNotifyChangedAll(int n, double d) {
        this.parameter.setParameterValueNotifyChangedAll(n, this.inverse(d));
    }

    @Override
    public String getParameterName() {
        if (this.getId() == null) {
            return "transformed." + this.parameter.getParameterName();
        }
        return this.getId();
    }

    @Override
    public void addBounds(Bounds<Double> bounds) {
        int n = bounds.getBoundsDimension();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            double d;
            double d2 = this.transform(bounds.getLowerLimit(i));
            if (d2 < (d = this.transform(bounds.getUpperLimit(i)))) {
                dArray[i] = d2;
                dArray2[i] = d;
                continue;
            }
            dArray[i] = d;
            dArray2[i] = d2;
        }
        this.transformedBounds = new Parameter.DefaultBounds(dArray2, dArray);
        this.parameter.addBounds(this.transformedBounds);
    }

    @Override
    public boolean check() {
        return this.parameter.check();
    }

    @Override
    public Bounds<Double> getBounds() {
        return this.transformedBounds;
    }

    @Override
    public void addDimension(int n, double d) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public double removeDimension(int n) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.fireParameterChangedEvent(n, changeType);
    }

    public double diffLogJacobian(double[] dArray, double[] dArray2) {
        if (this.inverse) {
            return -this.transform.getLogJacobian(dArray, 0, dArray.length) + this.transform.getLogJacobian(dArray2, 0, dArray2.length);
        }
        return this.transform.getLogJacobian(dArray, 0, dArray.length) - this.transform.getLogJacobian(dArray2, 0, dArray2.length);
    }
}

