/*
 * Decompiled with CFR 0.152.
 */
package dr.geo.math;

public final class Vector3D {
    protected double x;
    protected double y;
    protected double z;
    public static final Vector3D ORIGIN = new Vector3D(0.0, 0.0, 0.0);

    public Vector3D(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public Vector3D(Vector3D vector3D) {
        this.x = vector3D.x;
        this.y = vector3D.y;
        this.z = vector3D.z;
    }

    public Vector3D add(Vector3D vector3D) {
        return new Vector3D(this.x + vector3D.x, this.y + vector3D.y, this.z + vector3D.z);
    }

    public Vector3D addU(Vector3D vector3D) {
        this.x += vector3D.x;
        this.y += vector3D.y;
        this.z += vector3D.z;
        return this;
    }

    public Vector3D cross(Vector3D vector3D) {
        return new Vector3D(this.y * vector3D.z - this.z * vector3D.y, this.z * vector3D.x - this.x * vector3D.z, this.x * vector3D.y - this.y * vector3D.x);
    }

    public double dot(Vector3D vector3D) {
        return this.x * vector3D.x + this.y * vector3D.y + this.z * vector3D.z;
    }

    public void negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Vector3D)) {
            return false;
        }
        return this.x == ((Vector3D)object).x && this.x == ((Vector3D)object).y && this.x == ((Vector3D)object).z;
    }

    public Vector3D mirror(Vector3D vector3D) {
        return this.add(vector3D.mul(-2.0 * vector3D.dot(this)));
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getCoordinate(int n) {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IllegalArgumentException("illegal coordinates:" + n);
    }

    public double modulus() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double mod2() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Vector3D mul(double d) {
        return new Vector3D(this.x * d, this.y * d, this.z * d);
    }

    public Vector3D mulU(double d) {
        this.x *= d;
        this.y *= d;
        this.z *= d;
        return this;
    }

    public Vector3D sub(Vector3D vector3D) {
        return new Vector3D(this.x - vector3D.x, this.y - vector3D.y, this.z - vector3D.z);
    }

    public Vector3D subU(Vector3D vector3D) {
        this.x -= vector3D.x;
        this.y -= vector3D.y;
        this.z -= vector3D.z;
        return this;
    }

    public Vector3D normalized() {
        return this.mul(1.0 / this.modulus());
    }

    public Vector3D normalize() {
        double d = 1.0 / this.modulus();
        this.x *= d;
        this.y *= d;
        this.z *= d;
        return this;
    }

    public String toString() {
        return "Vector3D[" + this.x + "," + this.y + "," + this.z + "]";
    }
}

