/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.coalescent;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.coalescent.ExponentialGrowth;
import dr.evolution.util.Units;

public class ExpConstExpDemographic
extends ExponentialGrowth {
    private static double minIntensity = Double.MAX_VALUE;
    private static double maxIntensity = Double.MIN_VALUE;
    private double r2;
    private double time1;
    private double plateauTime;

    public ExpConstExpDemographic(Units.Type type) {
        super(type);
    }

    public final double getGrowthRate2() {
        return this.r2;
    }

    public void setGrowthRate2(double d) {
        this.r2 = d;
    }

    public final double getTime1() {
        return this.time1;
    }

    public final double getPlateauTime() {
        return this.plateauTime;
    }

    public final void setTime1(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.time1 = d;
    }

    public final void setPlateauTime(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.plateauTime = d;
    }

    @Override
    public double getDemographic(double d) {
        double d2 = this.getGrowthRate();
        double d3 = this.getGrowthRate2();
        if (d < this.time1) {
            return this.getN0() * Math.exp(-d * d2);
        }
        double d4 = this.getN0() * Math.exp(this.time1 * d2);
        if (d < this.time1 + this.plateauTime) {
            return d4;
        }
        d -= this.time1 + this.plateauTime;
        if (d3 == 0.0) {
            return d4;
        }
        return d4 * Math.exp(-d * d3);
    }

    @Override
    public double getIntensity(double d) {
        double d2 = this.getGrowthRate();
        double d3 = this.getGrowthRate2();
        double d4 = this.getN0() * Math.exp(this.time1 * d2);
        if (d < this.time1) {
            return super.getIntensity(d);
        }
        double d5 = super.getIntensity(this.time1);
        if (d < this.time1 + this.plateauTime) {
            double d6 = (d - this.time1) / d4;
            return d5 + d6;
        }
        double d7 = this.plateauTime / d4;
        double d8 = d3 == 0.0 ? d / d4 : (Math.exp((d -= this.time1 + this.plateauTime) * d3) - 1.0) / d4 / d3;
        double d9 = d5 + d7 + d8;
        if (d9 < minIntensity) {
            minIntensity = d9;
        }
        if (d9 > maxIntensity) {
            maxIntensity = d9;
        }
        return d9;
    }

    @Override
    public double getInverseIntensity(double d) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumArguments() {
        return 4;
    }

    @Override
    public String getArgumentName(int n) {
        switch (n) {
            case 0: {
                return "N0";
            }
            case 1: {
                return "r";
            }
            case 2: {
                return "d";
            }
            case 3: {
                return "t";
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public double getArgument(int n) {
        switch (n) {
            case 0: {
                return this.getN0();
            }
            case 1: {
                return this.getGrowthRate();
            }
            case 2: {
                return this.getGrowthRate2();
            }
            case 3: {
                return this.getTime1();
            }
            case 4: {
                return this.getPlateauTime();
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setArgument(int n, double d) {
        switch (n) {
            case 0: {
                this.setN0(d);
                break;
            }
            case 1: {
                this.setGrowthRate(d);
                break;
            }
            case 2: {
                this.setGrowthRate2(d);
                break;
            }
            case 3: {
                this.setTime1(d);
                break;
            }
            case 4: {
                this.setPlateauTime(d);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public DemographicFunction getCopy() {
        ExpConstExpDemographic expConstExpDemographic = new ExpConstExpDemographic(this.getUnits());
        expConstExpDemographic.setN0(this.getN0());
        expConstExpDemographic.setGrowthRate(this.getGrowthRate());
        expConstExpDemographic.r2 = this.r2;
        expConstExpDemographic.time1 = this.time1;
        expConstExpDemographic.plateauTime = this.plateauTime;
        return expConstExpDemographic;
    }
}

