/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.athena.dataengine.metadata;

import com.simba.athena.athena.api.AJClient;
import com.simba.athena.athena.core.AJDriver;
import com.simba.athena.athena.dataengine.metadata.AJColumnMetadata;
import com.simba.athena.athena.exceptions.AJMessageKey;
import com.simba.athena.athena.utilities.AJMetadataHelperUtilities;
import com.simba.athena.dsi.dataengine.filters.IFilter;
import com.simba.athena.dsi.dataengine.interfaces.IMetadataSource;
import com.simba.athena.dsi.dataengine.utilities.DSITypeUtilities;
import com.simba.athena.dsi.dataengine.utilities.DataWrapper;
import com.simba.athena.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.simba.athena.dsi.dataengine.utilities.TypeUtilities;
import com.simba.athena.jdbc.utils.StringWrapperFilter;
import com.simba.athena.support.ILogger;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class AJColumnsMetadataSource
implements IMetadataSource {
    private ILogger m_logger;
    private AJClient m_client;
    private List<AJColumnMetadata> m_columnMetadataList = new ArrayList<AJColumnMetadata>();
    private ListIterator<AJColumnMetadata> m_columnMetadataIterator;
    private AJColumnMetadata m_currentColumnMetadata;

    public AJColumnsMetadataSource(ILogger iLogger, AJClient aJClient, ArrayList<IFilter> arrayList) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, aJClient, arrayList);
        this.m_logger = iLogger;
        this.m_client = aJClient;
        StringWrapperFilter stringWrapperFilter = null;
        StringWrapperFilter stringWrapperFilter2 = null;
        StringWrapperFilter stringWrapperFilter3 = null;
        StringWrapperFilter stringWrapperFilter4 = null;
        for (IFilter iFilter : arrayList) {
            switch (iFilter.getColumnTag()) {
                case CATALOG_NAME: {
                    stringWrapperFilter = new StringWrapperFilter(iFilter);
                    break;
                }
                case SCHEMA_NAME: {
                    stringWrapperFilter2 = new StringWrapperFilter(iFilter);
                    break;
                }
                case TABLE_NAME: {
                    stringWrapperFilter3 = new StringWrapperFilter(iFilter);
                    break;
                }
                case COLUMN_NAME: {
                    stringWrapperFilter4 = new StringWrapperFilter(iFilter);
                    break;
                }
            }
        }
        this.initMetadata(stringWrapperFilter, stringWrapperFilter2, stringWrapperFilter3, stringWrapperFilter4);
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.closeCursor();
        }
        catch (ErrorException errorException) {
            // empty catch block
        }
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentColumnMetadata.m_catalogName, dataWrapper, l, l2);
            }
            case SCHEMA_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentColumnMetadata.m_schemaName, dataWrapper, l, l2);
            }
            case TABLE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentColumnMetadata.m_tableName, dataWrapper, l, l2);
            }
            case COLUMN_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentColumnMetadata.m_columnName, dataWrapper, l, l2);
            }
            case DATA_TYPE: {
                dataWrapper.setInteger(this.m_currentColumnMetadata.m_sqlDataType);
                return false;
            }
            case DATA_TYPE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentColumnMetadata.m_typeName, dataWrapper, l, l2);
            }
            case COLUMN_SIZE: {
                dataWrapper.setInteger(AJMetadataHelperUtilities.getColumnSize(this.m_currentColumnMetadata.m_sqlDataType, this.m_currentColumnMetadata.m_decimalPrecision, this.m_currentColumnMetadata.m_characterColumnLength, this.m_currentColumnMetadata.m_binaryColumnLength));
                return false;
            }
            case BUFFER_LENGTH: {
                dataWrapper.setInteger(AJMetadataHelperUtilities.getBufferLength(this.m_currentColumnMetadata.m_sqlDataType, this.m_currentColumnMetadata.m_decimalPrecision, this.m_currentColumnMetadata.m_characterColumnLength, this.m_currentColumnMetadata.m_binaryColumnLength));
                return false;
            }
            case DECIMAL_DIGITS: {
                if (TypeUtilities.isExactNumericType(this.m_currentColumnMetadata.m_sqlDataType)) {
                    dataWrapper.setInteger(this.m_currentColumnMetadata.m_decimalScale);
                } else if (TypeUtilities.isTimeType(this.m_currentColumnMetadata.m_sqlDataType)) {
                    dataWrapper.setInteger(3L);
                } else {
                    dataWrapper.setNull(4);
                }
                return false;
            }
            case NUM_PREC_RADIX: {
                int n = TypeUtilities.getNumPrecRadix((short)this.m_currentColumnMetadata.m_sqlDataType);
                if (0 == n) {
                    dataWrapper.setNull(4);
                } else {
                    dataWrapper.setInteger(n);
                }
                return false;
            }
            case NULLABLE: {
                dataWrapper.setInteger(1L);
                return false;
            }
            case REMARKS: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentColumnMetadata.m_remarks, dataWrapper, l, l2);
            }
            case COLUMN_DEF: {
                dataWrapper.setNull(12);
                return false;
            }
            case SQL_DATA_TYPE: {
                dataWrapper.setInteger(TypeUtilities.getVerboseTypeFromConciseType(this.m_currentColumnMetadata.m_sqlDataType));
                return false;
            }
            case SQL_DATETIME_SUB: {
                short s = TypeUtilities.getIntervalCodeFromConciseType(this.m_currentColumnMetadata.m_sqlDataType);
                if (0 == s) {
                    dataWrapper.setNull(4);
                } else {
                    dataWrapper.setInteger(s);
                }
                return false;
            }
            case CHAR_OCTET_LENGTH: {
                if (TypeUtilities.isCharacterType(this.m_currentColumnMetadata.m_sqlDataType)) {
                    dataWrapper.setInteger(this.m_currentColumnMetadata.m_characterColumnLength * 4);
                } else {
                    dataWrapper.setNull(4);
                }
                return false;
            }
            case ORDINAL_POSITION: {
                dataWrapper.setInteger(this.m_currentColumnMetadata.m_ordinalPosition);
                return false;
            }
            case IS_NULLABLE: {
                return DSITypeUtilities.outputVarCharStringData("YES", dataWrapper, l, l2);
            }
            case USER_DATA_TYPE: {
                dataWrapper.setNull(5);
                return false;
            }
            case IS_AUTOINCREMENT: {
                dataWrapper.setVarChar("");
                return false;
            }
            case IS_GENERATEDCOLUMN: {
                dataWrapper.setVarChar("");
                return false;
            }
        }
        throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.METADATA_COLUMN_NOT_FOUND.name(), new String[]{metadataSourceColumnTag.toString()});
    }

    @Override
    public boolean hasMoreRows() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_columnMetadataIterator.hasNext();
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.hasMoreRows()) {
            this.m_currentColumnMetadata = this.m_columnMetadataIterator.next();
            return true;
        }
        return false;
    }

    private void initMetadata(StringWrapperFilter stringWrapperFilter, StringWrapperFilter stringWrapperFilter2, StringWrapperFilter stringWrapperFilter3, StringWrapperFilter stringWrapperFilter4) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, stringWrapperFilter, stringWrapperFilter2, stringWrapperFilter3, stringWrapperFilter4);
        if (stringWrapperFilter.filter("AwsDataCatalog")) {
            ArrayList<String> arrayList = new ArrayList<String>();
            this.m_client.getSchemas(arrayList);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (String string : arrayList) {
                if (!stringWrapperFilter2.filter(string)) continue;
                arrayList2.add(string);
            }
            for (String string : arrayList2) {
                this.m_client.getColumnsMetadata(string, stringWrapperFilter3, stringWrapperFilter4, this.m_columnMetadataList);
            }
        }
        this.m_columnMetadataIterator = this.m_columnMetadataList.listIterator(0);
    }
}

