/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.glue.model;

import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.protocol.ProtocolMarshaller;
import com.simba.athena.amazonaws.protocol.StructuredPojo;
import com.simba.athena.amazonaws.services.glue.model.Column;
import com.simba.athena.amazonaws.services.glue.model.Order;
import com.simba.athena.amazonaws.services.glue.model.SerDeInfo;
import com.simba.athena.amazonaws.services.glue.model.SkewedInfo;
import com.simba.athena.amazonaws.services.glue.model.transform.StorageDescriptorMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StorageDescriptor
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Column> columns;
    private String location;
    private String inputFormat;
    private String outputFormat;
    private Boolean compressed;
    private Integer numberOfBuckets;
    private SerDeInfo serdeInfo;
    private List<String> bucketColumns;
    private List<Order> sortColumns;
    private Map<String, String> parameters;
    private SkewedInfo skewedInfo;
    private Boolean storedAsSubDirectories;

    public List<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(Collection<Column> columns) {
        if (columns == null) {
            this.columns = null;
            return;
        }
        this.columns = new ArrayList<Column>(columns);
    }

    public StorageDescriptor withColumns(Column ... columns) {
        if (this.columns == null) {
            this.setColumns(new ArrayList<Column>(columns.length));
        }
        for (Column ele : columns) {
            this.columns.add(ele);
        }
        return this;
    }

    public StorageDescriptor withColumns(Collection<Column> columns) {
        this.setColumns(columns);
        return this;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public StorageDescriptor withLocation(String location) {
        this.setLocation(location);
        return this;
    }

    public void setInputFormat(String inputFormat) {
        this.inputFormat = inputFormat;
    }

    public String getInputFormat() {
        return this.inputFormat;
    }

    public StorageDescriptor withInputFormat(String inputFormat) {
        this.setInputFormat(inputFormat);
        return this;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public StorageDescriptor withOutputFormat(String outputFormat) {
        this.setOutputFormat(outputFormat);
        return this;
    }

    public void setCompressed(Boolean compressed) {
        this.compressed = compressed;
    }

    public Boolean getCompressed() {
        return this.compressed;
    }

    public StorageDescriptor withCompressed(Boolean compressed) {
        this.setCompressed(compressed);
        return this;
    }

    public Boolean isCompressed() {
        return this.compressed;
    }

    public void setNumberOfBuckets(Integer numberOfBuckets) {
        this.numberOfBuckets = numberOfBuckets;
    }

    public Integer getNumberOfBuckets() {
        return this.numberOfBuckets;
    }

    public StorageDescriptor withNumberOfBuckets(Integer numberOfBuckets) {
        this.setNumberOfBuckets(numberOfBuckets);
        return this;
    }

    public void setSerdeInfo(SerDeInfo serdeInfo) {
        this.serdeInfo = serdeInfo;
    }

    public SerDeInfo getSerdeInfo() {
        return this.serdeInfo;
    }

    public StorageDescriptor withSerdeInfo(SerDeInfo serdeInfo) {
        this.setSerdeInfo(serdeInfo);
        return this;
    }

    public List<String> getBucketColumns() {
        return this.bucketColumns;
    }

    public void setBucketColumns(Collection<String> bucketColumns) {
        if (bucketColumns == null) {
            this.bucketColumns = null;
            return;
        }
        this.bucketColumns = new ArrayList<String>(bucketColumns);
    }

    public StorageDescriptor withBucketColumns(String ... bucketColumns) {
        if (this.bucketColumns == null) {
            this.setBucketColumns(new ArrayList<String>(bucketColumns.length));
        }
        for (String ele : bucketColumns) {
            this.bucketColumns.add(ele);
        }
        return this;
    }

    public StorageDescriptor withBucketColumns(Collection<String> bucketColumns) {
        this.setBucketColumns(bucketColumns);
        return this;
    }

    public List<Order> getSortColumns() {
        return this.sortColumns;
    }

    public void setSortColumns(Collection<Order> sortColumns) {
        if (sortColumns == null) {
            this.sortColumns = null;
            return;
        }
        this.sortColumns = new ArrayList<Order>(sortColumns);
    }

    public StorageDescriptor withSortColumns(Order ... sortColumns) {
        if (this.sortColumns == null) {
            this.setSortColumns(new ArrayList<Order>(sortColumns.length));
        }
        for (Order ele : sortColumns) {
            this.sortColumns.add(ele);
        }
        return this;
    }

    public StorageDescriptor withSortColumns(Collection<Order> sortColumns) {
        this.setSortColumns(sortColumns);
        return this;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public StorageDescriptor withParameters(Map<String, String> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public StorageDescriptor addParametersEntry(String key, String value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, String>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public StorageDescriptor clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public void setSkewedInfo(SkewedInfo skewedInfo) {
        this.skewedInfo = skewedInfo;
    }

    public SkewedInfo getSkewedInfo() {
        return this.skewedInfo;
    }

    public StorageDescriptor withSkewedInfo(SkewedInfo skewedInfo) {
        this.setSkewedInfo(skewedInfo);
        return this;
    }

    public void setStoredAsSubDirectories(Boolean storedAsSubDirectories) {
        this.storedAsSubDirectories = storedAsSubDirectories;
    }

    public Boolean getStoredAsSubDirectories() {
        return this.storedAsSubDirectories;
    }

    public StorageDescriptor withStoredAsSubDirectories(Boolean storedAsSubDirectories) {
        this.setStoredAsSubDirectories(storedAsSubDirectories);
        return this;
    }

    public Boolean isStoredAsSubDirectories() {
        return this.storedAsSubDirectories;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getColumns() != null) {
            sb.append("Columns: ").append(this.getColumns()).append(",");
        }
        if (this.getLocation() != null) {
            sb.append("Location: ").append(this.getLocation()).append(",");
        }
        if (this.getInputFormat() != null) {
            sb.append("InputFormat: ").append(this.getInputFormat()).append(",");
        }
        if (this.getOutputFormat() != null) {
            sb.append("OutputFormat: ").append(this.getOutputFormat()).append(",");
        }
        if (this.getCompressed() != null) {
            sb.append("Compressed: ").append(this.getCompressed()).append(",");
        }
        if (this.getNumberOfBuckets() != null) {
            sb.append("NumberOfBuckets: ").append(this.getNumberOfBuckets()).append(",");
        }
        if (this.getSerdeInfo() != null) {
            sb.append("SerdeInfo: ").append(this.getSerdeInfo()).append(",");
        }
        if (this.getBucketColumns() != null) {
            sb.append("BucketColumns: ").append(this.getBucketColumns()).append(",");
        }
        if (this.getSortColumns() != null) {
            sb.append("SortColumns: ").append(this.getSortColumns()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getSkewedInfo() != null) {
            sb.append("SkewedInfo: ").append(this.getSkewedInfo()).append(",");
        }
        if (this.getStoredAsSubDirectories() != null) {
            sb.append("StoredAsSubDirectories: ").append(this.getStoredAsSubDirectories());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageDescriptor)) {
            return false;
        }
        StorageDescriptor other = (StorageDescriptor)obj;
        if (other.getColumns() == null ^ this.getColumns() == null) {
            return false;
        }
        if (other.getColumns() != null && !other.getColumns().equals(this.getColumns())) {
            return false;
        }
        if (other.getLocation() == null ^ this.getLocation() == null) {
            return false;
        }
        if (other.getLocation() != null && !other.getLocation().equals(this.getLocation())) {
            return false;
        }
        if (other.getInputFormat() == null ^ this.getInputFormat() == null) {
            return false;
        }
        if (other.getInputFormat() != null && !other.getInputFormat().equals(this.getInputFormat())) {
            return false;
        }
        if (other.getOutputFormat() == null ^ this.getOutputFormat() == null) {
            return false;
        }
        if (other.getOutputFormat() != null && !other.getOutputFormat().equals(this.getOutputFormat())) {
            return false;
        }
        if (other.getCompressed() == null ^ this.getCompressed() == null) {
            return false;
        }
        if (other.getCompressed() != null && !other.getCompressed().equals(this.getCompressed())) {
            return false;
        }
        if (other.getNumberOfBuckets() == null ^ this.getNumberOfBuckets() == null) {
            return false;
        }
        if (other.getNumberOfBuckets() != null && !other.getNumberOfBuckets().equals(this.getNumberOfBuckets())) {
            return false;
        }
        if (other.getSerdeInfo() == null ^ this.getSerdeInfo() == null) {
            return false;
        }
        if (other.getSerdeInfo() != null && !other.getSerdeInfo().equals(this.getSerdeInfo())) {
            return false;
        }
        if (other.getBucketColumns() == null ^ this.getBucketColumns() == null) {
            return false;
        }
        if (other.getBucketColumns() != null && !other.getBucketColumns().equals(this.getBucketColumns())) {
            return false;
        }
        if (other.getSortColumns() == null ^ this.getSortColumns() == null) {
            return false;
        }
        if (other.getSortColumns() != null && !other.getSortColumns().equals(this.getSortColumns())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getSkewedInfo() == null ^ this.getSkewedInfo() == null) {
            return false;
        }
        if (other.getSkewedInfo() != null && !other.getSkewedInfo().equals(this.getSkewedInfo())) {
            return false;
        }
        if (other.getStoredAsSubDirectories() == null ^ this.getStoredAsSubDirectories() == null) {
            return false;
        }
        return other.getStoredAsSubDirectories() == null || other.getStoredAsSubDirectories().equals(this.getStoredAsSubDirectories());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getColumns() == null ? 0 : this.getColumns().hashCode());
        hashCode = 31 * hashCode + (this.getLocation() == null ? 0 : this.getLocation().hashCode());
        hashCode = 31 * hashCode + (this.getInputFormat() == null ? 0 : this.getInputFormat().hashCode());
        hashCode = 31 * hashCode + (this.getOutputFormat() == null ? 0 : this.getOutputFormat().hashCode());
        hashCode = 31 * hashCode + (this.getCompressed() == null ? 0 : this.getCompressed().hashCode());
        hashCode = 31 * hashCode + (this.getNumberOfBuckets() == null ? 0 : this.getNumberOfBuckets().hashCode());
        hashCode = 31 * hashCode + (this.getSerdeInfo() == null ? 0 : this.getSerdeInfo().hashCode());
        hashCode = 31 * hashCode + (this.getBucketColumns() == null ? 0 : this.getBucketColumns().hashCode());
        hashCode = 31 * hashCode + (this.getSortColumns() == null ? 0 : this.getSortColumns().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getSkewedInfo() == null ? 0 : this.getSkewedInfo().hashCode());
        hashCode = 31 * hashCode + (this.getStoredAsSubDirectories() == null ? 0 : this.getStoredAsSubDirectories().hashCode());
        return hashCode;
    }

    public StorageDescriptor clone() {
        try {
            return (StorageDescriptor)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StorageDescriptorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

