/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.core.driftdetection;

import moa.classifiers.core.driftdetection.AbstractChangeDetector;
import moa.core.ObjectRepository;
import moa.tasks.TaskMonitor;

public class EDDM
extends AbstractChangeDetector {
    private static final long serialVersionUID = 140980267062162000L;
    private static final double FDDM_OUTCONTROL = 0.9;
    private static final double FDDM_WARNING = 0.95;
    private static final double FDDM_MINNUMINSTANCES = 30.0;
    private double m_numErrors;
    private int m_minNumErrors = 30;
    private int m_n;
    private int m_d;
    private int m_lastd;
    private double m_mean;
    private double m_stdTemp;
    private double m_m2smax;
    private int m_lastLevel;

    public EDDM() {
        this.resetLearning();
    }

    @Override
    public void resetLearning() {
        this.m_n = 1;
        this.m_numErrors = 0.0;
        this.m_d = 0;
        this.m_lastd = 0;
        this.m_mean = 0.0;
        this.m_stdTemp = 0.0;
        this.m_m2smax = 0.0;
        this.estimation = 0.0;
    }

    @Override
    public void input(double prediction) {
        if (this.isChangeDetected || !this.isInitialized) {
            this.resetLearning();
            this.isInitialized = true;
        }
        this.isChangeDetected = false;
        ++this.m_n;
        if (prediction == 1.0) {
            this.isWarningZone = false;
            this.delay = 0.0;
            this.m_numErrors += 1.0;
            this.m_lastd = this.m_d;
            this.m_d = this.m_n - 1;
            int distance = this.m_d - this.m_lastd;
            double oldmean = this.m_mean;
            this.m_mean += ((double)distance - this.m_mean) / this.m_numErrors;
            this.estimation = this.m_mean;
            this.m_stdTemp += ((double)distance - this.m_mean) * ((double)distance - oldmean);
            double std = Math.sqrt(this.m_stdTemp / this.m_numErrors);
            double m2s = this.m_mean + 2.0 * std;
            if (m2s > this.m_m2smax) {
                if ((double)this.m_n > 30.0) {
                    this.m_m2smax = m2s;
                }
            } else {
                double p = m2s / this.m_m2smax;
                if ((double)this.m_n > 30.0 && this.m_numErrors > (double)this.m_minNumErrors && p < 0.9) {
                    this.isChangeDetected = true;
                } else {
                    this.isWarningZone = (double)this.m_n > 30.0 && this.m_numErrors > (double)this.m_minNumErrors && p < 0.95;
                }
            }
        }
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
    }
}

