/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.xpdl;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.util.Properties;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.vikamine.kernel.xpdl.XMLException;

public class CheckXMLValid {
    public static boolean checkValid(Document doc, String xsdPath, Boolean dc) {
        SAXBuilder sax = new SAXBuilder(true);
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        String temp = outputter.outputString(doc);
        StringReader reader = new StringReader(temp);
        sax.setFeature("http://apache.org/xml/features/validation/schema", true);
        if (!dc.booleanValue()) {
            sax.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", xsdPath);
        } else {
            sax.setFeature("http://apache.org/xml/features/validation/schema", true);
            sax.setFeature("http://xml.org/sax/features/validation", true);
            sax.setFeature("http://xml.org/sax/features/namespaces", true);
            sax.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", "c:\\SGPlugin\\XSD\\output.xsd");
        }
        try {
            sax.build(reader);
            return true;
        }
        catch (JDOMException e) {
            e.printStackTrace();
            throw new XMLException("XML-Datei nicht valide");
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return false;
        }
    }

    public static boolean checkValid(Document doc, String xsdPath) {
        SAXBuilder sax = new SAXBuilder(false);
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        String temp = outputter.outputString(doc);
        StringReader reader = new StringReader(temp);
        sax.setFeature("http://apache.org/xml/features/validation/schema", false);
        sax.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", xsdPath);
        try {
            sax.build(reader);
            return true;
        }
        catch (JDOMException e) {
            e.printStackTrace();
            throw new XMLException("XML-Datei nicht valide");
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return false;
        }
    }

    public static boolean checkValid(Document toCheck) {
        Properties properties = new Properties();
        try {
            try {
                FileInputStream stream = new FileInputStream(CheckXMLValid.class.getClass().getResource("/resources/xml/xsd.properties").toURI().getPath());
                properties.load(stream);
                stream.close();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Properties File not found");
            System.out.println(e.getMessage());
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        String schemaLocation = CheckXMLValid.class.getClass().getResource("/resources/xml/") + properties.getProperty("outputXsd");
        return CheckXMLValid.checkValid(toCheck, schemaLocation);
    }
}

